/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.views.properties.tabbed.override.folders;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.tests.views.properties.tabbed.model.Element;
import org.eclipse.ui.tests.views.properties.tabbed.override.OverrideTestsSelection;
import org.eclipse.ui.tests.views.properties.tabbed.override.OverrideTestsView;
import org.eclipse.ui.tests.views.properties.tabbed.override.folders.AdvancedTabFolder;
import org.eclipse.ui.tests.views.properties.tabbed.override.folders.BasicTabFolder;
import org.eclipse.ui.tests.views.properties.tabbed.override.folders.EmptyTabFolder;
import org.eclipse.ui.tests.views.properties.tabbed.override.folders.IOverrideTestsTabFolder;
import org.eclipse.ui.tests.views.properties.tabbed.override.folders.IOverrideTestsTabItemSelectionListener;
import org.eclipse.ui.tests.views.properties.tabbed.override.items.IOverrideTestsItem;

public class OverrideTestsTabFolderPropertySheetPageContentManager
implements IOverrideTestsTabItemSelectionListener {
    private IOverrideTestsTabFolder activeFolder;
    private Composite composite;
    private IOverrideTestsTabFolder emptyFolder;
    private IOverrideTestsTabFolder[] folders;
    private OverrideTestsView overrideTestsView;

    public OverrideTestsTabFolderPropertySheetPageContentManager(Composite parent) {
        this.composite = parent;
        this.folders = new IOverrideTestsTabFolder[]{new BasicTabFolder(), new AdvancedTabFolder()};
        this.emptyFolder = new EmptyTabFolder();
    }

    @Override
    public void itemSelected(IOverrideTestsItem item) {
        this.overrideTestsView.setSelection(item.getElement());
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        Assert.isTrue((boolean)(part instanceof OverrideTestsView));
        this.overrideTestsView = (OverrideTestsView)part;
        Assert.isTrue((boolean)(selection instanceof OverrideTestsSelection));
        Element element = ((OverrideTestsSelection)selection).getElement();
        IOverrideTestsTabFolder newFolder = null;
        if (element == null) {
            newFolder = this.emptyFolder;
        } else {
            int i = 0;
            while (i < this.folders.length) {
                if (this.folders[i].appliesTo(element)) {
                    newFolder = this.folders[i];
                    break;
                }
                ++i;
            }
        }
        Assert.isTrue((newFolder != null ? 1 : 0) != 0);
        if (newFolder != this.activeFolder) {
            if (this.activeFolder != null) {
                this.activeFolder.removeItemSelectionListener(this);
                this.activeFolder.dispose();
            }
            this.activeFolder = newFolder;
            newFolder.createControls(this.composite);
            this.composite.layout(true);
            this.activeFolder.addItemSelectionListener(this);
        }
        if (element != null) {
            this.activeFolder.selectionChanged(element);
        }
    }
}

