/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.views.properties.tabbed.override.tablist;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.tests.views.properties.tabbed.model.Element;
import org.eclipse.ui.tests.views.properties.tabbed.override.items.IOverrideTestsItem;
import org.eclipse.ui.tests.views.properties.tabbed.override.tablist.IOverrideTestsTabList;
import org.eclipse.ui.tests.views.properties.tabbed.override.tablist.OverrideTestsTabItem;
import org.eclipse.ui.views.properties.tabbed.ITabItem;

public abstract class AbstractTabList
implements IOverrideTestsTabList {
    private Composite composite;
    private int selectedTabItem;

    @Override
    public boolean appliesTo(Element element) {
        return false;
    }

    @Override
    public void createControls(Composite parent) {
        this.composite = parent;
        OverrideTestsTabItem activeTab = (OverrideTestsTabItem)this.getTabs()[this.selectedTabItem];
        activeTab.getItem().createControls(parent);
    }

    @Override
    public void dispose() {
        OverrideTestsTabItem activeTab = (OverrideTestsTabItem)this.getTabs()[this.selectedTabItem];
        activeTab.getItem().dispose();
    }

    public ITabItem[] getTabs() {
        IOverrideTestsItem[] items = this.getItems();
        ITabItem[] tabs = new OverrideTestsTabItem[items.length];
        int i = 0;
        while (i < items.length) {
            tabs[i] = new OverrideTestsTabItem(items[i]);
            if (i == this.selectedTabItem) {
                tabs[i].setSelected(true);
            }
            ++i;
        }
        return tabs;
    }

    @Override
    public void selectionChanged(Element element) {
        ITabItem[] tabs = this.getTabs();
        int i = 0;
        while (i < tabs.length) {
            if (tabs[i].getText().equals(element.getName())) {
                this.selectedTabItem = i;
                break;
            }
            ++i;
        }
    }

    public void selectTab(int index) {
        if (this.selectedTabItem == index) {
            return;
        }
        OverrideTestsTabItem activeTab = (OverrideTestsTabItem)this.getTabs()[this.selectedTabItem];
        activeTab.getItem().dispose();
        this.selectedTabItem = index;
        activeTab = (OverrideTestsTabItem)this.getTabs()[this.selectedTabItem];
        activeTab.getItem().createControls(this.composite);
        this.composite.layout(true);
    }
}

