/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.views.properties.tabbed.override.tablist;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.tests.views.properties.tabbed.model.Element;
import org.eclipse.ui.tests.views.properties.tabbed.override.OverrideTestsSelection;
import org.eclipse.ui.tests.views.properties.tabbed.override.OverrideTestsView;
import org.eclipse.ui.tests.views.properties.tabbed.override.tablist.AdvancedTabList;
import org.eclipse.ui.tests.views.properties.tabbed.override.tablist.BasicTabList;
import org.eclipse.ui.tests.views.properties.tabbed.override.tablist.EmptyTabList;
import org.eclipse.ui.tests.views.properties.tabbed.override.tablist.IOverrideTestsTabList;
import org.eclipse.ui.tests.views.properties.tabbed.override.tablist.OverrideTestsTabItem;
import org.eclipse.ui.views.properties.tabbed.ISection;
import org.eclipse.ui.views.properties.tabbed.ITabItem;
import org.eclipse.ui.views.properties.tabbed.TabContents;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class OverrideTestsTabListsContentsManager {
    private Element activeElement;
    private IOverrideTestsTabList activeFolder;
    private ITabItem[] activeTabs;
    private Composite composite;
    private IOverrideTestsTabList emptyFolder;
    private IOverrideTestsTabList[] folders;
    private boolean processingUpdateTabs;
    private OverrideTestsView sampleView;
    private ISection section;
    private TabbedPropertySheetPage tabbedPropertySheetPage;

    public OverrideTestsTabListsContentsManager(Composite aComposite, TabbedPropertySheetPage aTabbedPropertySheetPage, ISection aSection) {
        this.composite = aComposite;
        this.section = aSection;
        this.tabbedPropertySheetPage = aTabbedPropertySheetPage;
        this.folders = new IOverrideTestsTabList[]{new BasicTabList(), new AdvancedTabList()};
        this.emptyFolder = new EmptyTabList();
    }

    private boolean compareTab(OverrideTestsTabItem a, OverrideTestsTabItem b) {
        return a.getItem().equals(b.getItem()) && a.isSelected() == b.isSelected() && a.getText().equals(b.getText());
    }

    private boolean compareTabs(ITabItem[] a, ITabItem[] b) {
        if (a != null && b != null) {
            if (a.length != b.length) {
                return false;
            }
            int i = 0;
            while (i < a.length) {
                if (!this.compareTab((OverrideTestsTabItem)a[i], (OverrideTestsTabItem)b[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return a == null && b == null;
    }

    public void dispose() {
        if (this.activeFolder != null) {
            this.activeFolder.dispose();
        }
    }

    public ITabItem[] getTabs() {
        if (this.activeFolder != null) {
            return this.activeFolder.getTabs();
        }
        return new ITabItem[0];
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (this.composite.isDisposed()) {
            return;
        }
        if (this.processingUpdateTabs) {
            return;
        }
        if (!this.validateSection()) {
            return;
        }
        Assert.isTrue((boolean)(part instanceof OverrideTestsView));
        this.sampleView = (OverrideTestsView)part;
        Assert.isTrue((boolean)(selection instanceof OverrideTestsSelection));
        Element newElement = ((OverrideTestsSelection)selection).getElement();
        IOverrideTestsTabList newFolder = null;
        if (newElement == null) {
            newFolder = this.emptyFolder;
        } else {
            int i = 0;
            while (i < this.folders.length) {
                if (this.folders[i].appliesTo(newElement)) {
                    newFolder = this.folders[i];
                    break;
                }
                ++i;
            }
        }
        if (newFolder != this.activeFolder) {
            if (this.activeFolder != null) {
                this.activeFolder.dispose();
                this.activeFolder = null;
            }
            this.activeFolder = newFolder;
            if (newElement != null) {
                this.activeFolder.selectionChanged(newElement);
            }
            newFolder.createControls(this.composite);
            this.composite.layout(true);
        } else if (newElement != this.activeElement) {
            this.activeFolder.dispose();
            if (newElement != null) {
                this.activeFolder.selectionChanged(newElement);
            }
            this.activeFolder.createControls(this.composite);
            this.composite.layout(true);
            this.activeElement = newElement;
            return;
        }
        ITabItem[] newTabs = this.activeFolder.getTabs();
        if (!this.compareTabs(newTabs, this.activeTabs)) {
            this.processingUpdateTabs = true;
            this.tabbedPropertySheetPage.overrideTabs();
            this.processingUpdateTabs = false;
            this.activeTabs = newTabs;
        }
    }

    public void selectTab(int index) {
        if (this.activeTabs == null) {
            return;
        }
        OverrideTestsTabItem selectedTab = (OverrideTestsTabItem)this.activeTabs[index];
        this.sampleView.setSelection(selectedTab.getItem().getElement());
        OverrideTestsSelection selection = (OverrideTestsSelection)this.sampleView.getSelection();
        Element newElement = selection.getElement();
        this.activeFolder.dispose();
        this.activeFolder.selectionChanged(newElement);
        this.activeFolder.createControls(this.composite);
        this.composite.layout(true);
        this.activeElement = newElement;
        this.activeTabs = this.getTabs();
    }

    private boolean validateSection() {
        ISection[] sections;
        TabContents tab = this.tabbedPropertySheetPage.getCurrentTab();
        if (tab != null && (sections = tab.getSections()) != null) {
            int i = 0;
            while (i < sections.length) {
                if (sections[i] == this.section) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

