/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.workbench.texteditor.tests;

import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.internal.texteditor.quickdiff.DocumentLineDiffer;
import org.junit.Assert;
import org.junit.Test;

public class DocumentLineDifferTest {
    private Document fDocument = new Document();
    private DocumentLineDiffer fLineDiffer = new DocumentLineDiffer();

    @Test
    public void testLineDifferStateAfterConnectingDocument() throws Exception {
        this.fLineDiffer.connect((IDocument)this.fDocument);
        Assert.assertFalse((boolean)this.fLineDiffer.isSuspended());
        Assert.assertFalse((boolean)this.fLineDiffer.isSynchronized());
    }

    @Test
    public void suspendSuspendsLineDiffer() throws Exception {
        this.fLineDiffer.connect((IDocument)this.fDocument);
        this.fLineDiffer.suspend();
        Assert.assertTrue((boolean)this.fLineDiffer.isSuspended());
    }

    @Test
    public void lineDifferNotSuspendedAfterResumeIsCalled() throws Exception {
        this.fLineDiffer.connect((IDocument)this.fDocument);
        this.fLineDiffer.suspend();
        this.fLineDiffer.resume();
        Assert.assertFalse((boolean)this.fLineDiffer.isSuspended());
        Assert.assertFalse((boolean)this.fLineDiffer.isSynchronized());
    }

    @Test
    public void nonSuspendedLineDifferNotSuspendedAfterStartRewriteSession() throws Exception {
        this.fLineDiffer.connect((IDocument)this.fDocument);
        this.fDocument.startRewriteSession(DocumentRewriteSessionType.SEQUENTIAL);
        Assert.assertTrue((boolean)this.fLineDiffer.isSuspended());
    }

    @Test
    public void suspendedLineDifferStillSuspendedAfterStopRewriteSession() throws Exception {
        this.fLineDiffer.connect((IDocument)this.fDocument);
        this.fLineDiffer.suspend();
        this.fDocument.stopRewriteSession(this.fDocument.getActiveRewriteSession());
        Assert.assertTrue((boolean)this.fLineDiffer.isSuspended());
    }

    @Test
    public void suspendedLineDifferStaysSuspendedAfterDocumentRewriteSession() throws Exception {
        this.fLineDiffer.connect((IDocument)this.fDocument);
        this.fLineDiffer.suspend();
        this.fDocument.startRewriteSession(DocumentRewriteSessionType.SEQUENTIAL);
        this.fDocument.stopRewriteSession(this.fDocument.getActiveRewriteSession());
        Assert.assertTrue((boolean)this.fLineDiffer.isSuspended());
    }

    @Test
    public void nonSuspendedLineDifferStaysNonSuspendedAfterDocumentRewriteSession() throws Exception {
        this.fLineDiffer.connect((IDocument)this.fDocument);
        this.fDocument.startRewriteSession(DocumentRewriteSessionType.SEQUENTIAL);
        this.fDocument.stopRewriteSession(this.fDocument.getActiveRewriteSession());
        Assert.assertFalse((boolean)this.fLineDiffer.isSuspended());
    }
}

