/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.workbench.texteditor.tests.minimap;

import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.views.minimap.MinimapPage;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.StatusTextEditor;
import org.junit.Assert;
import org.junit.Test;

public class MinimapPageTest {
    @Test
    public void createNoneMinimapPage() {
        MyTextEditor textEditor = new MyTextEditor(TextVieverAdapterKind.None);
        MinimapPage page = MinimapPage.createMinimapPage((ITextEditor)textEditor);
        Assert.assertNull((Object)page);
    }

    @Test
    public void createMinimapPageWithITextViewerAdapter() {
        MyTextEditor textEditor = new MyTextEditor(TextVieverAdapterKind.ITextViewer);
        MinimapPage page = MinimapPage.createMinimapPage((ITextEditor)textEditor);
        Assert.assertNotNull((Object)page);
    }

    @Test
    public void createMinimapPageWithITextOperationTargetAdapter() {
        MyTextEditor textEditor = new MyTextEditor(TextVieverAdapterKind.ITextOperationTarget);
        MinimapPage page = MinimapPage.createMinimapPage((ITextEditor)textEditor);
        Assert.assertNotNull((Object)page);
    }

    class MyTextEditor
    extends StatusTextEditor {
        private final TextVieverAdapterKind kind;

        public MyTextEditor(TextVieverAdapterKind kind) {
            this.kind = kind;
        }

        public <T> T getAdapter(Class<T> required) {
            switch (this.kind) {
                case ITextViewer: {
                    if (ITextViewer.class.equals(required)) {
                        Shell parent = new Shell();
                        return required.cast(new TextViewer((Composite)parent, 0));
                    }
                }
                case ITextOperationTarget: {
                    if (!ITextOperationTarget.class.equals(required)) break;
                    Shell parent = new Shell();
                    return required.cast(new TextViewer((Composite)parent, 0));
                }
            }
            return null;
        }
    }

    static enum TextVieverAdapterKind {
        None,
        ITextViewer,
        ITextOperationTarget;

    }
}

