/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.api.jakarta_el.elprocessor;

import com.sun.ts.tests.el.common.util.ELTestUtil;
import jakarta.el.ELProcessor;
import java.lang.reflect.Method;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class ELClientIT {
    private static final System.Logger logger = System.getLogger(ELClientIT.class.getName());

    @AfterEach
    public void cleanup() throws Exception {
        logger.log(System.Logger.Level.INFO, "Cleanup method called");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void elProcessorDefineFunctionNPETest() throws Exception {
        ELProcessor elp = new ELProcessor();
        try {
            Method meth = elp.getClass().getMethod("toString", new Class[0]);
            logger.log(System.Logger.Level.INFO, "Testing: ELProcessor.defineFunction(null, function, meth)");
            ELTestUtil.checkForNPE(elp, "defineFunction", new Class[]{String.class, String.class, Method.class}, new Object[]{null, "function", meth});
            logger.log(System.Logger.Level.INFO, "Testing: ELProcessor.defineFunction(prefix, null, meth)");
            ELTestUtil.checkForNPE(elp, "defineFunction", new Class[]{String.class, String.class, Method.class}, new Object[]{"prefix", null, meth});
            logger.log(System.Logger.Level.INFO, "Testing: ELProcessor.defineFunction(prefix, function, null)");
            ELTestUtil.checkForNPE(elp, "defineFunction", new Class[]{String.class, String.class, Method.class}, new Object[]{"prefix", "function", null});
            logger.log(System.Logger.Level.INFO, "Testing: ELProcessor.defineFunction(prefix, function, className, null)");
            ELTestUtil.checkForNPE(elp, "defineFunction", new Class[]{String.class, String.class, String.class, String.class}, new Object[]{"prefix", "function", "className", null});
            logger.log(System.Logger.Level.INFO, "Testing: ELProcessor.defineFunction(prefix, function, null, method)");
            ELTestUtil.checkForNPE(elp, "defineFunction", new Class[]{String.class, String.class, String.class, String.class}, new Object[]{"prefix", "function", null, "method"});
            logger.log(System.Logger.Level.INFO, "Testing: ELProcessor.defineFunction(prefix, null, className, method)");
            ELTestUtil.checkForNPE(elp, "defineFunction", new Class[]{String.class, String.class, String.class, String.class}, new Object[]{"prefix", null, "className", "method"});
            logger.log(System.Logger.Level.INFO, "Testing: ELProcessor.defineFunction(null, function, className, method)");
            ELTestUtil.checkForNPE(elp, "defineFunction", new Class[]{String.class, String.class, String.class, String.class}, new Object[]{null, "function", "className", "method"});
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException nsme) {
            nsme.printStackTrace();
        }
    }

    @Test
    public void elProcessorDefineFunctionCNFETest() throws Exception {
        ELProcessor elp = new ELProcessor();
        logger.log(System.Logger.Level.INFO, "Testing: ELProcessor.defineFunction(null, function, className, method)");
        ELTestUtil.checkForCNFE(elp, "defineFunction", new Class[]{String.class, String.class, String.class, String.class}, new Object[]{"prefix", "function", "bogus", "method"});
    }

    @Test
    public void elProcessorDefineFunctionNSMETest() throws Exception {
        ELProcessor elp = new ELProcessor();
        logger.log(System.Logger.Level.INFO, "Testing: ELProcessor.defineFunction(null, function, className, method)");
        ELTestUtil.checkForCNFE(elp, "defineFunction", new Class[]{String.class, String.class, String.class, String.class}, new Object[]{"prefix", "function", "java.util.String", "bogus"});
    }
}

