/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.api.jakarta_el.beanelresolver;

import com.sun.ts.tests.el.common.api.resolver.ResolverTest;
import com.sun.ts.tests.el.common.elcontext.BareBonesELContext;
import com.sun.ts.tests.el.common.util.ELTestUtil;
import com.sun.ts.tests.el.common.util.SimpleBean;
import jakarta.el.BeanELResolver;
import jakarta.el.ELContext;
import jakarta.el.ELResolver;
import java.util.TimeZone;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class ELClientIT {
    private static final System.Logger logger = System.getLogger(ELClientIT.class.getName());
    private SimpleBean sb = new SimpleBean();

    @AfterEach
    public void cleanup() throws Exception {
        logger.log(System.Logger.Level.INFO, "Cleanup method called");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void beanELResolverTest() throws Exception {
        boolean pass = false;
        StringBuffer buf = new StringBuffer();
        this.sb.setIntention("initial_setting");
        try {
            BeanELResolver beanResolver = new BeanELResolver();
            BareBonesELContext barebonesContext = new BareBonesELContext();
            ELContext context = barebonesContext.getELContext();
            pass = ResolverTest.testELResolver(context, (ELResolver)beanResolver, this.sb, "intention", "ABC123", buf, false);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.TRACE, buf.toString());
    }

    @Test
    public void beanELResolverDefaultMethodReadOnlyTest() throws Exception {
        boolean pass = false;
        StringBuffer buf = new StringBuffer();
        try {
            BeanELResolver beanResolver = new BeanELResolver();
            BareBonesELContext barebonesContext = new BareBonesELContext();
            ELContext context = barebonesContext.getELContext();
            pass = ResolverTest.testELResolver(context, (ELResolver)beanResolver, this.sb, "defaultRO", "RO", buf, true);
        }
        catch (Exception ex) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Test of a valid expression using a Bean with a read-only property implemented via default methods threw an Exception!" + ELTestUtil.NL + "Received: " + ex.toString() + ELTestUtil.NL);
            ex.printStackTrace();
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.TRACE, buf.toString());
    }

    @Test
    public void beanELResolverDefaultMethodReadWriteTest() throws Exception {
        boolean pass = false;
        StringBuffer buf = new StringBuffer();
        try {
            BeanELResolver beanResolver = new BeanELResolver();
            BareBonesELContext barebonesContext = new BareBonesELContext();
            ELContext context = barebonesContext.getELContext();
            pass = ResolverTest.testELResolver(context, (ELResolver)beanResolver, this.sb, "defaultRW", "RW", buf, false);
        }
        catch (Exception ex) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Test of a valid expression using a Bean with a read-write property implemented via default methods threw an Exception!" + ELTestUtil.NL + "Received: " + ex.toString() + ELTestUtil.NL);
            ex.printStackTrace();
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.TRACE, buf.toString());
    }

    @Test
    public void beanELResolverInvokeTest() throws Exception {
        boolean pass = false;
        StringBuffer buf = new StringBuffer();
        try {
            BeanELResolver beanResolver = new BeanELResolver();
            BareBonesELContext barebonesContext = new BareBonesELContext();
            ELContext context = barebonesContext.getELContext();
            Class[] types = new Class[]{String.class, String.class};
            Object[] values = new String[]{"Doug", "Donahue"};
            pass = ResolverTest.testELResolverInvoke(context, (ELResolver)beanResolver, this.sb, "isName", types, values, Boolean.FALSE, buf);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.TRACE, buf.toString());
    }

    @Test
    public void beanELResolverInvokeVoidTest() throws Exception {
        boolean pass;
        StringBuffer buf = new StringBuffer();
        try {
            BeanELResolver beanResolver = new BeanELResolver();
            BareBonesELContext barebonesContext = new BareBonesELContext();
            ELContext context = barebonesContext.getELContext();
            Class[] types = new Class[]{String.class, String.class};
            Object[] values = new String[]{"Peter", "Pan"};
            Object result = beanResolver.invoke(context, (Object)this.sb, (Object)"setFullName", types, values);
            if (null == result) {
                pass = ResolverTest.testELResolverInvoke(context, (ELResolver)beanResolver, this.sb, "isName", types, values, Boolean.FALSE, buf);
            } else {
                pass = false;
                buf.append("Unexpected Value returned!" + ELTestUtil.NL + "Expected: null" + ELTestUtil.NL + "Recieved: " + result.getClass().getName());
            }
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.TRACE, buf.toString());
    }

    @Test
    public void beanELResolverInvokeMNFETest() throws Exception {
        boolean pass = false;
        StringBuffer buf = new StringBuffer();
        try {
            BeanELResolver beanResolver = new BeanELResolver();
            BareBonesELContext barebonesContext = new BareBonesELContext();
            ELContext context = barebonesContext.getELContext();
            Class[] types = new Class[]{String.class, String.class};
            Object[] values = new String[]{"Doug", "Donahue"};
            pass = ResolverTest.testELResolverInvoke(context, (ELResolver)beanResolver, this.sb, "bogus_Method", types, values, Boolean.TRUE, buf);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.TRACE, buf.toString());
    }

    @Test
    public void beanELResolverNPETest() throws Exception {
        boolean pass = false;
        StringBuffer buf = new StringBuffer();
        this.sb.setIntention("initial_setting");
        BeanELResolver resolver = new BeanELResolver();
        try {
            pass = ResolverTest.testELResolverNPE((ELResolver)resolver, this.sb, "intention", "billy", buf);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.TRACE, buf.toString());
    }

    @Test
    public void beanELResolverPNFETest() throws Exception {
        boolean pass = true;
        StringBuffer buf = new StringBuffer();
        this.sb.setIntention("initial_setting");
        BeanELResolver resolver = new BeanELResolver();
        BareBonesELContext barebonesComtext = new BareBonesELContext();
        ELContext context = barebonesComtext.getELContext();
        try {
            pass = ResolverTest.testELResolverPNFE(context, (ELResolver)resolver, this.sb, "Bogus_Field", buf);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.TRACE, buf.toString());
    }

    @Test
    public void beanELResolverPNWETest() throws Exception {
        boolean pass = false;
        StringBuffer buf = new StringBuffer();
        BeanELResolver resolver = new BeanELResolver(true);
        BareBonesELContext barebonesComtext = new BareBonesELContext();
        ELContext context = barebonesComtext.getELContext();
        try {
            pass = ResolverTest.testELResolverPNWE(context, (ELResolver)resolver, this.sb, "intention", "billy", buf);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.TRACE, buf.toString());
    }

    @Test
    public void beanELResolverMethodVisibilityTest() throws Exception {
        boolean pass = false;
        StringBuffer buf = new StringBuffer();
        TimeZone tz = TimeZone.getDefault();
        try {
            BeanELResolver beanResolver = new BeanELResolver();
            BareBonesELContext barebonesContext = new BareBonesELContext();
            ELContext context = barebonesContext.getELContext();
            pass = ResolverTest.testELResolver(context, (ELResolver)beanResolver, tz, "rawOffset", 0, buf, false);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.TRACE, buf.toString());
    }
}

