/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.spec.concatoperator;

import com.sun.ts.tests.el.common.util.TestNum;
import com.sun.ts.tests.el.common.util.Validator;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class ELClientIT {
    private static final System.Logger logger = System.getLogger(ELClientIT.class.getName());

    @AfterEach
    public void cleanup() throws Exception {
        logger.log(System.Logger.Level.INFO, "Cleanup method called");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void elBigDecimalConcatenationTest() throws Exception {
        BigDecimal testValue = BigDecimal.valueOf(10.531);
        Validator.testBigDecimal(testValue, null, "+=");
    }

    @Test
    public void elBigIntegerConcatenationTest() throws Exception {
        BigInteger testValue = BigInteger.valueOf(10531L);
        Validator.testBigInteger(testValue, null, "+=");
    }

    @Test
    public void elFloatConcatenationTest() throws Exception {
        for (Float testValue : TestNum.getFloatList()) {
            Validator.testFloat(testValue, null, "+=");
        }
    }

    @Test
    public void elDoubleConcatenationTest() throws Exception {
        Double testValue = 2.5;
        Validator.testDouble(testValue, null, "+=");
    }

    @Test
    public void elLongConcatenationTest() throws Exception {
        Long testValue = 25000L;
        Validator.testLong(testValue, null, "+=");
    }

    @Test
    public void elIntegerConcatenationTest() throws Exception {
        Integer testValue = 25;
        Validator.testInteger(testValue, null, "+=");
    }

    @Test
    public void elShortConcatenationTest() throws Exception {
        Short testValue = Short.valueOf("2");
        Validator.testShort(testValue, null, "+=");
    }

    @Test
    public void elByteConcatenationTest() throws Exception {
        Byte testValue = Byte.valueOf("2");
        Validator.testByte(testValue, null, "+=");
    }

    @Test
    public void elBooleanConcatenationTest() throws Exception {
        Validator.testBoolean(false, "true", null, "+=");
        Validator.testBoolean(false, Boolean.TRUE, null, "+=");
    }
}

