/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.agent;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.management.agent.Agent;
import com.sun.messaging.jmq.jmsserver.management.agent.ConnectorServerInfo;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.JMXConnectorServer;

public class ConnectorServerManager
implements NotificationListener {
    private Logger logger;
    private BrokerConfig config;
    private Hashtable connectors;
    private Agent agent;
    private BrokerResources rb = Globals.getBrokerResources();

    public ConnectorServerManager(Agent agent) {
        this.logger = Globals.getLogger();
        this.config = Globals.getConfig();
        this.connectors = new Hashtable();
        this.agent = agent;
    }

    public JMXConnectorServer getConnectorServer(String name) {
        ConnectorServerInfo csInfo = (ConnectorServerInfo)this.connectors.get(name);
        if (csInfo != null) {
            return csInfo.getConnectorServer();
        }
        return null;
    }

    public void add(String name, boolean configuredActive) throws BrokerException {
        ConnectorServerInfo csInfo = new ConnectorServerInfo(this.agent, name, configuredActive, this);
        this.connectors.put(name, csInfo);
    }

    public void remove(String name) throws IOException, BrokerException {
        ConnectorServerInfo csInfo = (ConnectorServerInfo)this.connectors.get(name);
        if (csInfo == null) {
            throw new BrokerException(this.rb.getString("B2164", name));
        }
        if (csInfo.isActive()) {
            csInfo.stop();
        }
        try {
            JMXConnectorServer cs = csInfo.getConnectorServer();
            cs.removeNotificationListener(this);
        }
        catch (ListenerNotFoundException le) {
            throw new BrokerException(this.rb.getString("B2165", le.toString()));
        }
        this.connectors.remove(name);
    }

    public void initConfiguredConnectorServers() throws BrokerException {
        List connectorServers = this.getAllJMXConnectorNames();
        Set s = this.connectors.keySet();
        for (String name : s) {
            try {
                this.remove(name);
            }
            catch (Exception e) {
                this.logger.log(16, this.rb.getString("B2166", name), e);
            }
        }
        for (int i = 0; i < connectorServers.size(); ++i) {
            String name = (String)connectorServers.get(i);
            this.add(name, this.connectorIsConfiguredActive(name));
        }
    }

    private boolean connectorIsConfiguredActive(String connectorName) {
        List activeConnectorServers = this.getAllActiveJMXConnectorNames();
        for (int i = 0; i < activeConnectorServers.size(); ++i) {
            String name = (String)activeConnectorServers.get(i);
            if (!name.equals(connectorName)) continue;
            return true;
        }
        return false;
    }

    public List getAllJMXConnectorNames() {
        return this.config.getList("imq.jmx.connector.list");
    }

    public List getAllActiveJMXConnectorNames() {
        return this.config.getList("imq.jmx.connector.activelist");
    }

    public void start(String name) throws IOException, BrokerException {
        ConnectorServerInfo csInfo = (ConnectorServerInfo)this.connectors.get(name);
        if (csInfo == null) {
            throw new BrokerException(this.rb.getString("B2167", name));
        }
        try {
            csInfo.start();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("url", csInfo.getJMXServiceURL().toString());
            Globals.getPortMapper().addService(name, csInfo.getProtocol(), "JMX", csInfo.getPort(), map);
            this.logger.log(8, this.rb.getKString("B1234", name, csInfo.getJMXServiceURL()));
        }
        catch (IOException e) {
            this.logger.logStack(16, this.rb.getKString("B2163", name), e);
            throw e;
        }
    }

    public void start() throws IOException, BrokerException {
        Set s = this.connectors.keySet();
        for (String name : s) {
            if (!this.connectorIsConfiguredActive(name)) continue;
            this.start(name);
        }
    }

    public void stop(String name) throws IOException, BrokerException {
        ConnectorServerInfo csInfo = (ConnectorServerInfo)this.connectors.get(name);
        if (csInfo == null) {
            throw new BrokerException(this.rb.getString("B2168", name));
        }
        if (!csInfo.isActive()) {
            throw new BrokerException(this.rb.getString("B2169", name));
        }
        try {
            csInfo.stop();
            Globals.getPortMapper().removeService(name);
            this.logger.log(8, this.rb.getString("B1235", name));
        }
        catch (IOException e) {
            this.logger.log(16, this.rb.getString("B2170", name), e);
            throw e;
        }
    }

    public void stop() throws IOException, BrokerException {
        Set s = this.connectors.keySet();
        for (String name : s) {
            ConnectorServerInfo csInfo = (ConnectorServerInfo)this.connectors.get(name);
            if (!csInfo.isActive()) continue;
            this.stop(name);
        }
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        if (notification instanceof JMXConnectionNotification) {
            JMXConnectionNotification jmxc = (JMXConnectionNotification)notification;
            ConnectorServerInfo csInfo = (ConnectorServerInfo)handback;
            JMXConnectorServer cs = csInfo.getConnectorServer();
            String type = jmxc.getType();
            String conId = jmxc.getConnectionId();
            String name = csInfo.getName();
            String[] connectionIds = cs.getConnectionIds();
            Object[] args = new Object[]{name, conId, connectionIds.length};
            if (type.equals("jmx.remote.connection.opened")) {
                this.logger.log(8, this.rb.getString("B1236", args));
            } else if (type.equals("jmx.remote.connection.closed")) {
                this.logger.log(8, this.rb.getString("B1237", args));
            } else {
                this.logger.log(8, this.rb.getString("B1238", args));
            }
        }
    }

    public Vector getConnectorInfo() {
        Vector v = new Vector();
        Collection c = this.connectors.values();
        for (ConnectorServerInfo info : c) {
            Hashtable<String, Object> h = new Hashtable<String, Object>();
            h.put("name", info.getName());
            h.put("active", info.isActive());
            String url = info.isActive() ? info.getJMXServiceURL().toString() : "";
            h.put("url", url);
            v.add(h);
        }
        return v;
    }
}

