/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.generator.client;

import com.sun.appserv.server.util.Version;
import com.sun.enterprise.config.serverbeans.Domain;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.glassfish.admin.rest.RestLogging;
import org.glassfish.admin.rest.client.RestClientBase;
import org.glassfish.admin.rest.client.RestLeaf;
import org.glassfish.admin.rest.client.RestLeafCollection;
import org.glassfish.admin.rest.generator.CommandResourceMetaData;
import org.glassfish.admin.rest.generator.ResourcesGeneratorBase;
import org.glassfish.admin.rest.generator.client.ClientClassWriter;
import org.glassfish.admin.rest.utils.ResourceUtil;
import org.glassfish.admin.rest.utils.Util;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.DomDocument;

public abstract class ClientGenerator {
    private static final String OUTPUT_PATH = "target/generated";
    private static final String CLIENT_PKG = "org.glassfish.admin.rest.client";
    private static final String BASE_CLASS = "org.glassfish.admin.rest.client.RestClientBase";
    protected Set<String> alreadyGenerated = new HashSet<String>();
    protected ServiceLocator habitat;
    protected List<String> messages = new ArrayList<String>();
    protected String versionString;
    protected static final String ARTIFACT_NAME = "rest-client-wrapper";
    private DomDocument document;

    public ClientGenerator(ServiceLocator habitat) {
        this.habitat = habitat;
        this.versionString = Version.getVersionNumber();
    }

    public abstract ClientClassWriter getClassWriter(ConfigModel var1, String var2, Class var3);

    public abstract Map<String, URI> getArtifact();

    public List<String> getMessages() {
        return this.messages;
    }

    public void generateClasses() {
        Domain entity = this.getBaseServiceLocator().getService(Domain.class, new Annotation[0]);
        Dom dom = Dom.unwrap((ConfigBeanProxy)entity);
        this.document = dom.document;
        ConfigModel rootModel = dom.document.getRoot().model;
        this.alreadyGenerated.clear();
        this.generateSingle(rootModel);
    }

    public ServiceLocator getBaseServiceLocator() {
        return this.habitat;
    }

    public void generateSingle(ConfigModel model) {
        String className = Util.getBeanName(model.getTagName());
        if (this.alreadyGenerated(className)) {
            return;
        }
        ClientClassWriter writer = this.getClassWriter(model, className, RestClientBase.class);
        writer.generateGetSegment(model.getTagName());
        this.generateCommandMethods(writer, className);
        Set<String> processed = this.processElements(writer, model);
        this.processAttributes(writer, model, processed);
        writer.done();
    }

    public void generateList(ClientClassWriter writer, ConfigModel model) {
        String serverConfigName = ResourceUtil.getUnqualifiedTypeName(model.targetTypeName);
        String beanName = Util.getBeanName(serverConfigName);
        this.generateCommandMethods(writer, "List" + beanName);
        this.generateSingle(model);
    }

    protected void generateGetPostCommandMethod(ClientClassWriter writer, String resourceName) {
        CommandModel cm;
        String commandName = ResourcesGeneratorBase.configBeanToPOSTCommand.get("List" + resourceName);
        if (commandName != null && (cm = this.getCommandModel(commandName)) != null) {
            writer.generateCommandMethod(Util.methodNameFromDtdName(commandName, null), "POST", ResourceUtil.convertToXMLName(resourceName), cm);
        }
    }

    protected void generateCommandMethods(ClientClassWriter writer, String className) {
        List<CommandResourceMetaData> commandMetaData = CommandResourceMetaData.getMetaData(className);
        if (commandMetaData.size() > 0) {
            for (CommandResourceMetaData metaData : commandMetaData) {
                String methodName;
                CommandModel cm = this.getCommandModel(metaData.command);
                if (cm == null || (methodName = Util.methodNameFromDtdName(metaData.command, null)).startsWith("_")) continue;
                writer.generateCommandMethod(methodName, metaData.httpMethod, metaData.resourcePath, cm);
            }
        }
    }

    protected void processAttributes(ClientClassWriter writer, ConfigModel model, Set<String> processed) {
        Class clazz = model.getProxyType();
        for (Method method : clazz.getMethods()) {
            String fieldName;
            String methodName = method.getName();
            Attribute a = method.getAnnotation(Attribute.class);
            Param p = method.getAnnotation(Param.class);
            if (a == null && p == null) continue;
            String type = "String";
            if (a != null) {
                type = a.dataType().getName();
            }
            if (methodName.startsWith("get") || methodName.startsWith("set")) {
                methodName = methodName.substring(3);
            }
            if (processed.contains(fieldName = Util.lowerCaseFirstLetter(methodName))) continue;
            processed.add(fieldName);
            writer.generateGettersAndSetters(type, methodName, fieldName);
        }
    }

    protected String generateParameterName(CommandModel.ParamModel model) {
        Param param = model.getParam();
        String paramName = !param.alias().isEmpty() ? param.alias() : model.getName();
        return paramName;
    }

    protected CommandModel getCommandModel(String commandName) {
        CommandRunner cr = this.getBaseServiceLocator().getService(CommandRunner.class, new Annotation[0]);
        return cr.getModel(commandName, RestLogging.restLogger);
    }

    protected Set<String> processElements(ClientClassWriter writer, ConfigModel model) {
        HashSet<String> processed = new HashSet<String>();
        for (String elementName : model.getElementNames()) {
            if (processed.contains(elementName)) continue;
            processed.add(elementName);
            ConfigModel.Property childElement = model.getElement(elementName);
            if (elementName.equals("*")) {
                ConfigModel.Node node = (ConfigModel.Node)childElement;
                ConfigModel childModel = node.getModel();
                List<ConfigModel> subChildConfigModels = ResourceUtil.getRealChildConfigModels(childModel, this.document);
                for (ConfigModel subChildConfigModel : subChildConfigModels) {
                    if (ResourceUtil.isOnlyATag(childModel)) {
                        String childResourceClassName = ResourceUtil.getUnqualifiedTypeName(subChildConfigModel.targetTypeName);
                        writer.createGetChildResource(subChildConfigModel, childResourceClassName, childResourceClassName);
                        this.generateSingle(subChildConfigModel);
                        continue;
                    }
                    this.processNonLeafChildConfigModel(writer, subChildConfigModel, childElement);
                }
                continue;
            }
            if (childElement.isLeaf()) {
                if (processed.contains(childElement.xmlName)) continue;
                processed.add(childElement.xmlName);
                if (childElement.isCollection()) {
                    System.out.println("generateCollectionLeafResource for " + elementName + " off of " + model.getTagName());
                    this.generateCollectionLeafResource(writer, childElement.xmlName);
                    continue;
                }
                System.out.println("generateLeafResource for " + elementName + " off of " + model.getTagName());
                this.generateLeafResource(writer, childElement.xmlName);
                continue;
            }
            this.processNonLeafChildElement(writer, elementName, childElement);
        }
        return processed;
    }

    protected void generateCollectionLeafResource(ClientClassWriter writer, String xmlName) {
        String className = Util.getBeanName(xmlName);
        writer.generateCollectionLeafResourceGetter(className);
        ClientClassWriter childClass = this.getClassWriter(null, className, RestLeafCollection.class);
        childClass.generateGetSegment(xmlName);
        childClass.done();
    }

    protected void generateLeafResource(ClientClassWriter writer, String xmlName) {
        String className = Util.getBeanName(xmlName);
        writer.generateRestLeafGetter(className);
        ClientClassWriter childClass = this.getClassWriter(null, className, RestLeaf.class);
        childClass.generateGetSegment(xmlName);
        childClass.done();
    }

    protected void processNonLeafChildConfigModel(ClientClassWriter writer, ConfigModel childConfigModel, ConfigModel.Property childElement) {
        String childResourceClassName = ResourceUtil.getUnqualifiedTypeName(childConfigModel.targetTypeName);
        writer.createGetChildResource(childConfigModel, childResourceClassName, childResourceClassName);
        if (!childElement.isCollection()) {
            throw new RuntimeException("The code flow should never reach here. Non-leaf ChildElements are assumed to be collection typed.");
        }
        this.generateList(writer, childConfigModel);
    }

    protected boolean alreadyGenerated(String className) {
        boolean retVal = true;
        if (!this.alreadyGenerated.contains(className)) {
            this.alreadyGenerated.add(className);
            retVal = false;
        }
        return retVal;
    }

    private void processNonLeafChildElement(ClientClassWriter writer, String elementName, ConfigModel.Property childElement) {
        ConfigModel.Node node = (ConfigModel.Node)childElement;
        ConfigModel childModel = node.getModel();
        String beanName = ResourceUtil.getUnqualifiedTypeName(childModel.targetTypeName);
        writer.createGetChildResource(childModel, Util.upperCaseFirstLetter(Util.eleminateHypen(elementName)), beanName);
        if (childElement.isCollection()) {
            this.generateList(writer, childModel);
        } else {
            this.generateSingle(childModel);
        }
    }
}

