/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.component;

import com.sun.webui.jsf.component.ImageComponent;
import jakarta.el.ValueExpression;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import java.io.IOException;
import java.util.Comparator;

public final class Alarm
extends ImageComponent
implements Comparator {
    public static final String SEVERITY_DOWN = "down";
    public static final String SEVERITY_CRITICAL = "critical";
    public static final String SEVERITY_MAJOR = "major";
    public static final String SEVERITY_MINOR = "minor";
    public static final String SEVERITY_OK = "ok";
    public static final String DEFAULT_SEVERITY = "ok";
    private static final int SEVERITY_LEVEL_DOWN = 1;
    private static final int SEVERITY_LEVEL_CRITICAL = 2;
    private static final int SEVERITY_LEVEL_MAJOR = 3;
    private static final int SEVERITY_LEVEL_MINOR = 4;
    private static final int SEVERITY_LEVEL_OK = 5;
    private String alt = null;
    private String onClick = null;
    private String onDblClick = null;
    private String onKeyDown = null;
    private String onKeyPress = null;
    private String onKeyUp = null;
    private String onMouseDown = null;
    private String onMouseMove = null;
    private String onMouseOut = null;
    private String onMouseOver = null;
    private String onMouseUp = null;
    private String severity = null;
    private String style = null;
    private String styleClass = null;
    private String text = null;
    private String textPosition = null;
    private String toolTip = null;
    private boolean visible = false;
    private boolean visibleSet = false;

    public Alarm() {
    }

    public Alarm(String newSeverity) {
        this.setSeverity(newSeverity);
        this.setRendererType("com.sun.webui.jsf.Alarm");
    }

    @Override
    public String getFamily() {
        return "com.sun.webui.jsf.Alarm";
    }

    public int compare(Object o1, Object o2) {
        int s2;
        int s1 = Alarm.getSeverityLevel((Alarm)o1);
        if (s1 > (s2 = Alarm.getSeverityLevel((Alarm)o2))) {
            return -1;
        }
        if (s1 == s2) {
            return 0;
        }
        return 1;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Alarm) {
            return Alarm.getSeverityLevel(this) == Alarm.getSeverityLevel((Alarm)obj);
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash;
        if (this.severity != null) {
            hash += this.severity.hashCode();
        }
        return hash;
    }

    private static int getSeverityLevel(Alarm alarm) {
        int level = 5;
        String alarmSeverity = alarm.getSeverity();
        if (alarmSeverity == null) {
            return level;
        }
        if (alarmSeverity.equals(SEVERITY_DOWN)) {
            level = 1;
        } else if (alarmSeverity.equals(SEVERITY_CRITICAL)) {
            level = 2;
        } else if (alarmSeverity.equals(SEVERITY_MAJOR)) {
            level = 3;
        } else if (alarmSeverity.equals(SEVERITY_MINOR)) {
            level = 4;
        }
        return level;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        String rendererType = this.getRendererType();
        if (rendererType != null) {
            this.getRenderer(context).encodeBegin(context, (UIComponent)this);
        }
    }

    @Override
    public void setId(String id) {
        super.setId(id);
    }

    @Override
    public void setRendered(boolean rendered) {
        super.setRendered(rendered);
    }

    @Override
    public Object getValue() {
        return super.getValue();
    }

    @Override
    public String getAlt() {
        if (this.alt != null) {
            return this.alt;
        }
        ValueExpression vb = this.getValueExpression("alt");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    @Override
    public void setAlt(String newAlt) {
        this.alt = newAlt;
    }

    @Override
    public String getOnClick() {
        if (this.onClick != null) {
            return this.onClick;
        }
        ValueExpression vb = this.getValueExpression("onClick");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    @Override
    public void setOnClick(String newOnClick) {
        this.onClick = newOnClick;
    }

    @Override
    public String getOnDblClick() {
        if (this.onDblClick != null) {
            return this.onDblClick;
        }
        ValueExpression vb = this.getValueExpression("onDblClick");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    @Override
    public void setOnDblClick(String newOnDblClick) {
        this.onDblClick = newOnDblClick;
    }

    public String getOnKeyDown() {
        if (this.onKeyDown != null) {
            return this.onKeyDown;
        }
        ValueExpression vb = this.getValueExpression("onKeyDown");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnKeyDown(String newOnKeyDown) {
        this.onKeyDown = newOnKeyDown;
    }

    public String getOnKeyPress() {
        if (this.onKeyPress != null) {
            return this.onKeyPress;
        }
        ValueExpression vb = this.getValueExpression("onKeyPress");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnKeyPress(String newOnKeyPress) {
        this.onKeyPress = newOnKeyPress;
    }

    public String getOnKeyUp() {
        if (this.onKeyUp != null) {
            return this.onKeyUp;
        }
        ValueExpression vb = this.getValueExpression("onKeyUp");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnKeyUp(String newOnKeyUp) {
        this.onKeyUp = newOnKeyUp;
    }

    @Override
    public String getOnMouseDown() {
        if (this.onMouseDown != null) {
            return this.onMouseDown;
        }
        ValueExpression vb = this.getValueExpression("onMouseDown");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    @Override
    public void setOnMouseDown(String newOnMouseDown) {
        this.onMouseDown = newOnMouseDown;
    }

    @Override
    public String getOnMouseMove() {
        if (this.onMouseMove != null) {
            return this.onMouseMove;
        }
        ValueExpression vb = this.getValueExpression("onMouseMove");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    @Override
    public void setOnMouseMove(String newOnMouseMove) {
        this.onMouseMove = newOnMouseMove;
    }

    @Override
    public String getOnMouseOut() {
        if (this.onMouseOut != null) {
            return this.onMouseOut;
        }
        ValueExpression vb = this.getValueExpression("onMouseOut");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    @Override
    public void setOnMouseOut(String newOnMouseOut) {
        this.onMouseOut = newOnMouseOut;
    }

    @Override
    public String getOnMouseOver() {
        if (this.onMouseOver != null) {
            return this.onMouseOver;
        }
        ValueExpression vb = this.getValueExpression("onMouseOver");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    @Override
    public void setOnMouseOver(String newOnMouseOver) {
        this.onMouseOver = newOnMouseOver;
    }

    @Override
    public String getOnMouseUp() {
        if (this.onMouseUp != null) {
            return this.onMouseUp;
        }
        ValueExpression vb = this.getValueExpression("onMouseUp");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    @Override
    public void setOnMouseUp(String newOnMouseUp) {
        this.onMouseUp = newOnMouseUp;
    }

    public String getSeverity() {
        if (this.severity != null) {
            return this.severity;
        }
        ValueExpression vb = this.getValueExpression("severity");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setSeverity(String newSeverity) {
        this.severity = newSeverity;
    }

    @Override
    public String getStyle() {
        if (this.style != null) {
            return this.style;
        }
        ValueExpression vb = this.getValueExpression("style");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    @Override
    public void setStyle(String newStyle) {
        this.style = newStyle;
    }

    @Override
    public String getStyleClass() {
        if (this.styleClass != null) {
            return this.styleClass;
        }
        ValueExpression vb = this.getValueExpression("styleClass");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    @Override
    public void setStyleClass(String newStyleClass) {
        this.styleClass = newStyleClass;
    }

    public String getText() {
        if (this.text != null) {
            return this.text;
        }
        ValueExpression vb = this.getValueExpression("text");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setText(String newText) {
        this.text = newText;
    }

    public String getTextPosition() {
        if (this.textPosition != null) {
            return this.textPosition;
        }
        ValueExpression vb = this.getValueExpression("textPosition");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return "right";
    }

    public void setTextPosition(String newTextPosition) {
        this.textPosition = newTextPosition;
    }

    @Override
    public String getToolTip() {
        if (this.toolTip != null) {
            return this.toolTip;
        }
        ValueExpression vb = this.getValueExpression("toolTip");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    @Override
    public void setToolTip(String newToolTip) {
        this.toolTip = newToolTip;
    }

    @Override
    public boolean isVisible() {
        if (this.visibleSet) {
            return this.visible;
        }
        ValueExpression vb = this.getValueExpression("visible");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return true;
    }

    @Override
    public void setVisible(boolean newVisible) {
        this.visible = newVisible;
        this.visibleSet = true;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.alt = (String)values[1];
        this.onClick = (String)values[2];
        this.onDblClick = (String)values[3];
        this.onKeyDown = (String)values[4];
        this.onKeyPress = (String)values[5];
        this.onKeyUp = (String)values[6];
        this.onMouseDown = (String)values[7];
        this.onMouseMove = (String)values[8];
        this.onMouseOut = (String)values[9];
        this.onMouseOver = (String)values[10];
        this.onMouseUp = (String)values[11];
        this.severity = (String)values[12];
        this.style = (String)values[13];
        this.styleClass = (String)values[14];
        this.text = (String)values[15];
        this.textPosition = (String)values[16];
        this.toolTip = (String)values[17];
        this.visible = (Boolean)values[18];
        this.visibleSet = (Boolean)values[19];
    }

    @Override
    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.alt, this.onClick, this.onDblClick, this.onKeyDown, this.onKeyPress, this.onKeyUp, this.onMouseDown, this.onMouseMove, this.onMouseOut, this.onMouseOver, this.onMouseUp, this.severity, this.style, this.styleClass, this.text, this.textPosition, this.toolTip, this.visible ? Boolean.TRUE : Boolean.FALSE, this.visibleSet ? Boolean.TRUE : Boolean.FALSE};
        return values;
    }
}

