/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.lite.extension.translator;

import jakarta.annotation.Priority;
import jakarta.enterprise.inject.build.compatible.spi.BuildCompatibleExtension;
import jakarta.enterprise.inject.build.compatible.spi.SkipIfPortableExtensionPresent;
import jakarta.enterprise.inject.spi.DefinitionException;
import jakarta.enterprise.inject.spi.DeploymentException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jboss.weld.lite.extension.translator.logging.LiteExtensionTranslatorLogger;

class ExtensionInvoker {
    private static final int DEFAULT_PRIORITY = 2500;
    private final Map<String, Class<?>> extensionClasses = new HashMap();
    private final Map<Class<?>, Object> extensionClassInstances = new HashMap();

    ExtensionInvoker(Collection<Class<? extends BuildCompatibleExtension>> extensions) {
        for (Class<? extends BuildCompatibleExtension> extensionClass : extensions) {
            SkipIfPortableExtensionPresent skip = extensionClass.getAnnotation(SkipIfPortableExtensionPresent.class);
            if (skip != null) continue;
            try {
                BuildCompatibleExtension extensionInstance = extensionClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                this.extensionClasses.put(extensionClass.getName(), extensionClass);
                this.extensionClassInstances.put(extensionClass, extensionInstance);
            }
            catch (InvocationTargetException e) {
                throw LiteExtensionTranslatorLogger.LOG.unableToInstantiateObject(extensionClass, e.getCause().toString(), e);
            }
            catch (ReflectiveOperationException e) {
                throw LiteExtensionTranslatorLogger.LOG.unableToInstantiateObject(extensionClass, e.toString(), e);
            }
        }
    }

    List<Method> findExtensionMethods(Class<? extends Annotation> annotation) {
        return this.extensionClasses.values().stream().flatMap(it -> Arrays.stream(it.getDeclaredMethods())).filter(it -> it.getAnnotation(annotation) != null).sorted((m1, m2) -> {
            int p2;
            if (m1.equals(m2)) {
                return 0;
            }
            int p1 = this.getExtensionMethodPriority((Method)m1);
            return p1 < (p2 = this.getExtensionMethodPriority((Method)m2)) ? -1 : 1;
        }).collect(Collectors.toList());
    }

    private int getExtensionMethodPriority(Method method) {
        Priority priority = method.getAnnotation(Priority.class);
        if (priority != null) {
            return priority.value();
        }
        return 2500;
    }

    void callExtensionMethod(Method method, List<Object> arguments) throws ReflectiveOperationException {
        Class<?> extensionClass = this.extensionClasses.get(method.getDeclaringClass().getName());
        Object extensionClassInstance = this.extensionClassInstances.get(extensionClass);
        try {
            method.invoke(extensionClassInstance, arguments.toArray());
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof DefinitionException) {
                throw (DefinitionException)e.getCause();
            }
            if (e.getCause() instanceof DeploymentException) {
                throw (DeploymentException)e.getCause();
            }
            throw e;
        }
    }

    void clear() {
        this.extensionClasses.clear();
        this.extensionClassInstances.clear();
    }
}

