/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings.converters;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.internal.core.helper.CoreClassConstants;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.sessions.Session;

public class ClassInstanceConverter
implements Converter {
    protected DatabaseMapping mapping;

    @Override
    public Object convertDataValueToObjectValue(Object fieldValue, Session session) {
        Object attributeValue;
        block6: {
            attributeValue = null;
            if (fieldValue != null) {
                Class attributeClass = session.getDatasourcePlatform().convertObject(fieldValue, CoreClassConstants.CLASS);
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            attributeValue = AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(attributeClass));
                            break block6;
                        }
                        catch (PrivilegedActionException exception) {
                            throw ConversionException.couldNotBeConverted(fieldValue, attributeClass, exception.getException());
                        }
                    }
                    attributeValue = PrivilegedAccessHelper.newInstanceFromClass(attributeClass);
                }
                catch (Exception exception) {
                    throw ConversionException.couldNotBeConverted(fieldValue, attributeClass, exception);
                }
            }
        }
        return attributeValue;
    }

    @Override
    public Object convertObjectValueToDataValue(Object attributeValue, Session session) {
        if (attributeValue == null) {
            return null;
        }
        return attributeValue.getClass().getName();
    }

    @Override
    public void initialize(DatabaseMapping mapping, Session session) {
        AbstractDirectMapping directMapping;
        this.mapping = mapping;
        if (this.getMapping().isDirectToFieldMapping() && (directMapping = (AbstractDirectMapping)this.getMapping()).getFieldClassification() == null) {
            directMapping.setFieldClassification(CoreClassConstants.STRING);
        }
    }

    protected DatabaseMapping getMapping() {
        return this.mapping;
    }

    @Override
    public boolean isMutable() {
        return false;
    }
}

