/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.epicyro.config.factory.file;

import jakarta.security.auth.message.config.AuthConfigFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.glassfish.epicyro.config.factory.RegistrationContextImpl;
import org.glassfish.epicyro.config.factory.file.AuthConfigProviderEntry;

public final class RegStoreFileParser {
    private static final System.Logger LOG = System.getLogger(RegStoreFileParser.class.getName());
    private static final String SEP = ":";
    private static final String CON_ENTRY = "con-entry";
    private static final String REG_ENTRY = "reg-entry";
    private static final String REG_CTX = "reg-ctx";
    private static final String LAYER = "layer";
    private static final String APP_CTX = "app-ctx";
    private static final String DESCRIPTION = "description";
    private static final String[] INDENT = new String[]{"", "  ", "    "};
    private File configurationFile;
    private List<AuthConfigProviderEntry> authConfigProviderEntries;

    public RegStoreFileParser(List<AuthConfigProviderEntry> authConfigProviderEntries) {
        this.authConfigProviderEntries = new ArrayList<AuthConfigProviderEntry>(authConfigProviderEntries);
    }

    public RegStoreFileParser(String pathParent, String pathChild, List<AuthConfigProviderEntry> defaultEntries) {
        this.configurationFile = new File(pathParent, pathChild);
        try {
            this.loadEntries(defaultEntries);
        }
        catch (IOException | IllegalArgumentException e) {
            LOG.log(System.Logger.Level.WARNING, "Could not read auth configuration file. Will use default providers.", (Throwable)e);
        }
    }

    public List<AuthConfigProviderEntry> getPersistedEntries() {
        return this.authConfigProviderEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(String className, AuthConfigFactory.RegistrationContext registrationContext, Map<String, String> properties) {
        File file = this.configurationFile;
        synchronized (file) {
            if (this.checkAndAddToList(className, registrationContext, properties)) {
                try {
                    this.writeEntries();
                }
                catch (IOException ioe) {
                    LOG.log(System.Logger.Level.WARNING, "Could not persist updated provider list. Will use default providers when reloaded.", (Throwable)ioe);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(AuthConfigFactory.RegistrationContext registrationContext) {
        File file = this.configurationFile;
        synchronized (file) {
            if (this.checkAndRemoveFromList(registrationContext)) {
                try {
                    this.writeEntries();
                }
                catch (IOException ioe) {
                    LOG.log(System.Logger.Level.WARNING, "Could not persist updated provider list. Will use default providers when reloaded.", (Throwable)ioe);
                }
            }
        }
    }

    private boolean checkAndAddToList(String className, AuthConfigFactory.RegistrationContext registrationContext, Map<String, String> properties) {
        AuthConfigProviderEntry newEntry;
        AuthConfigProviderEntry entry;
        if (properties != null && properties.isEmpty()) {
            properties = null;
        }
        if ((entry = this.getMatchingRegistrationEntry(newEntry = new AuthConfigProviderEntry(className, properties, registrationContext))) == null) {
            this.authConfigProviderEntries.add(newEntry);
            return true;
        }
        if (entry.getRegistrationContexts().contains(registrationContext)) {
            return false;
        }
        entry.getRegistrationContexts().add(new RegistrationContextImpl(registrationContext));
        return true;
    }

    private boolean checkAndRemoveFromList(AuthConfigFactory.RegistrationContext target) {
        boolean retValue = false;
        try {
            ListIterator<AuthConfigProviderEntry> lit = this.authConfigProviderEntries.listIterator();
            while (lit.hasNext()) {
                AuthConfigProviderEntry info = lit.next();
                if (info.isConstructorEntry()) continue;
                Iterator<AuthConfigFactory.RegistrationContext> iter = info.getRegistrationContexts().iterator();
                while (iter.hasNext()) {
                    AuthConfigFactory.RegistrationContext ctx = iter.next();
                    if (!ctx.equals(target)) continue;
                    iter.remove();
                    if (info.getRegistrationContexts().isEmpty()) {
                        lit.remove();
                    }
                    retValue = true;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return retValue;
    }

    private AuthConfigProviderEntry getMatchingRegistrationEntry(AuthConfigProviderEntry target) {
        for (AuthConfigProviderEntry info : this.authConfigProviderEntries) {
            if (info.isConstructorEntry() || !info.matchConstructors(target)) continue;
            return info;
        }
        return null;
    }

    private void writeEntries() throws IOException {
        if (this.configurationFile.exists() && !this.configurationFile.canWrite()) {
            LOG.log(System.Logger.Level.WARNING, "Cannot write to file {0}. Updated provider list will not be persisted.", this.configurationFile);
        }
        this.clearExistingFile();
        PrintWriter out = new PrintWriter(this.configurationFile);
        int indent = 0;
        for (AuthConfigProviderEntry info : this.authConfigProviderEntries) {
            if (info.isConstructorEntry()) {
                this.writeConEntry(info, out, indent);
                continue;
            }
            this.writeRegEntry(info, out, indent);
        }
        out.close();
    }

    private void writeConEntry(AuthConfigProviderEntry info, PrintWriter out, int i) {
        out.println(INDENT[i++] + "con-entry {");
        out.println(INDENT[i] + info.getClassName());
        Map<String, String> properties = info.getProperties();
        if (properties != null) {
            for (Map.Entry<String, String> val : properties.entrySet()) {
                out.println(INDENT[i] + val.getKey() + SEP + val.getValue());
            }
        }
        out.println(INDENT[--i] + "}");
    }

    private void writeRegEntry(AuthConfigProviderEntry info, PrintWriter out, int i) {
        out.println(INDENT[i++] + "reg-entry {");
        if (info.getClassName() != null) {
            this.writeConEntry(info, out, i);
        }
        for (AuthConfigFactory.RegistrationContext registrationContext : info.getRegistrationContexts()) {
            out.println(INDENT[i++] + "reg-ctx {");
            if (registrationContext.getMessageLayer() != null) {
                out.println(INDENT[i] + "layer:" + registrationContext.getMessageLayer());
            }
            if (registrationContext.getAppContext() != null) {
                out.println(INDENT[i] + "app-ctx:" + registrationContext.getAppContext());
            }
            if (registrationContext.getDescription() != null) {
                out.println(INDENT[i] + "description:" + registrationContext.getDescription());
            }
            out.println(INDENT[--i] + "}");
        }
        out.println(INDENT[--i] + "}");
    }

    private void clearExistingFile() throws IOException {
        boolean newCreation;
        boolean bl = newCreation = !this.configurationFile.exists();
        if (!newCreation && !this.configurationFile.delete()) {
            throw new IOException();
        }
        if (newCreation) {
            LOG.log(System.Logger.Level.INFO, "Creating JMAC Configuration file {0}.", this.configurationFile);
        }
        if (!this.configurationFile.createNewFile()) {
            throw new IOException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadEntries(List<AuthConfigProviderEntry> defaultAuthConfigProviderEntries) throws IOException {
        File file = this.configurationFile;
        synchronized (file) {
            this.authConfigProviderEntries = new ArrayList<AuthConfigProviderEntry>();
            if (this.configurationFile.exists()) {
                try (BufferedReader reader = new BufferedReader(new FileReader(this.configurationFile));){
                    String line = reader.readLine();
                    while (line != null) {
                        String trimLine = line.trim();
                        if (trimLine.startsWith(CON_ENTRY)) {
                            this.authConfigProviderEntries.add(this.readConEntry(reader));
                        } else if (trimLine.startsWith(REG_ENTRY)) {
                            this.authConfigProviderEntries.add(this.readRegEntry(reader));
                        }
                        line = reader.readLine();
                    }
                }
            } else {
                LOG.log(System.Logger.Level.DEBUG, "Configuration file {0} does not exist. Will use default providers.", this.configurationFile);
                if (defaultAuthConfigProviderEntries != null) {
                    for (AuthConfigProviderEntry entry : defaultAuthConfigProviderEntries) {
                        this.authConfigProviderEntries.add(new AuthConfigProviderEntry(entry));
                    }
                }
            }
        }
    }

    private AuthConfigProviderEntry readConEntry(BufferedReader reader) throws IOException {
        String className = reader.readLine();
        if (className != null) {
            className = className.trim();
        }
        return new AuthConfigProviderEntry(className, this.readProperties(reader));
    }

    private Map<String, String> readProperties(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        if (line != null) {
            line = line.trim();
        }
        if ("}".equals(line)) {
            return null;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        while (!"}".equals(line)) {
            properties.put(line.substring(0, line.indexOf(SEP)), line.substring(line.indexOf(SEP) + 1, line.length()));
            line = reader.readLine();
            if (line == null) continue;
            line = line.trim();
        }
        return properties;
    }

    private AuthConfigProviderEntry readRegEntry(BufferedReader reader) throws IOException {
        String className = null;
        Map<String, String> properties = null;
        ArrayList<AuthConfigFactory.RegistrationContext> ctxs = new ArrayList<AuthConfigFactory.RegistrationContext>();
        String line = reader.readLine();
        if (line != null) {
            line = line.trim();
        }
        while (!"}".equals(line)) {
            if (line.startsWith(CON_ENTRY)) {
                AuthConfigProviderEntry conEntry = this.readConEntry(reader);
                className = conEntry.getClassName();
                properties = conEntry.getProperties();
            } else if (line.startsWith(REG_CTX)) {
                ctxs.add(this.readRegContext(reader));
            }
            if ((line = reader.readLine()) == null) continue;
            line = line.trim();
        }
        return new AuthConfigProviderEntry(className, properties, ctxs);
    }

    private AuthConfigFactory.RegistrationContext readRegContext(BufferedReader reader) throws IOException {
        String layer = null;
        String appCtx = null;
        String description = null;
        String line = reader.readLine();
        if (line != null) {
            line = line.trim();
        }
        while (!"}".equals(line)) {
            String value = line.substring(line.indexOf(SEP) + 1, line.length());
            if (line.startsWith(LAYER)) {
                layer = value;
            } else if (line.startsWith(APP_CTX)) {
                appCtx = value;
            } else if (line.startsWith(DESCRIPTION)) {
                description = value;
            }
            if ((line = reader.readLine()) == null) continue;
            line = line.trim();
        }
        return new RegistrationContextImpl(layer, appCtx, description, true);
    }
}

