/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.webservices;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.runtime.common.MessageSecurityBindingDescriptor;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.SecurityServicesUtil;
import com.sun.enterprise.security.appclient.ConfigXMLParser;
import com.sun.enterprise.security.audit.AuditManager;
import com.sun.enterprise.security.common.ClientSecurityContext;
import com.sun.enterprise.security.ee.audit.AppServerAuditManager;
import com.sun.enterprise.security.ee.authentication.jakarta.AuthMessagePolicy;
import com.sun.enterprise.security.ee.authentication.jakarta.ConfigDomainParser;
import com.sun.enterprise.security.ee.authentication.jakarta.WebServicesDelegate;
import com.sun.enterprise.security.ee.authorization.EJBPolicyContextDelegate;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.xml.ws.api.EndpointAddress;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.JavaMethod;
import com.sun.xml.ws.api.model.SEIModel;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.wss.provider.wsit.PipeConstants;
import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.AuthStatus;
import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.MessagePolicy;
import jakarta.security.auth.message.config.AuthConfigProvider;
import jakarta.security.auth.message.config.ClientAuthConfig;
import jakarta.security.auth.message.config.ClientAuthContext;
import jakarta.security.auth.message.config.ServerAuthConfig;
import jakarta.security.auth.message.config.ServerAuthContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.xml.bind.UnmarshalException;
import jakarta.xml.ws.WebServiceException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.deployment.common.ModuleDescriptor;
import org.glassfish.epicyro.config.factory.ConfigParser;
import org.glassfish.epicyro.config.module.configprovider.GFServerConfigProvider;
import org.glassfish.epicyro.services.BaseAuthenticationService;
import org.glassfish.internal.api.Globals;

public class SoapAuthenticationService
extends BaseAuthenticationService {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(PipeConstants.class);
    private AppServerAuditManager auditManager;
    private boolean isEjbEndpoint;
    private SEIModel seiModel;
    private SOAPVersion soapVersion;
    private InvocationManager invocationManager;
    private EJBPolicyContextDelegate ejbDelegate;

    public SoapAuthenticationService(String layer, Map<String, Object> map, CallbackHandler callbackHandler) {
        WSEndpoint endPoint;
        this.init(layer, SoapAuthenticationService.getAppCtxt(map), map, callbackHandler, null);
        this.isEjbEndpoint = this.processSunDeploymentDescriptor();
        this.seiModel = (SEIModel)map.get("SEI_MODEL");
        WSBinding binding = (WSBinding)map.get("BINDING");
        if (binding == null && (endPoint = (WSEndpoint)map.get("ENDPOINT")) != null) {
            binding = endPoint.getBinding();
        }
        this.soapVersion = binding != null ? binding.getSOAPVersion() : SOAPVersion.SOAP_11;
        AuditManager auditManager = SecurityServicesUtil.getInstance() != null ? SecurityServicesUtil.getInstance().getAuditManager() : null;
        this.auditManager = auditManager != null && auditManager instanceof AppServerAuditManager ? (AppServerAuditManager)auditManager : new AppServerAuditManager();
        this.invocationManager = SecurityServicesUtil.getInstance() != null ? (InvocationManager)SecurityServicesUtil.getInstance().getHabitat().getService(InvocationManager.class, new Annotation[0]) : null;
        this.ejbDelegate = new EJBPolicyContextDelegate();
    }

    public ClientAuthContext getClientAuthContext(MessageInfo messageInfo, Subject subject) throws AuthException {
        ClientAuthConfig clientAuthConfig = (ClientAuthConfig)this.getAuthConfig(false);
        if (clientAuthConfig == null) {
            return null;
        }
        SoapAuthenticationService.addModel(messageInfo, this.map);
        return clientAuthConfig.getAuthContext(clientAuthConfig.getAuthContextID(messageInfo), subject, this.map);
    }

    public ServerAuthContext getServerAuthContext(MessageInfo messageInfo, Subject subject) throws AuthException {
        ServerAuthConfig serverAuthConfig = (ServerAuthConfig)this.getAuthConfig(true);
        if (serverAuthConfig == null) {
            return null;
        }
        SoapAuthenticationService.addModel(messageInfo, this.map);
        SoapAuthenticationService.addPolicy(messageInfo, this.map);
        return serverAuthConfig.getAuthContext(serverAuthConfig.getAuthContextID(messageInfo), subject, this.map);
    }

    public static Subject getClientSubject() {
        Subject subject = null;
        if (SoapAuthenticationService.isACC()) {
            ClientSecurityContext clientSecurityContext = ClientSecurityContext.getCurrent();
            if (clientSecurityContext != null) {
                subject = clientSecurityContext.getSubject();
            }
        } else {
            SecurityContext securityContext = SecurityContext.getCurrent();
            if (securityContext != null && !securityContext.didServerGenerateCredentials()) {
                subject = securityContext.getSubject();
            }
        }
        if (subject == null) {
            subject = new Subject();
        }
        return subject;
    }

    public void getSessionToken(Map<String, Object> properties, MessageInfo messageInfo, Subject subject) throws AuthException {
        ClientAuthConfig clientAuthConfig = (ClientAuthConfig)this.getAuthConfig(false);
        if (clientAuthConfig != null) {
            properties.putAll(this.map);
            SoapAuthenticationService.addModel(messageInfo, this.map);
            clientAuthConfig.getAuthContext(clientAuthConfig.getAuthContextID(messageInfo), subject, properties);
        }
    }

    public void authorize(Packet request) throws Exception {
        Subject subject = (Subject)request.invocationProperties.get("CLIENT_SUBJECT");
        if (subject == null || subject.getPrincipals().isEmpty() && subject.getPublicCredentials().isEmpty()) {
            SecurityContext.setUnauthenticatedContext();
        } else {
            SecurityContext.setCurrent((SecurityContext)new SecurityContext(subject));
        }
        if (this.isEjbEndpoint) {
            if (this.invocationManager == null) {
                throw new RuntimeException(localStrings.getLocalString("enterprise.webservice.noEjbInvocationManager", "Cannot validate request : invocation manager null for EJB WebService"));
            }
            ComponentInvocation currentInvocation = this.invocationManager.getCurrentInvocation();
            if (this.ejbDelegate != null) {
                this.ejbDelegate.setSOAPMessage((Object)request.getMessage(), currentInvocation);
            }
            Method targetMethod = null;
            if (this.seiModel != null) {
                JavaMethod jm = request.getMessage().getMethod(this.seiModel);
                targetMethod = jm != null ? jm.getMethod() : null;
            } else {
                String ejbImplClassName;
                WebServiceEndpoint endpoint = (WebServiceEndpoint)this.map.get("SERVICE_ENDPOINT");
                EjbDescriptor ejbDescriptor = endpoint.getEjbComponentImpl();
                if (ejbDescriptor != null && (ejbImplClassName = ejbDescriptor.getEjbImplClassName()) != null) {
                    try {
                        targetMethod = Class.forName(ejbImplClassName, true, Thread.currentThread().getContextClassLoader()).getMethod("invoke", Object.class);
                    }
                    catch (ReflectiveOperationException pae) {
                        throw new RuntimeException(pae);
                    }
                }
            }
            if (targetMethod != null && this.ejbDelegate != null) {
                try {
                    if (!this.ejbDelegate.authorize(currentInvocation, targetMethod)) {
                        throw new Exception(localStrings.getLocalString("enterprise.webservice.methodNotAuth", "Client not authorized for invocation of {0}", new Object[]{targetMethod}));
                    }
                }
                catch (UnmarshalException e) {
                    throw new UnmarshalException(localStrings.getLocalString("enterprise.webservice.errorUnMarshalMethod", "Error unmarshalling method for ejb {0}", new Object[]{this.ejbName()}), (Throwable)e);
                }
                catch (Exception e) {
                    throw new Exception(localStrings.getLocalString("enterprise.webservice.methodNotAuth", "Client not authorized for invocation of {0}", new Object[]{targetMethod}), e);
                }
            }
        }
    }

    public void auditInvocation(Packet request, AuthStatus status) {
        if (this.auditManager.isAuditOn()) {
            WebServiceEndpoint endpoint;
            String uri = null;
            if (!this.isEjbEndpoint && request != null && request.supports((Object)"jakarta.xml.ws.servlet.request")) {
                HttpServletRequest httpServletRequest = (HttpServletRequest)request.get((Object)"jakarta.xml.ws.servlet.request");
                uri = httpServletRequest.getRequestURI();
            }
            String endpointName = null;
            if (this.map != null && (endpoint = (WebServiceEndpoint)this.map.get("SERVICE_ENDPOINT")) != null) {
                endpointName = endpoint.getEndpointName();
            }
            if (endpointName == null) {
                endpointName = "(no endpoint)";
            }
            if (this.isEjbEndpoint) {
                this.auditManager.ejbAsWebServiceInvocation(endpointName, AuthStatus.SUCCESS.equals(status));
            } else {
                this.auditManager.webServiceInvocation(uri == null ? "(no uri)" : uri, endpointName, AuthStatus.SUCCESS.equals(status));
            }
        }
    }

    public Object getModelName() {
        WSDLPort wsdlModel = (WSDLPort)this.getProperty("WSDL_MODEL");
        return wsdlModel == null ? "unknown" : wsdlModel.getName();
    }

    public Packet makeFaultResponse(Packet response, Throwable t) {
        if (!(t instanceof WebServiceException)) {
            t = new WebServiceException(t);
        }
        if (response == null) {
            response = new Packet();
        }
        try {
            return response.createResponse(Messages.create((Throwable)t, (SOAPVersion)this.soapVersion));
        }
        catch (Exception e) {
            response = new Packet();
            return response.createResponse(Messages.create((Throwable)t, (SOAPVersion)this.soapVersion));
        }
    }

    public boolean isTwoWay(boolean twoWayIsDefault, Packet request) {
        WSDLPort wsdlModel;
        boolean twoWay = twoWayIsDefault;
        Message requestMessage = request.getMessage();
        if (requestMessage != null && (wsdlModel = (WSDLPort)this.getProperty("WSDL_MODEL")) != null) {
            twoWay = !requestMessage.isOneWay(wsdlModel);
        }
        return twoWay;
    }

    public Packet getFaultResponse(Packet request, Packet response, Throwable t) {
        boolean twoWay = true;
        try {
            twoWay = this.isTwoWay(true, request);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (twoWay) {
            return this.makeFaultResponse(response, t);
        }
        return new Packet();
    }

    public void disable() {
        this.listenerWrapper.disableWithRefCount();
    }

    private static boolean isACC() {
        return SecurityServicesUtil.getInstance() == null || SecurityServicesUtil.getInstance().isACC();
    }

    private boolean processSunDeploymentDescriptor() {
        WebServiceEndpoint webServiceEndpoint;
        if (this.authConfigFactory == null) {
            return false;
        }
        MessageSecurityBindingDescriptor binding = AuthMessagePolicy.getMessageSecurityBinding((String)"SOAP", (Map)this.map);
        Function<MessageInfo, String> authContextIdGenerator = e -> ((WebServicesDelegate)Globals.get(WebServicesDelegate.class)).getAuthContextID(e);
        BiFunction<String, Map, MessagePolicy[]> soapPolicyGenerator = (authContextId, properties) -> AuthMessagePolicy.getSOAPPolicies((MessageSecurityBindingDescriptor)AuthMessagePolicy.getMessageSecurityBinding((String)"SOAP", (Map)properties), (String)authContextId, (boolean)true);
        String authModuleId = AuthMessagePolicy.getProviderID((MessageSecurityBindingDescriptor)binding);
        this.map.put("authContextIdGenerator", authContextIdGenerator);
        this.map.put("soapPolicyGenerator", soapPolicyGenerator);
        if (authModuleId != null) {
            this.map.put("authModuleId", authModuleId);
        }
        if (binding != null && !this.hasExactMatchAuthProvider()) {
            String jmacProviderRegisID = this.authConfigFactory.registerConfigProvider((AuthConfigProvider)new GFServerConfigProvider(this.map, (ConfigParser)(SoapAuthenticationService.isACC() ? new ConfigXMLParser() : new ConfigDomainParser()), this.authConfigFactory), this.messageLayer, this.appContextId, "GF AuthConfigProvider bound by Sun Specific Descriptor");
            this.setRegistrationId(jmacProviderRegisID);
        }
        return (webServiceEndpoint = (WebServiceEndpoint)this.map.get("SERVICE_ENDPOINT")) == null ? false : webServiceEndpoint.implementedByEjbComponent();
    }

    private static String getAppCtxt(Map map) {
        WebServiceEndpoint webServiceEndpoint = (WebServiceEndpoint)map.get("SERVICE_ENDPOINT");
        if (webServiceEndpoint != null) {
            return SoapAuthenticationService.getServerName(webServiceEndpoint) + " " + SoapAuthenticationService.getEndpointURI(webServiceEndpoint);
        }
        ServiceReferenceDescriptor serviceReferenceDescriptor = (ServiceReferenceDescriptor)map.get("SERVICE_REF");
        return SoapAuthenticationService.getClientModuleID(serviceReferenceDescriptor) + " " + SoapAuthenticationService.getRefName(serviceReferenceDescriptor, map);
    }

    private static String getServerName(WebServiceEndpoint wse) {
        String hostname = "localhost";
        return hostname;
    }

    private static String getRefName(ServiceReferenceDescriptor serviceReferenceDescriptor, Map map) {
        URL url;
        EndpointAddress endpointAddress;
        String name = null;
        if (serviceReferenceDescriptor != null) {
            name = serviceReferenceDescriptor.getName();
        }
        if (name == null && (endpointAddress = (EndpointAddress)map.get("ENDPOINT_ADDRESS")) != null && (url = endpointAddress.getURL()) != null) {
            name = url.toString();
        }
        if (name == null) {
            name = "#default-ref-name#";
        }
        return name;
    }

    private static String getEndpointURI(WebServiceEndpoint webServiceEndpoint) {
        Object uri = "#default-endpoint-context#";
        if (webServiceEndpoint != null) {
            Object contextRoot;
            WebBundleDescriptor webBundleDescriptor;
            uri = webServiceEndpoint.getEndpointAddressUri();
            if (uri != null && !((String)uri).startsWith("/")) {
                uri = "/" + (String)uri;
            }
            if (webServiceEndpoint.implementedByWebComponent() && (webBundleDescriptor = (WebBundleDescriptor)webServiceEndpoint.getBundleDescriptor()) != null && (contextRoot = webBundleDescriptor.getContextRoot()) != null) {
                if (!((String)contextRoot).startsWith("/")) {
                    contextRoot = "/" + (String)contextRoot;
                }
                uri = (String)contextRoot + (String)uri;
            }
        }
        return uri;
    }

    private static String getClientModuleID(ServiceReferenceDescriptor serviceReferenceDescriptor) {
        String clientModuleID = "#default-client-context#";
        if (serviceReferenceDescriptor != null) {
            Application application;
            ModuleDescriptor moduleDescriptor = null;
            BundleDescriptor bundleDescriptor = serviceReferenceDescriptor.getBundleDescriptor();
            if (bundleDescriptor != null) {
                moduleDescriptor = bundleDescriptor.getModuleDescriptor();
            }
            Application application2 = application = bundleDescriptor == null ? null : bundleDescriptor.getApplication();
            if (application != null) {
                if (application.isVirtual()) {
                    clientModuleID = application.getRegistrationName();
                } else if (moduleDescriptor != null) {
                    clientModuleID = FileUtils.makeFriendlyFilename((String)moduleDescriptor.getArchiveUri());
                }
            } else if (moduleDescriptor != null) {
                clientModuleID = FileUtils.makeFriendlyFilename((String)moduleDescriptor.getArchiveUri());
            }
        }
        return clientModuleID;
    }

    private static void addModel(MessageInfo messageInfo, Map<String, Object> map) {
        Object model = map.get("WSDL_MODEL");
        if (model != null) {
            messageInfo.getMap().put("WSDL_MODEL", model);
        }
    }

    private static void addPolicy(MessageInfo messageInfo, Map<String, Object> map) {
        Object policy = map.get("POLICY");
        if (policy != null) {
            messageInfo.getMap().put("POLICY", policy);
        }
    }

    private String ejbName() {
        WebServiceEndpoint webServiceEndpoint = (WebServiceEndpoint)this.getProperty("SERVICE_ENDPOINT");
        return webServiceEndpoint == null ? "unknown" : webServiceEndpoint.getEjbComponentImpl().getName();
    }
}

