/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.annotation.handlers;

import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.InjectionTarget;
import com.sun.enterprise.deployment.MetadataSource;
import com.sun.enterprise.deployment.annotation.context.ResourceContainerContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractResourceHandler;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.StringUtils;
import jakarta.ejb.EJB;
import jakarta.ejb.EJBHome;
import jakarta.ejb.EJBLocalHome;
import jakarta.ejb.Local;
import java.lang.annotation.ElementType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.logging.Level;
import org.glassfish.apf.AnnotationHandlerFor;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.api.naming.SimpleJndiName;
import org.jvnet.hk2.annotations.Service;

@Service
@AnnotationHandlerFor(value=EJB.class)
public class EJBHandler
extends AbstractResourceHandler {
    private static final LocalStringManagerImpl I18N = new LocalStringManagerImpl(EJBHandler.class);

    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, ResourceContainerContext[] rcContexts) throws AnnotationProcessorException {
        EJB ejbAn = (EJB)ainfo.getAnnotation();
        return this.processEJB(ainfo, rcContexts, ejbAn);
    }

    protected HandlerProcessingResult processEJB(AnnotationInfo ainfo, ResourceContainerContext[] rcContexts, EJB ejbAn) throws AnnotationProcessorException {
        EjbReferenceDescriptor[] ejbRefs = null;
        String defaultLogicalName = null;
        Class<?> defaultBeanInterface = null;
        InjectionTarget target = null;
        if (ElementType.FIELD.equals((Object)ainfo.getElementType())) {
            Field f = (Field)ainfo.getAnnotatedElement();
            targetClassName = f.getDeclaringClass().getName();
            defaultLogicalName = targetClassName + "/" + f.getName();
            defaultBeanInterface = f.getType();
            target = new InjectionTarget();
            target.setClassName(targetClassName);
            target.setFieldName(f.getName());
            target.setMetadataSource(MetadataSource.ANNOTATION);
        } else if (ElementType.METHOD.equals((Object)ainfo.getElementType())) {
            Method m = (Method)ainfo.getAnnotatedElement();
            targetClassName = m.getDeclaringClass().getName();
            this.validateInjectionMethod(m, ainfo);
            String propertyName = this.getInjectionMethodPropertyName(m, ainfo);
            defaultLogicalName = targetClassName + "/" + propertyName;
            defaultBeanInterface = m.getParameterTypes()[0];
            target = new InjectionTarget();
            target.setClassName(targetClassName);
            target.setMethodName(m.getName());
            target.setMetadataSource(MetadataSource.ANNOTATION);
        } else if (ElementType.TYPE.equals((Object)ainfo.getElementType())) {
            if (ejbAn.name().equals("") || ejbAn.beanInterface() == Object.class) {
                Class c = (Class)ainfo.getAnnotatedElement();
                AnnotationProcessorException fatalException = new AnnotationProcessorException(I18N.getLocalString("enterprise.deployment.annotation.handlers.invalidtypelevelejb", "Invalid TYPE-level @EJB with name() = [{0}] and beanInterface = [{1}] in {2}.  Each TYPE-level @EJB must specify both name() and beanInterface().", new Object[]{ejbAn.name(), ejbAn.beanInterface(), c}), ainfo);
                fatalException.setFatal(true);
                throw fatalException;
            }
        } else {
            return this.getDefaultFailedResult();
        }
        Class<?> beanInterface = ejbAn.beanInterface() == Object.class ? defaultBeanInterface : ejbAn.beanInterface();
        Object logicalName = ejbAn.name().isEmpty() ? defaultLogicalName : ejbAn.name();
        for (EjbReferenceDescriptor ejbRef : ejbRefs = this.getEjbReferenceDescriptors((String)logicalName, rcContexts)) {
            if (target != null) {
                ejbRef.addInjectionTarget(target);
            }
            if (!StringUtils.ok((String)ejbRef.getName())) {
                ejbRef.setName((String)logicalName);
            }
            this.setEjbType(ejbRef, beanInterface);
            if (!StringUtils.ok((String)ejbRef.getDescription()) && StringUtils.ok((String)ejbAn.description())) {
                ejbRef.setDescription(ejbAn.description());
            }
            if (!ejbRef.hasLookupName() && StringUtils.ok((String)ejbAn.lookup())) {
                ejbRef.setLookupName(SimpleJndiName.of((String)ejbAn.lookup()));
            }
            if ((ejbRef.getMappedName() == null || ejbRef.getMappedName().isEmpty()) && StringUtils.ok((String)ejbAn.mappedName())) {
                ejbRef.setMappedName(SimpleJndiName.of((String)ejbAn.mappedName()));
            }
            if (StringUtils.ok((String)ejbRef.getLinkName()) || !StringUtils.ok((String)ejbAn.beanName())) continue;
            ejbRef.setLinkName(ejbAn.beanName());
        }
        return this.getDefaultProcessedResult();
    }

    private EjbReferenceDescriptor[] getEjbReferenceDescriptors(String logicalName, ResourceContainerContext[] rcContexts) {
        EjbReferenceDescriptor[] ejbRefs = new EjbReferenceDescriptor[rcContexts.length];
        for (int i = 0; i < rcContexts.length; ++i) {
            EjbReferenceDescriptor ejbRef = rcContexts[i].getEjbReference(logicalName);
            if (ejbRef == null) {
                ejbRef = new EjbReferenceDescriptor();
                rcContexts[i].addEjbReferenceDescriptor(ejbRef);
            }
            ejbRefs[i] = ejbRef;
        }
        return ejbRefs;
    }

    private void setEjbType(EjbReferenceDescriptor ejbRef, Class beanInterface) {
        if (EJBHome.class.isAssignableFrom(beanInterface) || EJBLocalHome.class.isAssignableFrom(beanInterface)) {
            this.setEjbHomeType(ejbRef, beanInterface);
        } else {
            this.setEjbIntfType(ejbRef, beanInterface);
        }
    }

    private void setEjbIntfType(EjbReferenceDescriptor ejbRef, Class beanInterface) {
        if (ejbRef.getEjbInterface() != null) {
            return;
        }
        ejbRef.setEjbInterface(beanInterface.getName());
        if (beanInterface.getAnnotation(Local.class) != null) {
            ejbRef.setLocal(true);
        } else {
            ejbRef.setLocal(false);
        }
        ejbRef.setType("Session");
    }

    private void setEjbHomeType(EjbReferenceDescriptor ejbRef, Class beanInterface) {
        if (ejbRef.getHomeClassName() != null) {
            return;
        }
        String targetBeanType = "Session";
        ejbRef.setHomeClassName(beanInterface.getName());
        try {
            Method[] methods;
            for (Method m : methods = beanInterface.getMethods()) {
                if (!m.getName().equals("create")) continue;
                ejbRef.setEjbInterface(m.getReturnType().getName());
                break;
            }
            for (Method m : methods) {
                if (!m.getName().equals("findByPrimaryKey")) continue;
                targetBeanType = "Entity";
                break;
            }
        }
        catch (Exception e) {
            logger.log(Level.FINE, "component intf / ejb type annotation processing error", e);
        }
        ejbRef.setLocal(EJBLocalHome.class.isAssignableFrom(beanInterface));
        ejbRef.setType(targetBeanType);
    }
}

