/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cluster.ssh.sftp;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import org.glassfish.cluster.ssh.sftp.SFTPFileSystem;
import org.glassfish.cluster.ssh.sftp.SFTPFileSystemProvider;

public final class SFTPPath
implements Path {
    private static final SFTPFileSystem FS = new SFTPFileSystem(new SFTPFileSystemProvider());
    private static final String ROOT = FS.getSeparator();
    private static final SFTPPath PATH_ROOT = new SFTPPath(true, new String[0]);
    private boolean absolute;
    private List<String> path;

    private SFTPPath(boolean absolute, String ... path) {
        this.absolute = absolute;
        this.path = List.of(path);
    }

    private SFTPPath(boolean absolute, List<String> path) {
        this.absolute = absolute;
        this.path = path;
    }

    @Override
    public FileSystem getFileSystem() {
        return FS;
    }

    @Override
    public boolean isAbsolute() {
        return this.absolute;
    }

    @Override
    public SFTPPath getRoot() {
        return PATH_ROOT;
    }

    @Override
    public SFTPPath getFileName() {
        int length = this.getNameCount();
        if (length == 0) {
            return null;
        }
        return new SFTPPath(false, this.path.get(length - 1));
    }

    @Override
    public SFTPPath getParent() {
        int length = this.getNameCount();
        if (length == 0) {
            return null;
        }
        if (length == 1) {
            return this.getRoot();
        }
        return new SFTPPath(this.absolute, this.path.subList(0, length - 1));
    }

    @Override
    public int getNameCount() {
        return this.path.size();
    }

    @Override
    public SFTPPath getName(int index) {
        return new SFTPPath(false, this.path.get(index));
    }

    @Override
    public SFTPPath subpath(int beginIndex, int endIndex) {
        int length = this.getNameCount();
        if (beginIndex == 0 && endIndex == length) {
            return this;
        }
        if (beginIndex < 0) {
            throw new IllegalArgumentException("The beginIndex is lower than zero");
        }
        if (beginIndex >= length) {
            throw new IllegalArgumentException("The beginIndex is higher than length");
        }
        if (endIndex > length) {
            throw new IllegalArgumentException("The endIndex is higher than length");
        }
        if (beginIndex >= endIndex) {
            throw new IllegalArgumentException("The beginIndex is not lower than endIndex");
        }
        return new SFTPPath(this.absolute && beginIndex == 0, this.path.subList(beginIndex, endIndex));
    }

    @Override
    public boolean startsWith(String other) {
        SFTPPath theother = SFTPPath.of(other);
        return this.startsWith(theother);
    }

    @Override
    public boolean startsWith(Path other) {
        if (other.getNameCount() > this.getNameCount()) {
            return false;
        }
        if (this.isAbsolute() && !other.isAbsolute() || !this.isAbsolute() && other.isAbsolute()) {
            return false;
        }
        Iterator<Path> iOther = other.iterator();
        Iterator<Path> iMy = this.iterator();
        while (iMy.hasNext() && iOther.hasNext()) {
            if (iMy.next().toString().equals(iOther.next().toString())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean endsWith(String other) {
        SFTPPath theother = SFTPPath.of(other);
        return this.endsWith(theother);
    }

    @Override
    public boolean endsWith(Path other) {
        int nameCount = this.getNameCount();
        int otherNameCount = other.getNameCount();
        if (otherNameCount > nameCount) {
            return false;
        }
        int diff = nameCount - otherNameCount;
        for (int i = other.getNameCount() - 1; i >= 0; --i) {
            if (this.getName(i + diff).toString().equals(other.getName(i).toString())) continue;
            return false;
        }
        return !other.isAbsolute() || this.isAbsolute();
    }

    public boolean contains(String name) {
        for (String element : this.path) {
            if (!element.equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public SFTPPath normalize() {
        boolean[] filter = new boolean[this.getNameCount()];
        for (int i = 0; i < this.path.size(); ++i) {
            String name = this.path.get(i);
            if (".".equals(name)) {
                filter[i] = true;
            }
            if (!"..".equals(name)) continue;
            boolean found = false;
            for (int j = i - 1; j >= 0; --j) {
                if (filter[j]) continue;
                filter[j] = true;
                found = true;
                break;
            }
            if (!found) continue;
            filter[i] = true;
        }
        ArrayList<String> filtered = new ArrayList<String>(filter.length);
        for (int i = 0; i < filter.length; ++i) {
            if (filter[i]) continue;
            filtered.add(this.path.get(i));
        }
        return new SFTPPath(this.absolute, List.copyOf(filtered));
    }

    @Override
    public SFTPPath resolve(String other) {
        return this.resolve(SFTPPath.of(other));
    }

    @Override
    public SFTPPath resolve(Path other) {
        if (other.isAbsolute()) {
            return SFTPPath.of(other);
        }
        if (other.toString().isEmpty()) {
            return this;
        }
        return SFTPPath.of(this.toString() + FS.getSeparator() + other.toString());
    }

    @Override
    public SFTPPath relativize(Path other) {
        throw new UnsupportedOperationException("Unsupported method: relativize");
    }

    @Override
    public SFTPPath resolveSibling(String other) {
        return this.resolveSibling(SFTPPath.of(other));
    }

    @Override
    public SFTPPath resolveSibling(Path other) {
        throw new UnsupportedOperationException("Unsupported method: resolveSibling");
    }

    @Override
    public URI toUri() {
        return URI.create(FS.provider().getScheme() + this.toString());
    }

    @Override
    public File toFile() {
        throw new UnsupportedOperationException("Unsupported toFile - we cannot resolve remote files in this class");
    }

    @Override
    public SFTPPath toAbsolutePath() {
        throw new UnsupportedOperationException("Unsupported toAbsolutePath - we cannot resolve remote paths in this class");
    }

    @Override
    public SFTPPath toRealPath(LinkOption ... options) throws IOException {
        throw new UnsupportedOperationException("Unsupported toRealPath - we cannot resolve remote paths in this class");
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        throw new UnsupportedOperationException("Unsupported resgister watcher - we cannot watch remote paths in this class");
    }

    @Override
    public Iterator<Path> iterator() {
        return new Iterator<Path>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < SFTPPath.this.getNameCount();
            }

            @Override
            public SFTPPath next() {
                if (this.i < SFTPPath.this.getNameCount()) {
                    SFTPPath result = SFTPPath.this.getName(this.i);
                    ++this.i;
                    return result;
                }
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    public int compareTo(Path other) {
        return this.toString().compareTo(other.toString());
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof SFTPPath) {
            return this.toString().equals(other.toString());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.path.hashCode();
    }

    @Override
    public String toString() {
        StringBuilder string = new StringBuilder(64);
        boolean isFirst = true;
        if (this.isAbsolute()) {
            string.append(ROOT);
        }
        for (String name : this.path) {
            if (isFirst) {
                isFirst = false;
            } else {
                string.append(FS.getSeparator());
            }
            string.append(name);
        }
        return string.toString();
    }

    public static SFTPPath of(File file) {
        return SFTPPath.of(file.toPath().normalize());
    }

    public static SFTPPath of(Path path) {
        if (path instanceof SFTPPath) {
            return (SFTPPath)path;
        }
        Path relativeToRoot = path.isAbsolute() ? path.getRoot().relativize(path) : path;
        String fixedSeparators = relativeToRoot.toString().replaceAll("\\\\", "/");
        if (path.isAbsolute()) {
            return PATH_ROOT.resolve(fixedSeparators);
        }
        return SFTPPath.of(fixedSeparators).normalize();
    }

    public static SFTPPath of(String path) {
        String[] elements = (String[])Arrays.stream(path.split(FS.getSeparator())).filter(Predicate.not(String::isEmpty)).toArray(String[]::new);
        return new SFTPPath(path.startsWith(ROOT), elements);
    }

    public static SFTPPath ofAbsolutePath(String ... path) {
        return new SFTPPath(true, path);
    }

    public static SFTPPath ofRelativePath(String ... path) {
        return new SFTPPath(false, path);
    }

    public static SFTPPath ofFileName(String fileName) {
        return new SFTPPath(false, fileName);
    }
}

