/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.admin.util.InstanceStateService;
import com.sun.enterprise.admin.util.RemoteInstanceCommandHelper;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Clusters;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.cluster.InstanceInfo;
import com.sun.enterprise.v3.admin.cluster.Strings;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.InstanceState;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.config.ReferenceContainer;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service(name="list-clusters")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="list.clusters.command")
@RestEndpoints(value={@RestEndpoint(configBean=Clusters.class, opType=RestEndpoint.OpType.GET, path="list-clusters", description="List Clusters")})
public final class ListClustersCommand
implements AdminCommand {
    @Inject
    private ServiceLocator habitat;
    @Inject
    Domain domain;
    @Inject
    InstanceStateService stateService;
    private static final String NONE = "Nothing to list.";
    private static final String EOL = "\n";
    @Param(optional=true, primary=true, defaultValue="domain")
    String whichTarget;
    @Inject
    private Clusters allClusters;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        Logger logger = context.getLogger();
        ActionReport.MessagePart top = report.getTopMessagePart();
        List clusterList = null;
        if (this.whichTarget.equals("domain")) {
            Clusters clusters = this.domain.getClusters();
            clusterList = clusters.getCluster();
        } else {
            clusterList = this.createClusterList();
            if (clusterList == null) {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setMessage(Strings.get("list.instances.badTarget", this.whichTarget));
                return;
            }
        }
        StringBuilder sb = new StringBuilder();
        if (clusterList.size() < 1) {
            sb.append(NONE);
        }
        int timeoutInMsec = 2000;
        HashMap<Object, ClusterInfo> clusterMap = new HashMap<Object, ClusterInfo>();
        LinkedList<InstanceInfo> infos = new LinkedList<InstanceInfo>();
        for (Cluster cluster : clusterList) {
            String clusterName = cluster.getName();
            List servers = cluster.getInstances();
            if (servers.isEmpty()) {
                ClusterInfo ci = (ClusterInfo)clusterMap.get(clusterName);
                if (ci == null) {
                    ci = new ClusterInfo(clusterName);
                }
                ci.serversEmpty = true;
                clusterMap.put(clusterName, ci);
            }
            for (Server server : servers) {
                String name = server.getName();
                if (name == null) continue;
                ActionReport tReport = (ActionReport)this.habitat.getService(ActionReport.class, "html", new Annotation[0]);
                InstanceInfo ii = new InstanceInfo(this.habitat, server, new RemoteInstanceCommandHelper(this.habitat).getAdminPort(server), server.getAdminHost(), clusterName, logger, timeoutInMsec, tReport, this.stateService);
                infos.add(ii);
            }
        }
        for (InstanceInfo ii : infos) {
            String clusterforInstance = ii.getCluster();
            ClusterInfo ci = (ClusterInfo)clusterMap.get(clusterforInstance);
            if (ci == null) {
                ci = new ClusterInfo(clusterforInstance);
            }
            ci.allInstancesRunning &= ii.isRunning();
            if (ii.isRunning()) {
                ci.atleastOneInstanceRunning = true;
            }
            clusterMap.put(clusterforInstance, ci);
        }
        for (ClusterInfo ci : clusterMap.values()) {
            String value;
            String display;
            if (ci.serversEmpty || !ci.atleastOneInstanceRunning) {
                display = InstanceState.StateType.NOT_RUNNING.getDisplayString();
                value = InstanceState.StateType.NOT_RUNNING.getDescription();
            } else if (ci.allInstancesRunning) {
                display = InstanceState.StateType.RUNNING.getDisplayString();
                value = InstanceState.StateType.RUNNING.getDescription();
            } else {
                display = " partially running";
                value = "PARTIALLY_RUNNING";
            }
            sb.append(ci.getName()).append(display).append(EOL);
            top.addProperty(ci.getName(), value);
        }
        String output = sb.toString();
        report.setMessage(output.substring(0, output.length() - 1));
    }

    private List<Cluster> createClusterList() {
        if (!StringUtils.ok((String)this.whichTarget)) {
            return this.allClusters.getCluster();
        }
        ReferenceContainer rc = this.domain.getReferenceContainerNamed(this.whichTarget);
        if (rc == null) {
            return this.getClustersForNodeOrConfig();
        }
        if (rc.isServer()) {
            Server s = (Server)rc;
            LinkedList<Cluster> cl = new LinkedList<Cluster>();
            cl.add(s.getCluster());
            return cl;
        }
        if (rc.isCluster()) {
            Cluster cluster = (Cluster)rc;
            LinkedList<Cluster> cl = new LinkedList<Cluster>();
            cl.add(cluster);
            return cl;
        }
        return null;
    }

    private List<Cluster> getClustersForNodeOrConfig() {
        if (this.whichTarget == null) {
            throw new NullPointerException("impossible!");
        }
        List<Cluster> list = this.getClustersForNode();
        if (list == null) {
            list = this.getClustersForConfig();
        }
        return list;
    }

    private List<Cluster> getClustersForNode() {
        List nodeList;
        boolean foundNode = false;
        Nodes nodes = this.domain.getNodes();
        if (nodes != null && (nodeList = nodes.getNode()) != null) {
            for (Node node : nodeList) {
                if (!this.whichTarget.equals(node.getName())) continue;
                foundNode = true;
                break;
            }
        }
        if (!foundNode) {
            return null;
        }
        return this.domain.getClustersOnNode(this.whichTarget);
    }

    private List<Cluster> getClustersForConfig() {
        Config config = this.domain.getConfigNamed(this.whichTarget);
        if (config == null) {
            return null;
        }
        List rcs = this.domain.getReferenceContainersOf(config);
        LinkedList<Cluster> clusters = new LinkedList<Cluster>();
        for (ReferenceContainer rc : rcs) {
            if (!rc.isCluster()) continue;
            clusters.add((Cluster)rc);
        }
        return clusters;
    }

    private static class ClusterInfo {
        private boolean atleastOneInstanceRunning = false;
        private boolean allInstancesRunning = true;
        private boolean serversEmpty = false;
        private String name;

        public String getName() {
            return this.name;
        }

        private ClusterInfo(String name) {
            this.name = name;
        }
    }
}

