/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.SessionCookieConfig;
import jakarta.servlet.SessionTrackingMode;
import jakarta.servlet.descriptor.JspConfigDescriptor;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Map;
import java.util.Set;
import org.apache.catalina.core.ApplicationContext;
import org.apache.catalina.core.DummyFilterRegistrationDynamic;
import org.apache.catalina.core.WebSocketFilterWrapper;

public final class ApplicationContextFacade
implements ServletContext {
    private final ApplicationContext context;

    public ApplicationContextFacade(ApplicationContext context) {
        this.context = context;
    }

    public String getContextPath() {
        return this.context.getContextPath();
    }

    public ServletContext getContext(String uripath) {
        ServletContext theContext = this.context.getContext(uripath);
        if (theContext instanceof ApplicationContext) {
            return ((ApplicationContext)theContext).getFacade();
        }
        return theContext;
    }

    public int getMajorVersion() {
        return this.context.getMajorVersion();
    }

    public int getMinorVersion() {
        return this.context.getMinorVersion();
    }

    public int getEffectiveMajorVersion() {
        return this.context.getEffectiveMajorVersion();
    }

    public int getEffectiveMinorVersion() {
        return this.context.getEffectiveMinorVersion();
    }

    public String getMimeType(String file) {
        return this.context.getMimeType(file);
    }

    public Set<String> getResourcePaths(String path) {
        return this.context.getResourcePaths(path);
    }

    public URL getResource(String path) throws MalformedURLException {
        return this.context.getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        return this.context.getResourceAsStream(path);
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return this.context.getRequestDispatcher(path);
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        return this.context.getNamedDispatcher(name);
    }

    public void log(String msg) {
        this.context.log(msg);
    }

    public void log(String message, Throwable throwable) {
        this.context.log(message, throwable);
    }

    public String getRealPath(String path) {
        return this.context.getRealPath(path);
    }

    public String getServerInfo() {
        return this.context.getServerInfo();
    }

    public String getInitParameter(String name) {
        return this.context.getInitParameter(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return this.context.getInitParameterNames();
    }

    public boolean setInitParameter(String name, String value) {
        return this.context.setInitParameter(name, value);
    }

    public Object getAttribute(String name) {
        return this.context.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        return this.context.getAttributeNames();
    }

    public void setAttribute(String name, Object object) {
        this.context.setAttribute(name, object);
    }

    public void removeAttribute(String name) {
        this.context.removeAttribute(name);
    }

    public String getServletContextName() {
        return this.context.getServletContextName();
    }

    public ServletRegistration.Dynamic addServlet(String servletName, String className) {
        return this.context.addServlet(servletName, className);
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
        return this.context.addServlet(servletName, servlet);
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
        return this.context.addServlet(servletName, servletClass);
    }

    public ServletRegistration.Dynamic addJspFile(String servletName, String jspFile) {
        return this.context.addJspFile(servletName, jspFile);
    }

    public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
        return this.context.createServlet(clazz);
    }

    public ServletRegistration getServletRegistration(String servletName) {
        return this.context.getServletRegistration(servletName);
    }

    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        return this.context.getServletRegistrations();
    }

    public FilterRegistration.Dynamic addFilter(String filterName, String className) {
        return this.context.addFilter(filterName, className);
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
        Filter wrappedFilter = "WebSocket filter".equals(filterName) ? new WebSocketFilterWrapper(filter) : filter;
        FilterRegistration.Dynamic registration = this.context.addFilter(filterName, wrappedFilter);
        if (registration == null && "WebSocket filter".equals(filterName)) {
            registration = new DummyFilterRegistrationDynamic();
        }
        return registration;
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
        return this.context.addFilter(filterName, filterClass);
    }

    public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
        return this.context.createFilter(clazz);
    }

    public FilterRegistration getFilterRegistration(String filterName) {
        return this.context.getFilterRegistration(filterName);
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        return this.context.getFilterRegistrations();
    }

    public SessionCookieConfig getSessionCookieConfig() {
        return this.context.getSessionCookieConfig();
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
        this.context.setSessionTrackingModes(sessionTrackingModes);
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return this.context.getDefaultSessionTrackingModes();
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return this.context.getEffectiveSessionTrackingModes();
    }

    public void addListener(String className) {
        this.context.addListener(className);
    }

    public <T extends EventListener> void addListener(T listener) {
        this.context.addListener(listener);
    }

    public void addListener(Class<? extends EventListener> listenerClass) {
        this.context.addListener(listenerClass);
    }

    public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
        return this.context.createListener(clazz);
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        return this.context.getJspConfigDescriptor();
    }

    public ClassLoader getClassLoader() {
        return this.context.getClassLoader();
    }

    public void declareRoles(String ... roleNames) {
        this.context.declareRoles(roleNames);
    }

    public String getVirtualServerName() {
        return this.context.getVirtualServerName();
    }

    public int getSessionTimeout() {
        return this.context.getSessionTimeout();
    }

    public void setSessionTimeout(int sessionTimeout) {
        this.context.setSessionTimeout(sessionTimeout);
    }

    public String getRequestCharacterEncoding() {
        return this.context.getRequestCharacterEncoding();
    }

    public void setRequestCharacterEncoding(String encoding) {
        this.context.setRequestCharacterEncoding(encoding);
    }

    public String getResponseCharacterEncoding() {
        return this.context.getResponseCharacterEncoding();
    }

    public void setResponseCharacterEncoding(String encoding) {
        this.context.setResponseCharacterEncoding(encoding);
    }

    public String toString() {
        return super.toString() + "[context=" + String.valueOf(this.context) + "]";
    }
}

