/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.override.table;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.override.table.NoTableAnnotation;
import java.util.Properties;

public class Client
extends PMClientBase {
    private static final Long ID = 1L;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            this.logErr("Exception:test failed ", e);
        }
    }

    public void testNoTableAnnotation() throws Exception {
        NoTableAnnotation entity = new NoTableAnnotation();
        entity.setId(ID);
        try {
            this.getEntityTransaction().begin();
            this.logTrace("persisting entity" + String.valueOf(entity));
            this.getEntityManager().persist((Object)entity);
            this.logTrace("flushing");
            this.getEntityManager().flush();
            this.logTrace("Test Passed");
        }
        catch (Exception e) {
            this.logErr("test failed");
            throw new Exception(e);
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("Cleanup data");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM NOENTITYLISTENER_TABLE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

