/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.jpa22.query.stream;

import ee.jakarta.tck.persistence.jpa22.query.stream.Department;
import ee.jakarta.tck.persistence.jpa22.query.stream.Insurance;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.io.Serializable;
import java.sql.Date;

@Entity
@Table(name="EMPLOYEE")
public class Employee
implements Serializable,
Comparable<Employee> {
    private static final long serialVersionUID = 22L;
    private int id;
    private String firstName;
    private String lastName;
    private Date hireDate;
    private float salary;
    private Department department;
    private Insurance insurance;

    public Employee() {
    }

    public Employee(int id, String firstName, String lastName, Date hireDate, float salary) {
        this.id = id;
        this.firstName = firstName;
        this.lastName = lastName;
        this.hireDate = hireDate;
        this.salary = salary;
    }

    public Employee(int id, String firstName, String lastName, Date hireDate, float salary, Department department, Insurance insurance) {
        this.id = id;
        this.firstName = firstName;
        this.lastName = lastName;
        this.hireDate = hireDate;
        this.salary = salary;
        this.department = department;
        this.insurance = insurance;
    }

    @Id
    @Column(name="ID")
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Column(name="FIRSTNAME")
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Column(name="LASTNAME")
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Column(name="HIREDATE")
    public Date getHireDate() {
        return this.hireDate;
    }

    public void setHireDate(Date hireDate) {
        this.hireDate = hireDate;
    }

    @Column(name="SALARY")
    public float getSalary() {
        return this.salary;
    }

    public void setSalary(float salary) {
        this.salary = salary;
    }

    @ManyToOne
    @JoinColumn(name="FK_DEPT")
    public Department getDepartment() {
        return this.department;
    }

    public void setDepartment(Department department) {
        this.department = department;
    }

    @ManyToOne
    @JoinColumn(name="FK_INS")
    public Insurance getInsurance() {
        return this.insurance;
    }

    public void setInsurance(Insurance insurance) {
        this.insurance = insurance;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Employee)) {
            return false;
        }
        Employee o1 = (Employee)o;
        boolean result = false;
        if (this.getId() == o1.getId() && this.getFirstName().equals(o1.getFirstName()) && this.getLastName().equals(o1.getLastName()) && this.getHireDate().equals(o1.getHireDate()) && this.getSalary() == o1.getSalary()) {
            result = true;
        }
        return result;
    }

    public int hashCode() {
        return this.getId() + this.getFirstName().hashCode() + this.getLastName().hashCode() + this.getHireDate().hashCode() + new Float(this.getSalary()).hashCode();
    }

    @Override
    public int compareTo(Employee emp) {
        int lastCmp = Integer.valueOf(this.getId()).compareTo(emp.getId());
        return lastCmp != 0 ? lastCmp : Integer.valueOf(this.getId()).compareTo(emp.getId());
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName() + "[");
        result.append("id: " + this.getId());
        result.append(", first: " + this.getFirstName());
        result.append(", last: " + this.getLastName());
        result.append(", hireDate: " + String.valueOf(this.getHireDate()));
        result.append(", salary: " + this.getSalary());
        result.append(", dept_id: " + this.getDepartment().getId());
        result.append(", ins_id: " + this.getInsurance().getId());
        result.append("]");
        return result.toString();
    }
}

