/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.spec.serverpush;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.PushBuilder;
import java.io.IOException;
import java.io.PrintWriter;

public class TestServlet7
extends HttpServlet {
    private static final String[] METHODS = new String[]{"", "POST", "PUT", "DELETE", "CONNECT", "OPTIONS", "TRACE"};

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        PrintWriter pw = resp.getWriter();
        PushBuilder pb = req.newPushBuilder();
        boolean pass = true;
        try {
            pb.push();
            pw.println("IllegalStateException should be thrown if there was no call to path(java.lang.String) on this instance between its instantiation.");
            pass = false;
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        pb = req.newPushBuilder();
        pb.path("index.html");
        pb.push();
        try {
            pb.push();
            pw.println("IllegalStateException should be thrown if there was no call to path(java.lang.String) on this instance between the last call to push() that did not throw an IllegalStateException.");
            pass = false;
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        pb = req.newPushBuilder();
        try {
            pb.method(null);
            pw.println("NullPointerException should be thrown if the argument of method() is null");
            pass = false;
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        for (String method : METHODS) {
            if (this.testMethod(pb, pw, method)) continue;
            pass = false;
        }
        if (pass) {
            pw.println("test passed");
        }
    }

    private boolean testMethod(PushBuilder pb, PrintWriter pw, String method) {
        try {
            pb.method(method);
            pw.println("IllegalArgumentException should be thrown if set method \"" + method + "\" to be used for the push");
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return true;
        }
    }
}

