/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.di.context;

import java.util.Map;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.fx.core.di.ObjectFactory;
import org.eclipse.fx.core.di.ScopedObjectFactory;
import org.eclipse.jdt.annotation.NonNull;

public class FactoryContextFunction
extends ContextFunction {
    private String factoryClass;
    private String type;
    private boolean singleton;
    public static final String SINGLETON = "org.eclipse.fx.context.singleton";

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public Object compute(IEclipseContext context, String contextKey) {
        if (this.singleton) {
            String key = "singleton_" + this.type;
            Object rv = context.get(key);
            if (rv == null) {
                ScopedObjectFactory factory = (ScopedObjectFactory)context.get(ScopedObjectFactory.class);
                @NonNull ObjectFactory f = (ObjectFactory)context.get(this.factoryClass);
                if (f != null && factory != null) {
                    rv = f.create(factory);
                    context.modify(key, rv);
                }
            }
            return rv;
        }
        ScopedObjectFactory factory = (ScopedObjectFactory)context.get(ScopedObjectFactory.class);
        @NonNull ObjectFactory f = (ObjectFactory)context.get(this.factoryClass);
        if (f != null && factory != null) {
            return f.create(factory);
        }
        return null;
    }

    public void activate(Map<String, Object> config) {
        this.type = (String)config.get("service.context.key");
        this.factoryClass = this.type + "Factory";
        this.singleton = config.get(SINGLETON) == Boolean.TRUE;
    }
}

