/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.preferences.page;

import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectExpression;
import javafx.beans.property.SimpleFloatProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import org.eclipse.fx.core.Status;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.core.log.LoggerCreator;
import org.eclipse.fx.core.observable.FXObservableUtil;
import org.eclipse.fx.ui.controls.form.NodeDecorator;
import org.eclipse.fx.ui.preferences.page.FieldEditor;

public class FloatFieldEditor
extends FieldEditor<Float> {
    private static final Logger LOGGER = LoggerCreator.createLogger(FloatFieldEditor.class);
    private final TextField textField;
    private SimpleFloatProperty value = new SimpleFloatProperty((Object)this, "value");

    public FloatFieldEditor(String name, String label) {
        super(name, label);
        this.textField = new TextField();
        this.getChildren().add((Object)this.textField);
        NodeDecorator.apply((Node)this.textField, this.statusProperty());
        FXObservableUtil.onChange((ObservableValue)this.textField.textProperty(), newValue -> {
            try {
                this.value.set(Float.parseFloat(newValue));
            }
            catch (NumberFormatException ex) {
                return;
            }
        });
    }

    public FloatFieldEditor(String name) {
        this(name, null);
    }

    @Override
    protected ObjectExpression<Status> createStatusBinding() {
        ObjectExpression<Status> parentStatus = super.createStatusBinding();
        return Bindings.createObjectBinding(() -> {
            try {
                Float.parseFloat(this.textField.getText());
                return (Status)parentStatus.get();
            }
            catch (NumberFormatException ex) {
                return Status.status((Status.State)Status.State.ERROR, (int)-1, (String)"The value must be a valid float", (Throwable)ex);
            }
        }, (Observable[])new Observable[]{parentStatus, this.textField.textProperty()});
    }

    @Override
    protected void doLoad() {
        this.textField.setText(this.getDisplayValue((float)this.getMemento().get(this.getName(), 0.0)));
    }

    @Override
    protected void doRestoreDefaults() {
        this.textField.setText(this.getDisplayValue((float)this.getMemento().getDefaultDouble(this.getName())));
    }

    protected String getDisplayValue(float floatValue) {
        return Float.toString(floatValue);
    }

    @Override
    protected void doPersist() {
        try {
            this.getMemento().put(this.getName(), (double)((Float)this.getValue().getValue()).floatValue());
        }
        catch (NumberFormatException ex) {
            LOGGER.error("An error occurred when trying to persist the float value for " + this.getName(), (Throwable)ex);
        }
    }

    protected final TextField getTextField() {
        return this.textField;
    }

    @Override
    public ObservableValue<Float> getValue() {
        return this.value.asObject();
    }
}

