/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.base.internal;

import jakarta.inject.Inject;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.fx.core.Subscription;
import org.eclipse.fx.core.text.TranslationService;
import org.eclipse.jdt.annotation.NonNull;
import org.osgi.service.component.annotations.Component;

@Component(property={"service.context.key:String=org.eclipse.fx.core.text.TranslationService"})
public class TranslationServiceContextFunction
extends ContextFunction
implements IContextFunction {
    public Object compute(IEclipseContext context, String contextKey) {
        return ContextInjectionFactory.make(TranslationServiceImpl.class, (IEclipseContext)context);
    }

    public static class TranslationServiceImpl
    implements TranslationService {
        final Map<Consumer<String>, Supplier<String>> bindings = new HashMap<Consumer<String>, Supplier<String>>();
        @Inject
        private org.eclipse.e4.core.services.translation.TranslationService translationService;
        @Inject
        private MApplicationElement element;

        public Subscription register(Consumer<String> consumer, String key, Object ... arguments) {
            Supplier<String> supplier = () -> {
                String rv = this.translate(key);
                if (arguments.length > 0) {
                    rv = MessageFormat.format(rv, arguments);
                }
                return rv;
            };
            this.bindings.put(consumer, supplier);
            return () -> {
                Supplier<String> supplier = this.bindings.remove(consumer);
            };
        }

        public void updateBindings() {
            for (Map.Entry<Consumer<String>, Supplier<String>> next : this.bindings.entrySet()) {
                next.getKey().accept(next.getValue().get());
            }
        }

        public @NonNull String translate(@NonNull String key) {
            return this.translationService.translate("%" + key, this.element.getContributorURI());
        }
    }
}

