/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.bdd.conversion;

import com.github.javabdd.BDD;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.bdd.spec.CifBddDiscVariable;
import org.eclipse.escet.cif.bdd.spec.CifBddDomain;
import org.eclipse.escet.cif.bdd.spec.CifBddInputVariable;
import org.eclipse.escet.cif.bdd.spec.CifBddLocPtrVariable;
import org.eclipse.escet.cif.bdd.spec.CifBddSpec;
import org.eclipse.escet.cif.bdd.spec.CifBddTypedVariable;
import org.eclipse.escet.cif.bdd.spec.CifBddVariable;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumLiteral;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryOperator;
import org.eclipse.escet.cif.metamodel.cif.expressions.BoolExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EnumLiteralExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.InputVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IntExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.LocationExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryOperator;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.cif.typechecker.CifExprsTypeChecker;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;

public class BddToCif {
    private BddToCif() {
    }

    public static Expression bddToCifPred(BDD bdd, CifBddSpec cifBddSpec) {
        Expression predDnf = BddToCif.bddToCifPred(bdd, cifBddSpec, true);
        Expression predCnf = BddToCif.bddToCifPred(bdd, cifBddSpec, false);
        int sizeDnf = BddToCif.exprNodeSize(predDnf);
        int sizeCnf = BddToCif.exprNodeSize(predCnf);
        return sizeCnf <= sizeDnf ? predCnf : predDnf;
    }

    public static Expression bddToCifPred(BDD bdd, CifBddSpec cifBddSpec, boolean dnf) {
        if (bdd.isZero()) {
            return CifValueUtils.makeFalse();
        }
        if (bdd.isOne()) {
            return CifValueUtils.makeTrue();
        }
        byte[] valuation = new byte[cifBddSpec.factory.varNum()];
        Arrays.fill(valuation, (byte)-1);
        List paths = Lists.list();
        BddToCif.bddToCifPred(bdd, cifBddSpec, valuation, paths, dnf);
        Expression rslt = dnf ? CifValueUtils.createDisjunction((List)paths) : CifValueUtils.createConjunction((List)paths);
        return rslt;
    }

    private static void bddToCifPred(BDD bdd, CifBddSpec cifBddSpec, byte[] valuation, List<Expression> paths, boolean dnf) {
        if (bdd.isZero() && dnf) {
            return;
        }
        if (bdd.isOne() && !dnf) {
            return;
        }
        if (bdd.isZero() || bdd.isOne()) {
            List parts = Lists.list();
            CifBddVariable[] cifBddVariableArray = cifBddSpec.variables;
            int n = cifBddSpec.variables.length;
            int n2 = 0;
            while (n2 < n) {
                CifBddVariable var = cifBddVariableArray[n2];
                CifBddDomain domain = var.domain;
                byte[] domainValuation = new byte[domain.getVarCount()];
                int[] varIdxs = domain.getVarIndices();
                int i = 0;
                while (i < varIdxs.length) {
                    int varIdx = varIdxs[i];
                    domainValuation[i] = valuation[varIdx];
                    ++i;
                }
                Expression pred = BddToCif.valuationToCif(var, domainValuation, dnf);
                parts.add(pred);
                ++n2;
            }
            Expression path = dnf ? CifValueUtils.createConjunction((List)parts) : CifValueUtils.createDisjunction((List)parts);
            paths.add(path);
        } else {
            int varIdx = bdd.var();
            valuation[varIdx] = 0;
            BDD lowBdd = bdd.low();
            BddToCif.bddToCifPred(lowBdd, cifBddSpec, valuation, paths, dnf);
            lowBdd.free();
            valuation[varIdx] = 1;
            BDD highBdd = bdd.high();
            BddToCif.bddToCifPred(highBdd, cifBddSpec, valuation, paths, dnf);
            highBdd.free();
            valuation[varIdx] = -1;
        }
    }

    static Expression valuationToCif(CifBddVariable var, byte[] valuation, boolean dnf) {
        boolean[] values = new boolean[var.count];
        if (!dnf) {
            Arrays.fill(values, true);
        }
        BddToCif.valuationToValues(valuation, 0, 0, values, var.lower, var.upper, dnf);
        return BddToCif.valuesToCif(var, values);
    }

    static void valuationToValues(byte[] valuation, int offset, int value, boolean[] values, int min, int max, boolean dnf) {
        if (offset == valuation.length) {
            if (value >= min && value <= max) {
                values[value - min] = dnf;
            }
            return;
        }
        if (valuation[offset] == 0 || valuation[offset] == -1) {
            BddToCif.valuationToValues(valuation, offset + 1, value, values, min, max, dnf);
        }
        if (valuation[offset] == 1 || valuation[offset] == -1) {
            value = min < 0 && offset == valuation.length - 1 ? (value -= 1 << offset) : (value += 1 << offset);
            BddToCif.valuationToValues(valuation, offset + 1, value, values, min, max, dnf);
        }
    }

    static Expression valuesToCif(CifBddVariable var, boolean[] possibles) {
        CifType type;
        int possibleCnt = 0;
        int impossibleCnt = 0;
        boolean[] blArray = possibles;
        int n = possibles.length;
        int n2 = 0;
        while (n2 < n) {
            boolean possible = blArray[n2];
            if (possible) {
                ++possibleCnt;
            } else {
                ++impossibleCnt;
            }
            ++n2;
        }
        if (possibleCnt == possibles.length) {
            return CifValueUtils.makeTrue();
        }
        if (impossibleCnt == possibles.length) {
            return CifValueUtils.makeFalse();
        }
        if (possibleCnt == 1) {
            int trueIdx = ArrayUtils.indexOf((boolean[])possibles, (boolean)true);
            return BddToCif.createVarPred(var, trueIdx, BinaryOperator.EQUAL, true);
        }
        if (impossibleCnt == 1) {
            int falseIdx = ArrayUtils.indexOf((boolean[])possibles, (boolean)false);
            return BddToCif.createVarPred(var, falseIdx, BinaryOperator.UNEQUAL, true);
        }
        if (var instanceof CifBddTypedVariable) {
            CifBddTypedVariable typedVar = (CifBddTypedVariable)var;
            v0 = typedVar.type;
        } else {
            v0 = type = null;
        }
        if (type instanceof IntType) {
            boolean[] bits = possibles;
            List values = Lists.list();
            List indices = Lists.list();
            List counts = Lists.list();
            int i = 0;
            while (i < bits.length) {
                if (!values.isEmpty() && ((Boolean)Lists.last((List)values)).equals(bits[i])) {
                    counts.set(counts.size() - 1, (Integer)Lists.last((List)counts) + 1);
                } else {
                    values.add(bits[i]);
                    indices.add(i);
                    counts.add(1);
                }
                ++i;
            }
            int score0 = 1;
            int score1 = 0;
            int i2 = 0;
            while (i2 < values.size()) {
                int count = (Integer)counts.get(i2);
                if (((Boolean)values.get(i2)).booleanValue()) {
                    score1 += count == 1 ? 1 : 2;
                } else {
                    score0 += count == 1 ? 1 : 2;
                }
                ++i2;
            }
            boolean chosenValue = score1 <= score0;
            List rslts = Lists.list();
            int i3 = 0;
            while (i3 < values.size()) {
                if (((Boolean)values.get(i3)).equals(chosenValue)) {
                    if ((Integer)counts.get(i3) == 1) {
                        rslts.add(BddToCif.createVarPred(var, (Integer)indices.get(i3), BinaryOperator.EQUAL, true));
                    } else if ((Integer)counts.get(i3) == 2) {
                        rslts.add(BddToCif.createVarPred(var, (Integer)indices.get(i3), BinaryOperator.EQUAL, true));
                        rslts.add(BddToCif.createVarPred(var, (Integer)indices.get(i3) + 1, BinaryOperator.EQUAL, true));
                    } else {
                        Expression p1 = BddToCif.createVarPred(var, (Integer)indices.get(i3), BinaryOperator.LESS_EQUAL, false);
                        Expression p2 = BddToCif.createVarPred(var, (Integer)indices.get(i3) + (Integer)counts.get(i3) - 1, BinaryOperator.LESS_EQUAL, true);
                        rslts.add(CifValueUtils.createConjunction((List)Lists.list((Object[])new Expression[]{p1, p2})));
                    }
                }
                ++i3;
            }
            Expression rslt = CifValueUtils.createDisjunction((List)rslts);
            if (!chosenValue) {
                rslt = CifValueUtils.makeInverse((Expression)rslt);
            }
            return rslt;
        }
        if (type == null || type instanceof EnumType) {
            boolean[] bits = possibles;
            int count0 = 0;
            int count1 = 0;
            int i = 0;
            while (i < bits.length) {
                if (bits[i]) {
                    ++count1;
                } else {
                    ++count0;
                }
                ++i;
            }
            boolean chosenValue = count1 <= count0;
            BinaryOperator op = chosenValue ? BinaryOperator.EQUAL : BinaryOperator.UNEQUAL;
            List rslts = Lists.list();
            int i4 = 0;
            while (i4 < bits.length) {
                if (!bits[i4] != chosenValue) {
                    rslts.add(BddToCif.createVarPred(var, i4, op, true));
                }
                ++i4;
            }
            return chosenValue ? CifValueUtils.createDisjunction((List)rslts) : CifValueUtils.createConjunction((List)rslts);
        }
        throw new RuntimeException("Unexpected var type: " + String.valueOf(type));
    }

    static Expression createVarPred(CifBddVariable var, int valueIdx, BinaryOperator op, boolean varLeft) {
        Expression valueExpr;
        Assert.check((valueIdx >= 0 ? 1 : 0) != 0);
        Assert.check((valueIdx < var.count ? 1 : 0) != 0);
        if (var instanceof CifBddLocPtrVariable) {
            CifBddLocPtrVariable lpVar = (CifBddLocPtrVariable)var;
            Assert.check((op == BinaryOperator.EQUAL || op == BinaryOperator.UNEQUAL ? 1 : 0) != 0);
            Location loc = (Location)lpVar.aut.getLocations().get(valueIdx);
            LocationExpression locRef = CifConstructors.newLocationExpression();
            locRef.setLocation(loc);
            locRef.setType((CifType)CifConstructors.newBoolType());
            LocationExpression rslt = locRef;
            if (op == BinaryOperator.UNEQUAL) {
                rslt = CifValueUtils.makeInverse((Expression)rslt);
            }
            return rslt;
        }
        CifBddTypedVariable typedVar = (CifBddTypedVariable)var;
        Expression varRef = BddToCif.createVarRef(typedVar);
        if (typedVar.type instanceof BoolType) {
            Assert.check((op == BinaryOperator.EQUAL || op == BinaryOperator.UNEQUAL ? 1 : 0) != 0);
            if (op == BinaryOperator.UNEQUAL) {
                valueIdx = 1 - valueIdx;
            }
            if (valueIdx == 1) {
                return varRef;
            }
            return CifValueUtils.makeInverse((Expression)varRef);
        }
        if (typedVar.type instanceof IntType) {
            int value = var.lower + valueIdx;
            valueExpr = CifValueUtils.makeInt((int)value);
        } else if (typedVar.type instanceof EnumType) {
            EnumType enumType = (EnumType)typedVar.type;
            EnumDecl enumDecl = enumType.getEnum();
            EnumLiteral lit = (EnumLiteral)enumDecl.getLiterals().get(valueIdx);
            EnumLiteralExpression litRef = CifConstructors.newEnumLiteralExpression();
            litRef.setLiteral(lit);
            litRef.setType((CifType)EMFHelper.deepclone((EObject)typedVar.type));
            valueExpr = litRef;
        } else {
            throw new RuntimeException("Unexpected var type: " + String.valueOf(typedVar.type));
        }
        BinaryExpression bin = CifConstructors.newBinaryExpression();
        bin.setOperator(op);
        bin.setLeft(varLeft ? varRef : valueExpr);
        bin.setRight(varLeft ? valueExpr : varRef);
        bin.setType((CifType)CifConstructors.newBoolType());
        return bin;
    }

    private static Expression createVarRef(CifBddVariable var) {
        Assert.check((boolean)(var instanceof CifBddTypedVariable));
        if (var instanceof CifBddDiscVariable) {
            CifBddDiscVariable discVar = (CifBddDiscVariable)var;
            DiscVariableExpression discVarRef = CifConstructors.newDiscVariableExpression();
            discVarRef.setVariable(discVar.var);
            discVarRef.setType((CifType)EMFHelper.deepclone((EObject)discVar.type));
            return discVarRef;
        }
        if (var instanceof CifBddInputVariable) {
            CifBddInputVariable inputVar = (CifBddInputVariable)var;
            InputVariableExpression inputVarRef = CifConstructors.newInputVariableExpression();
            inputVarRef.setVariable(inputVar.var);
            inputVarRef.setType((CifType)EMFHelper.deepclone((EObject)inputVar.type));
            return inputVarRef;
        }
        throw new RuntimeException("Unknown typed var: " + String.valueOf(var));
    }

    static int exprNodeSize(Expression expr) {
        if (expr instanceof BinaryExpression) {
            BinaryExpression binExpr = (BinaryExpression)expr;
            Expression left = binExpr.getLeft();
            Expression right = binExpr.getRight();
            return 1 + BddToCif.exprNodeSize(left) + BddToCif.exprNodeSize(right);
        }
        if (expr instanceof UnaryExpression) {
            UnaryExpression unExpr = (UnaryExpression)expr;
            int extraCount = unExpr.getOperator() == UnaryOperator.NEGATE ? 0 : 1;
            return extraCount + BddToCif.exprNodeSize(unExpr.getChild());
        }
        if (expr instanceof BoolExpression) {
            return 1;
        }
        if (expr instanceof IntExpression) {
            return 1;
        }
        if (expr instanceof DiscVariableExpression) {
            return 1;
        }
        if (expr instanceof InputVariableExpression) {
            return 1;
        }
        if (expr instanceof EnumLiteralExpression) {
            return 1;
        }
        if (expr instanceof LocationExpression) {
            return 1;
        }
        throw new RuntimeException("Unexpected expr: " + String.valueOf(expr));
    }

    public static Expression getBddVarPred(CifBddVariable var, int bitIdx) {
        CifType type;
        if (var instanceof CifBddTypedVariable) {
            CifBddTypedVariable typedVar = (CifBddTypedVariable)var;
            v0 = typedVar.type;
        } else {
            v0 = type = null;
        }
        if (type == null) {
            CifBddLocPtrVariable cifBddLpVar = (CifBddLocPtrVariable)var;
            EList locs = cifBddLpVar.aut.getLocations();
            List locRefs = Lists.list();
            int mask = 1 << bitIdx;
            int i = 0;
            while (i < locs.size()) {
                if ((i & mask) != 0) {
                    LocationExpression locRef = CifConstructors.newLocationExpression();
                    locRef.setLocation((Location)locs.get(i));
                    locRef.setType((CifType)CifConstructors.newBoolType());
                    locRefs.add(locRef);
                }
                ++i;
            }
            return CifValueUtils.createDisjunction((List)locRefs);
        }
        if (type instanceof BoolType) {
            Assert.check((bitIdx == 0 ? 1 : 0) != 0);
            return BddToCif.createVarRef(var);
        }
        if (type instanceof IntType) {
            Expression valueExpr;
            IntType intType = (IntType)type;
            if (var.lower < 0 && bitIdx == var.getBddVarCount() - 1) {
                BinaryExpression ltExpr = CifConstructors.newBinaryExpression();
                ltExpr.setOperator(BinaryOperator.LESS_THAN);
                ltExpr.setLeft(BddToCif.createVarRef(var));
                ltExpr.setRight(CifValueUtils.makeInt((int)0));
                ltExpr.setType((CifType)CifConstructors.newBoolType());
                return ltExpr;
            }
            int mask = 1 << bitIdx;
            Assert.notNull((Object)intType.getLower());
            Assert.notNull((Object)intType.getUpper());
            if (var.lower < 0) {
                BinaryExpression guardExpr = CifConstructors.newBinaryExpression();
                guardExpr.setOperator(BinaryOperator.LESS_THAN);
                guardExpr.setLeft(BddToCif.createVarRef(var));
                guardExpr.setRight(CifValueUtils.makeInt((int)0));
                guardExpr.setType((CifType)CifConstructors.newBoolType());
                int n = var.getBddDomainSize().intValueExact();
                BinaryExpression thenExpr = CifConstructors.newBinaryExpression();
                thenExpr.setOperator(BinaryOperator.ADDITION);
                thenExpr.setLeft(BddToCif.createVarRef(var));
                thenExpr.setRight(CifValueUtils.makeInt((int)n));
                thenExpr.setType((CifType)CifConstructors.newIntType((Integer)(intType.getLower() + n), null, (Integer)(intType.getUpper() + n)));
                Expression elseExpr = BddToCif.createVarRef(var);
                IntType ifType = CifConstructors.newIntType((Integer)intType.getLower(), null, (Integer)(intType.getUpper() + n));
                valueExpr = CifConstructors.newIfExpression(null, (Expression)elseExpr, List.of(guardExpr), null, (Expression)thenExpr, (CifType)ifType);
            } else {
                valueExpr = BddToCif.createVarRef(var);
            }
            BinaryExpression divExpr = CifConstructors.newBinaryExpression();
            divExpr.setOperator(BinaryOperator.INTEGER_DIVISION);
            divExpr.setLeft(valueExpr);
            divExpr.setRight(CifValueUtils.makeInt((int)mask));
            int[] bounds = CifExprsTypeChecker.getDivResultRange((int)intType.getLower(), (int)intType.getUpper(), (int)mask, (int)mask);
            divExpr.setType((CifType)CifConstructors.newIntType((Integer)bounds[0], null, (Integer)bounds[1]));
            BinaryExpression modExpr = CifConstructors.newBinaryExpression();
            modExpr.setOperator(BinaryOperator.MODULUS);
            modExpr.setLeft((Expression)divExpr);
            modExpr.setRight(CifValueUtils.makeInt((int)2));
            modExpr.setType((CifType)CifConstructors.newIntType((Integer)-1, null, (Integer)1));
            BinaryExpression gtExpr = CifConstructors.newBinaryExpression();
            gtExpr.setOperator(BinaryOperator.GREATER_THAN);
            gtExpr.setLeft((Expression)modExpr);
            gtExpr.setRight(CifValueUtils.makeInt((int)0));
            gtExpr.setType((CifType)CifConstructors.newBoolType());
            return gtExpr;
        }
        if (type instanceof EnumType) {
            EnumType enumType = (EnumType)type;
            EnumDecl enumDecl = enumType.getEnum();
            EList literals = enumDecl.getLiterals();
            List valuePreds = Lists.list();
            int mask = 1 << bitIdx;
            int i = 0;
            while (i < literals.size()) {
                if ((i & mask) != 0) {
                    Expression varRef = BddToCif.createVarRef(var);
                    EnumLiteralExpression litRef = CifConstructors.newEnumLiteralExpression();
                    litRef.setLiteral((EnumLiteral)literals.get(i));
                    litRef.setType((CifType)CifConstructors.newEnumType((EnumDecl)enumDecl, null));
                    BinaryExpression bexpr = CifConstructors.newBinaryExpression();
                    bexpr.setLeft(varRef);
                    bexpr.setRight((Expression)litRef);
                    bexpr.setOperator(BinaryOperator.EQUAL);
                    bexpr.setType((CifType)CifConstructors.newBoolType());
                    valuePreds.add(bexpr);
                }
                ++i;
            }
            return CifValueUtils.createDisjunction((List)valuePreds);
        }
        throw new RuntimeException("Unexpected type: " + String.valueOf(type));
    }
}

