/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.simulator;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.escet.chi.codegen.CodeGeneratorContext;
import org.eclipse.escet.chi.codegen.JavaCodeGenerator;
import org.eclipse.escet.chi.codegen.java.JavaFile;
import org.eclipse.escet.chi.metamodel.chi.Declaration;
import org.eclipse.escet.chi.metamodel.chi.Specification;
import org.eclipse.escet.chi.parser.ChiParser;
import org.eclipse.escet.chi.runtime.ChiCoordinator;
import org.eclipse.escet.chi.runtime.ChiSimulatorException;
import org.eclipse.escet.chi.runtime.ChiSpecification;
import org.eclipse.escet.chi.runtime.SimulationResult;
import org.eclipse.escet.chi.runtime.data.BaseProcess;
import org.eclipse.escet.chi.simulator.options.InputFileOption;
import org.eclipse.escet.chi.simulator.options.OutputDirectoryOption;
import org.eclipse.escet.chi.simulator.options.OutputInfoOption;
import org.eclipse.escet.chi.simulator.options.PerformJavaCompileOption;
import org.eclipse.escet.chi.simulator.options.RunSpecificationClassOption;
import org.eclipse.escet.chi.simulator.options.SeedValueOption;
import org.eclipse.escet.chi.simulator.options.StartupInstanceOption;
import org.eclipse.escet.chi.simulator.options.WriteEMFOption;
import org.eclipse.escet.chi.simulator.options.WriteJAROption;
import org.eclipse.escet.chi.typecheck.ChiTypeChecker;
import org.eclipse.escet.common.app.framework.Application;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.io.AppStreams;
import org.eclipse.escet.common.app.framework.javacompiler.InMemoryJarClassLoader;
import org.eclipse.escet.common.app.framework.javacompiler.JavaCharSeqInputFileObject;
import org.eclipse.escet.common.app.framework.javacompiler.JavaCompilerOption;
import org.eclipse.escet.common.app.framework.javacompiler.RuntimeJavaCompiler;
import org.eclipse.escet.common.app.framework.javacompiler.RuntimeJavaCompilerException;
import org.eclipse.escet.common.app.framework.options.OptionCategory;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.output.OutputComponentBase;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InputOutputException;
import org.eclipse.escet.common.java.exceptions.InvalidInputException;
import org.eclipse.escet.common.java.exceptions.InvalidModelException;
import org.eclipse.escet.common.typechecker.SemanticProblem;
import org.eclipse.escet.common.typechecker.SemanticProblemSeverity;
import org.eclipse.escet.setext.runtime.DebugMode;
import org.eclipse.escet.setext.runtime.SyntaxWarning;

public class SimulatorApplication
extends Application<OutputComponentBase> {
    public static void main(String[] args) {
        SimulatorApplication app = new SimulatorApplication();
        app.run(args, true);
    }

    public SimulatorApplication() {
    }

    public SimulatorApplication(AppStreams streams) {
        super(streams);
    }

    protected OutputProvider<OutputComponentBase> createProvider() {
        return new OutputProvider();
    }

    private List<Declaration> parseChiFile(String inFile) {
        ChiParser parser = new ChiParser();
        List decls = (List)parser.parseFile(inFile, DebugMode.NONE);
        for (SyntaxWarning warning : parser.getWarnings()) {
            OutputProvider.warn((String)warning.toString());
        }
        return decls;
    }

    private Specification typecheckChiFile(String emfName, List<Declaration> decls) {
        ChiTypeChecker tpc = new ChiTypeChecker(emfName);
        Specification spec = (Specification)tpc.typeCheck(decls);
        boolean hasWarnings = false;
        boolean hasErrors = false;
        for (SemanticProblem sp : tpc.getProblems()) {
            if (sp.severity == SemanticProblemSeverity.ERROR) {
                OutputProvider.out((String)("Error: " + sp.toString()));
                hasErrors = true;
                continue;
            }
            if (sp.severity != SemanticProblemSeverity.WARNING) continue;
            hasWarnings = true;
        }
        if (hasWarnings && !hasErrors) {
            for (SemanticProblem sp : tpc.getProblems()) {
                if (sp.severity != SemanticProblemSeverity.WARNING) continue;
                OutputProvider.out((String)("Warning: " + sp.toString()));
            }
        }
        return spec;
    }

    private static void ensureDirectory(String dirPath) {
        File thePath = new File(dirPath);
        if (!thePath.exists()) {
            thePath.mkdirs();
            return;
        }
        if (!thePath.isDirectory()) {
            throw new InvalidInputException("\"" + dirPath + "\" is not a directory.");
        }
    }

    private void writeJavaFiles(String dirPath, CodeGeneratorContext ctxt) {
        for (JavaFile jc : ctxt.files) {
            PrintWriter output;
            String filePath = Paths.resolve((String)(dirPath + "/" + jc.getClassName() + ".java"));
            try {
                FileWriter w = new FileWriter(filePath);
                output = new PrintWriter(w);
            }
            catch (IOException e) {
                String msg = Strings.fmt((String)"Saving of file \"%s\" failed.", (Object[])new Object[]{filePath});
                throw new InputOutputException(msg, (Throwable)e);
            }
            for (String line : jc.toBox().getLines()) {
                output.printf("%s\n", line);
            }
            output.close();
        }
    }

    private RuntimeJavaCompiler compileJavaCode(CodeGeneratorContext ctxt) {
        String name = JavaCompilerOption.getCompilerName();
        ClassLoader classLoader = SimulatorApplication.class.getClassLoader();
        RuntimeJavaCompiler compiler = new RuntimeJavaCompiler(name, classLoader);
        Map sources = Maps.map();
        for (JavaFile cls : ctxt.files) {
            JavaCharSeqInputFileObject jif = new JavaCharSeqInputFileObject(cls.getFQclassname(), (CharSequence)cls.toBox().toString());
            sources.put(cls.getFQclassname(), jif);
        }
        try {
            compiler.compile(sources);
        }
        catch (RuntimeJavaCompilerException e) {
            throw new RuntimeException("Chi compilation failed.", e);
        }
        return compiler;
    }

    private ChiSpecification instantiateMainClass(Class<? extends ChiSpecification> mainClass, ChiCoordinator chiCoordinator) {
        ChiSpecification cspec;
        Constructor<? extends ChiSpecification> c;
        Class[] typeParm = new Class[]{ChiCoordinator.class};
        Object[] parm = new Object[]{chiCoordinator};
        String constructError = "Cannot get constructor of main class.";
        try {
            c = mainClass.getConstructor(typeParm);
        }
        catch (SecurityException e) {
            throw new ChiSimulatorException("Cannot get constructor of main class.", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new ChiSimulatorException("Cannot get constructor of main class.", (Throwable)e);
        }
        String createError = "Cannot instantiate main class.";
        try {
            cspec = c.newInstance(parm);
        }
        catch (IllegalArgumentException e) {
            throw new ChiSimulatorException("Cannot instantiate main class.", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new ChiSimulatorException("Cannot instantiate main class.", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ChiSimulatorException("Cannot instantiate main class.", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ChiSimulatorException("Cannot instantiate main class.", (Throwable)e);
        }
        return cspec;
    }

    private CodeGeneratorContext generateJavaCode(String inFile) {
        Specification spec;
        List<Declaration> decls = this.parseChiFile(inFile);
        String emfBase = null;
        if (WriteEMFOption.getWriteEMF()) {
            emfBase = Paths.pathChangeExtension((String)inFile, (String)"chi", null);
        }
        if ((spec = this.typecheckChiFile(emfBase, decls)) == null) {
            return null;
        }
        CodeGeneratorContext ctxt = JavaCodeGenerator.transCodeGen((String)inFile, (Specification)spec);
        String dirPath = OutputDirectoryOption.getPath();
        if (dirPath != null && !dirPath.isEmpty()) {
            dirPath = Paths.resolve((String)dirPath);
            SimulatorApplication.ensureDirectory(dirPath);
            this.writeJavaFiles(dirPath, ctxt);
        }
        return ctxt;
    }

    protected int runInternal() {
        String inFile = InputFileOption.getPath();
        Class mainClass = null;
        if (inFile != null && Paths.pathHasExtension((String)inFile, (String)"chi")) {
            CodeGeneratorContext ctxt = this.generateJavaCode(inFile);
            if (ctxt == null) {
                return 1;
            }
            if (!PerformJavaCompileOption.getPerformCompilation()) {
                return 0;
            }
            RuntimeJavaCompiler compiler = this.compileJavaCode(ctxt);
            if (WriteJAROption.getWriteJAR()) {
                String jarPath = Paths.pathChangeExtension((String)inFile, (String)"chi", (String)"cchi");
                compiler.writeJarFile(Paths.resolve((String)jarPath), ctxt.specName, null);
                return 0;
            }
            mainClass = compiler.loadClass(ctxt.specName);
        }
        String specClassname = RunSpecificationClassOption.getPath();
        if (mainClass == null && inFile == null && specClassname != null) {
            if (Platform.isRunning()) {
                String msg = "Specification application should be run as stand-alone plain Java application. That is, outside the JVM running Eclipse, and also not using command line releases. Use for example a Java Application launch configuration.";
                throw new ChiSimulatorException(msg);
            }
            try {
                Class cls;
                ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
                mainClass = cls = loader.loadClass(specClassname);
            }
            catch (ClassNotFoundException e) {
                String msg = "Could not load class \"" + specClassname + "\".";
                throw new ChiSimulatorException(msg, (Throwable)e);
            }
        }
        InMemoryJarClassLoader jarClassLoader = null;
        if (mainClass == null && inFile != null && Paths.pathHasExtension((String)inFile, (String)"cchi")) {
            jarClassLoader = new InMemoryJarClassLoader(inFile, ((Object)((Object)this)).getClass().getClassLoader());
            String mainName = jarClassLoader.getMainClassName();
            mainClass = jarClassLoader.loadClassByName(mainName);
        }
        if (mainClass == null) {
            String msg = "Missing input file to run, either provide a .chi or .cchi input file, or a specification class with --run-specification-class.";
            throw new ChiSimulatorException(msg);
        }
        try {
            BaseProcess model;
            long seed = SeedValueOption.getSeedValue();
            boolean seedProvided = seed != 0L;
            ChiCoordinator coord = new ChiCoordinator((Application)this, seed, seedProvided);
            ChiSpecification cspec = this.instantiateMainClass(mainClass, coord);
            String instanceText = StartupInstanceOption.getStartupInstanceText();
            if (instanceText == null) {
                instanceText = cspec.findDefaultStartupInstance();
            }
            if (instanceText == null) {
                String msg = "No model or xper instance text provided, and no unique parameter-less model or xper definition available.";
                throw new InvalidModelException(msg);
            }
            try {
                model = cspec.startStartup(coord, instanceText);
            }
            catch (ChiSimulatorException e) {
                String msg = "Instance text '" + instanceText + "' could not be matched with a model or an experiment definition, please change the instance text or the file.";
                throw new InvalidModelException(msg, (Throwable)e);
            }
            SimulationResult simResult = coord.run(model);
            if (OutputInfoOption.getOutputInfo()) {
                OutputProvider.out((String)simResult.getInfo(seedProvided));
            }
            return 0;
        }
        finally {
            if (jarClassLoader != null) {
                try {
                    jarClassLoader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String getAppName() {
        return "Chi simulator";
    }

    public String getAppDescription() {
        return "Chi simulator";
    }

    private OptionCategory getSimulatorOptionsPage() {
        List subPages = Lists.list();
        List options = Lists.list();
        options.add(Options.getInstance(InputFileOption.class));
        options.add(Options.getInstance(StartupInstanceOption.class));
        options.add(Options.getInstance(SeedValueOption.class));
        options.add(Options.getInstance(OutputInfoOption.class));
        return new OptionCategory("Simulator", "Chi Simulator Options.", subPages, options);
    }

    private OptionCategory getCompilerOptionsPage() {
        List subPages = Lists.list();
        List options = Lists.list();
        options.add(Options.getInstance(WriteEMFOption.class));
        options.add(Options.getInstance(OutputDirectoryOption.class));
        options.add(Options.getInstance(PerformJavaCompileOption.class));
        options.add(Options.getInstance(WriteJAROption.class));
        options.add(Options.getInstance(JavaCompilerOption.class));
        return new OptionCategory("Compiler", "Chi Compiler Options.", subPages, options);
    }

    private OptionCategory getAdvancedOptionsPage() {
        List subPages = Lists.list();
        List options = Lists.list();
        options.add(Options.getInstance(RunSpecificationClassOption.class));
        return new OptionCategory("Advanced", "Chi Advanced Options.", subPages, options);
    }

    protected OptionCategory getAllOptions() {
        List subPages = Lists.list();
        subPages.add(this.getSimulatorOptionsPage());
        subPages.add(SimulatorApplication.getGeneralOptionCategory());
        subPages.add(this.getCompilerOptionsPage());
        subPages.add(this.getAdvancedOptionsPage());
        List options = Lists.list();
        return new OptionCategory("Chi Simulator Options", "All options for the Chi simulator.", subPages, options);
    }
}

