package org.mandas.docker.client.messages.swarm;

import java.util.Objects;

/**
 * Immutable implementation of {@link GlobalService}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableGlobalService.builder()}.
 */
@SuppressWarnings({"all"})
final class ImmutableGlobalService implements GlobalService {

  private ImmutableGlobalService(ImmutableGlobalService.Builder builder) {
  }

  /**
   * This instance is equal to all instances of {@code ImmutableGlobalService} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableGlobalService
        && equalTo(0, (ImmutableGlobalService) another);
  }

  @SuppressWarnings("MethodCanBeStatic")
  private boolean equalTo(int synthetic, ImmutableGlobalService another) {
    return true;
  }

  /**
   * Returns a constant hash code value.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return 1914716950;
  }

  /**
   * Prints the immutable value {@code GlobalService}.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GlobalService{}";
  }

  /**
   * Creates an immutable copy of a {@link GlobalService} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable GlobalService instance
   */
  public static ImmutableGlobalService copyOf(GlobalService instance) {
    if (instance instanceof ImmutableGlobalService) {
      return (ImmutableGlobalService) instance;
    }
    return ImmutableGlobalService.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableGlobalService ImmutableGlobalService}.
   * <pre>
   * ImmutableGlobalService.builder()
   *    .build();
   * </pre>
   * @return A new ImmutableGlobalService builder
   */
  public static ImmutableGlobalService.Builder builder() {
    return new ImmutableGlobalService.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableGlobalService ImmutableGlobalService}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  static final class Builder implements GlobalService.Builder {

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GlobalService} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GlobalService instance) {
      Objects.requireNonNull(instance, "instance");
      return this;
    }

    /**
     * Builds a new {@link ImmutableGlobalService ImmutableGlobalService}.
     * @return An immutable instance of GlobalService
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableGlobalService build() {
      return new ImmutableGlobalService(this);
    }
  }
}
