/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.preferences;

import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.linuxtools.docker.core.Messages;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.core.DockerMachine;
import org.eclipse.linuxtools.internal.docker.ui.preferences.PreferenceMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class DockerMachinePreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private DirectoryFieldEditor dockerMachineInstallDir;
    private DirectoryFieldEditor vmDriverInstallDir;

    public DockerMachinePreferencePage() {
        super(1);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription(PreferenceMessages.getString("DockerMachine.message"));
    }

    public void init(IWorkbench workbench) {
    }

    protected void createFieldEditors() {
        this.dockerMachineInstallDir = new CustomDirectoryFieldEditor("dockerMachineInstallDir", PreferenceMessages.getString("DockerMachinePath.label"), this.getFieldEditorParent()){

            protected boolean checkState() {
                if (this.isEmptyStringAllowed() && !this.getStringValue().isEmpty()) {
                    boolean validPath = super.checkState();
                    if (!validPath) {
                        return false;
                    }
                    if (!DockerMachine.getInstance().checkPathToDockerMachine(this.getStringValue())) {
                        DockerMachinePreferencePage.this.setWarningMessage(NLS.bind((String)Messages.Docker_Machine_Command_Not_Found, (Object)this.getStringValue()));
                        return true;
                    }
                }
                DockerMachinePreferencePage.this.setMessage(null);
                return true;
            }
        };
        this.addField((FieldEditor)this.dockerMachineInstallDir);
        this.dockerMachineInstallDir.setPreferenceStore(this.getPreferenceStore());
        this.dockerMachineInstallDir.setEmptyStringAllowed(true);
        this.dockerMachineInstallDir.setValidateStrategy(0);
        this.dockerMachineInstallDir.setPage((DialogPage)this);
        this.dockerMachineInstallDir.setErrorMessage(PreferenceMessages.getString("DockerMachinePath.invalid.label"));
        this.dockerMachineInstallDir.showErrorMessage();
        this.dockerMachineInstallDir.load();
        this.vmDriverInstallDir = new CustomDirectoryFieldEditor("vmDriverInstallDir", PreferenceMessages.getString("VMDriverPath.label"), this.getFieldEditorParent());
        this.addField((FieldEditor)this.vmDriverInstallDir);
        this.vmDriverInstallDir.setPreferenceStore(this.getPreferenceStore());
        this.vmDriverInstallDir.setPage((DialogPage)this);
        this.vmDriverInstallDir.setEmptyStringAllowed(true);
        this.vmDriverInstallDir.setErrorMessage(PreferenceMessages.getString("VMDriverPath.invalid.label"));
        this.vmDriverInstallDir.showErrorMessage();
        this.vmDriverInstallDir.setValidateStrategy(0);
        this.vmDriverInstallDir.load();
    }

    private void setWarningMessage(String message) {
        super.setMessage(message, 2);
    }

    private static class CustomDirectoryFieldEditor
    extends DirectoryFieldEditor {
        public CustomDirectoryFieldEditor(String name, String labelText, Composite parent) {
            this.init(name, labelText);
            this.setErrorMessage(JFaceResources.getString((String)"DirectoryFieldEditor.errorMessage"));
            this.setChangeButtonText(JFaceResources.getString((String)"openBrowse"));
            this.setValidateStrategy(0);
            this.createControl(parent);
        }
    }
}

