/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.resource_throughput.ui.editors;

import activity.Move;
import activity.PeripheralAction;
import activity.SimpleAction;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.EventObject;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.stream.Collectors;
import machine.Axis;
import machine.HasResourcePeripheral;
import machine.Peripheral;
import machine.PeripheralType;
import machine.SetPoint;
import machine.impl.MachineQueries;
import machine.provider.MachineItemProviderAdapterFactory;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.ViewerPane;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.lsat.common.emf.common.ui.AbstractEMFMultiPageEditorPart;
import org.eclipse.lsat.common.emf.common.ui.TableContentOutlinePage;
import org.eclipse.lsat.common.emf.common.util.URIHelper;
import org.eclipse.lsat.common.graph.directed.editable.EditableDirectedGraph;
import org.eclipse.lsat.common.graph.directed.editable.Node;
import org.eclipse.lsat.common.queries.QueryableIterable;
import org.eclipse.lsat.resource_throughput.ui.editors.ExceptionalBiFunction;
import org.eclipse.lsat.resource_throughput.ui.editors.ExceptionalFunction;
import org.eclipse.lsat.resource_throughput.ui.editors.ResourceThroughputEditingDomain;
import org.eclipse.lsat.resource_throughput.ui.editors.ResourceThroughputEditorPlugin;
import org.eclipse.lsat.resource_throughput.ui.editors.ResourceThroughputOutlineContentProvider;
import org.eclipse.lsat.resource_throughput.ui.editors.ResourceThroughputOutlineItem;
import org.eclipse.lsat.resource_throughput.ui.editors.ResourceThroughputTableContentProvider;
import org.eclipse.lsat.resource_throughput.ui.editors.ResourceThroughputViewerPane;
import org.eclipse.lsat.resource_throughput.ui.editors.internal.AxisTargetLocationEditingSupport;
import org.eclipse.lsat.resource_throughput.ui.editors.internal.MotionProfileEditingSupport;
import org.eclipse.lsat.resource_throughput.ui.editors.internal.SimpleActionExecutionTimeEditingSupport;
import org.eclipse.lsat.timing.util.MoveHelper;
import org.eclipse.lsat.timing.util.SpecificationException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import setting.SettingActivator;

public class ResourceThroughputEditorPart
extends AbstractEMFMultiPageEditorPart {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceThroughputEditorPart.class);
    private static final int MIN_COL_WIDTH = 60;
    private AdapterFactoryLabelProvider labelProvider;
    private final ResourceThroughputOutlineContentProvider outlineContentProvider = new ResourceThroughputOutlineContentProvider();

    public ResourceThroughputEditorPart() {
        this.addPageChangedListener(new IPageChangedListener(){

            public void pageChanged(PageChangedEvent event) {
                ResourceThroughputEditorPart.this.refresh(false);
            }
        });
    }

    @Override
    protected EMFPlugin getPlugin() {
        return ResourceThroughputEditorPlugin.INSTANCE;
    }

    public void refresh(boolean reCalculate) {
        Viewer viewer = this.getViewer();
        if (viewer != null) {
            viewer.getControl().setCursor(this.getSite().getShell().getDisplay().getSystemCursor(1));
        }
        if (reCalculate) {
            this.getResourceThroughputEditingDomain().reCalculate();
            if (this.contentOutlinePage != null) {
                ((IViewerProvider)this.contentOutlinePage).getViewer().refresh();
            }
        }
        if (viewer != null) {
            viewer.refresh();
            viewer.getControl().setCursor(this.getSite().getShell().getDisplay().getSystemCursor(0));
        }
    }

    public void reload() {
        if (this.isDirty() && !MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)"Discard changes", (String)"There are unsaved changes.  Do you wish to discard this editor's changes?")) {
            return;
        }
        this.handleReload();
    }

    @Override
    public boolean isSaveAsAllowed() {
        return false;
    }

    @Override
    protected EditingDomain createEditingDomain(CommandStack commandStack, Map<Resource, Boolean> resourceToReadOnlyMap) {
        this.adapterFactory.insertAdapterFactory((AdapterFactory)new MachineItemProviderAdapterFactory());
        this.labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory);
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                ResourceThroughputEditorPart.this.refresh(true);
            }
        });
        return new ResourceThroughputEditingDomain((AdapterFactory)this.adapterFactory, commandStack);
    }

    protected ResourceThroughputEditingDomain getResourceThroughputEditingDomain() {
        return (ResourceThroughputEditingDomain)this.editingDomain;
    }

    @Override
    protected Resource createModel() {
        Resource dispatchingResource = super.createModel();
        if (dispatchingResource == null || !dispatchingResource.isLoaded()) {
            return dispatchingResource;
        }
        URI settingsUri = null;
        try {
            URI dispatchingURI = dispatchingResource.getURI();
            IResource settingIResource = SettingActivator.getDefault().getSettingIResource(URIHelper.asIResource((URI)dispatchingURI));
            settingsUri = URIHelper.asURI((IResource)settingIResource);
        }
        catch (Exception e) {
            if (!this.resourceToDiagnosticMap.containsKey(dispatchingResource)) {
                this.resourceToDiagnosticMap.put(dispatchingResource, this.analyzeResourceProblems(dispatchingResource, e));
            }
            return dispatchingResource;
        }
        Exception exception = null;
        Resource settingsResource = null;
        try {
            settingsResource = this.editingDomain.getResourceSet().getResource(settingsUri, true);
        }
        catch (Exception e) {
            exception = e;
            settingsResource = this.editingDomain.getResourceSet().getResource(settingsUri, false);
        }
        Diagnostic diagnostic = this.analyzeResourceProblems(settingsResource, exception);
        if (diagnostic.getSeverity() != 0) {
            this.resourceToDiagnosticMap.put(settingsResource, diagnostic);
        }
        return dispatchingResource;
    }

    @Override
    protected IContentOutlinePage createOutlinePage() {
        return new TableContentOutlinePage(){

            @Override
            protected int getTableStyle() {
                return 66308;
            }

            @Override
            public void createControl(Composite parent) {
                super.createControl(parent);
                TableViewer viewer = this.getTableViewer();
                Table table = viewer.getTable();
                TableLayout layout = new TableLayout();
                table.setLayout((Layout)layout);
                table.setHeaderVisible(true);
                table.setLinesVisible(true);
                layout.addColumnData((ColumnLayoutData)new ColumnWeightData(2, 60, true));
                TableViewerColumn tvcResource = new TableViewerColumn(viewer, 16384);
                tvcResource.setLabelProvider((CellLabelProvider)new OutlineColumnLabelProvider(i -> i.getResource() == null ? "Total" : i.getResource().fqn()));
                TableColumn tcResource = tvcResource.getColumn();
                tcResource.setText("Resource");
                layout.addColumnData((ColumnLayoutData)new ColumnWeightData(3, 60, true));
                TableViewerColumn tvcMakespan = new TableViewerColumn(viewer, 131072);
                tvcMakespan.setLabelProvider((CellLabelProvider)new OutlineColumnLabelProvider(i -> String.format("%,.6f", i.getTotalMakespan())));
                TableColumn tcMakespan = tvcMakespan.getColumn();
                tcMakespan.setText("Makespan [sec]");
                layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 60, true));
                TableViewerColumn tvcIterations = new TableViewerColumn(viewer, 131072);
                tvcIterations.setLabelProvider((CellLabelProvider)new OutlineColumnLabelProvider(i -> String.format("%,d", i.getNumberOfIterations())));
                TableColumn tcIterations = tvcIterations.getColumn();
                tcIterations.setText("No. Iterations");
                layout.addColumnData((ColumnLayoutData)new ColumnWeightData(3, 60, true));
                TableViewerColumn tvcIterationMakespan = new TableViewerColumn(viewer, 131072);
                tvcIterationMakespan.setLabelProvider((CellLabelProvider)new OutlineColumnLabelProvider(i -> String.format("%,.6f", i.getIterationMakespan())));
                TableColumn tcIterationMakespan = tvcIterationMakespan.getColumn();
                tcIterationMakespan.setText("Iteration Makespan [sec]");
                layout.addColumnData((ColumnLayoutData)new ColumnWeightData(2, 60, true));
                TableViewerColumn tvcThroughput = new TableViewerColumn(viewer, 131072);
                tvcThroughput.setLabelProvider((CellLabelProvider)new OutlineColumnLabelProvider(i -> String.format("%,.1f", i.getThroughput())));
                TableColumn tcThroughput = tvcThroughput.getColumn();
                tcThroughput.setText("Throughput [per hour]");
                viewer.setContentProvider((IContentProvider)ResourceThroughputEditorPart.this.outlineContentProvider);
                viewer.setInput((Object)ResourceThroughputEditorPart.this.editingDomain);
            }
        };
    }

    protected void createPages() {
        this.createModel();
        ResourceThroughputEditingDomain rtEditingDomain = this.getResourceThroughputEditingDomain();
        this.outlineContentProvider.getElements((Object)rtEditingDomain);
        QueryableIterable activitiesNodes = rtEditingDomain.getActivities().collect(EditableDirectedGraph::getNodes);
        LinkedHashSet resources = activitiesNodes.objectsOfKind(PeripheralAction.class).collectOne(HasResourcePeripheral::getResource).sortedBy(machine.IResource::fqn, String.CASE_INSENSITIVE_ORDER).asOrderedSet();
        LinkedHashSet axisNames = activitiesNodes.objectsOfKind(Move.class).collectOne(PeripheralAction::getPeripheral).collectOne(Peripheral::getType).collect(PeripheralType::getAxes).collectOne(Axis::getName).asOrderedSet();
        LinkedHashSet setPointNames = activitiesNodes.objectsOfKind(Move.class).collectOne(PeripheralAction::getPeripheral).collectOne(Peripheral::getType).collect(PeripheralType::getSetPoints).collectOne(SetPoint::getName).asOrderedSet();
        for (machine.IResource resource : resources) {
            String resourceFqn = resource.fqn();
            ResourceThroughputViewerPane viewerPane = new ResourceThroughputViewerPane(this.labelProvider.getText((Object)resource), this.labelProvider.getImage((Object)resource), this.getSite().getPage(), this);
            viewerPane.createControl(this.getContainer());
            TableViewer tableViewer = (TableViewer)viewerPane.getViewer();
            this.configureTableViewer(tableViewer, axisNames, setPointNames, o -> this.outlineContentProvider.getCriticalActions(resourceFqn).contains(o));
            ResourceThroughputTableContentProvider contentProvider = new ResourceThroughputTableContentProvider(resourceFqn);
            tableViewer.setContentProvider((IContentProvider)contentProvider);
            tableViewer.setInput((Object)this.editingDomain);
            this.createContextMenuFor((StructuredViewer)tableViewer);
            int pageIndex = this.addPage((ViewerPane)viewerPane);
            this.setPageText(pageIndex, String.format("%s", resourceFqn));
            this.setPageImage(pageIndex, this.labelProvider.getImage((Object)resource));
            viewerPane.refreshTitle();
        }
        if (resources.isEmpty()) {
            if (this.resourceToDiagnosticMap.isEmpty()) {
                this.resourceToDiagnosticMap.put((Resource)rtEditingDomain.getResourceSet().getResources().get(0), new BasicDiagnostic(4, this.getPlugin().getSymbolicName(), 0, "No machine resources found in dispatching file", null));
            }
            this.updateProblemIndication();
        }
    }

    protected void configureTableViewer(TableViewer viewer, Collection<String> axisNames, Collection<String> setPointNames, final CriticalPath criticalPath) {
        Table table = viewer.getTable();
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(2, 60, true));
        TableViewerColumn tvcPeripheral = new TableViewerColumn(viewer, 16384);
        tvcPeripheral.setLabelProvider(new ColumnLabelProvider<PeripheralAction>(PeripheralAction.class, a -> a.getResource().fqn() + "." + a.getPeripheral().getName()));
        TableColumn tcPeripheral = tvcPeripheral.getColumn();
        tcPeripheral.setText("Peripheral");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(2, 60, true));
        TableViewerColumn tvcAction = new TableViewerColumn(viewer, 16384);
        tvcAction.setLabelProvider(new ColumnLabelProvider<PeripheralAction>(PeripheralAction.class, a -> a.getGraph().getName() + "." + a.getName()));
        TableColumn tcAction = tvcAction.getColumn();
        tcAction.setText("Action");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(4, 60, true));
        TableViewerColumn tvcFrom = new TableViewerColumn(viewer, 16384);
        tvcFrom.setLabelProvider(new ColumnLabelProvider<PeripheralAction>(PeripheralAction.class, m -> {
            if (m instanceof Move) {
                Move move = (Move)m;
                if (move.isPositionMove()) {
                    return move.getSourcePosition().getName();
                }
                return MoveHelper.getName((Move)move);
            }
            if (m instanceof SimpleAction) {
                return ((SimpleAction)m).getType().getName();
            }
            return m.getName();
        }));
        TableColumn tcFrom = tvcFrom.getColumn();
        tcFrom.setText("Name / From / Distance");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(4, 60, true));
        TableViewerColumn tvcTo = new TableViewerColumn(viewer, 16384);
        tvcTo.setLabelProvider(new ColumnLabelProvider<Move>(Move.class, m -> m.isPositionMove() ? m.getTargetPosition().getName() : ""));
        TableColumn tcTo = tvcTo.getColumn();
        tcTo.setText("To");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 60, true));
        TableViewerColumn tvcSettling = new TableViewerColumn(viewer, 16384);
        tvcSettling.setLabelProvider(new ColumnLabelProvider<Move>(Move.class, m -> MoveHelper.getSettlingAxes((Move)m).stream().map(Axis::getName).collect(Collectors.joining(", "))));
        TableColumn tcSettling = tvcSettling.getColumn();
        tcSettling.setText("Settling");
        for (final String axisName : axisNames) {
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(2, 60, true));
            TableViewerColumn tvcAxisOld = new TableViewerColumn(viewer, 131072);
            tvcAxisOld.setLabelProvider((CellLabelProvider)new AxisColumnLabelProvider(axisName, (m, x) -> this.toString((Axis)x, (Move)m, true)));
            TableColumn tcAxisOld = tvcAxisOld.getColumn();
            tcAxisOld.setText("Old " + axisName);
        }
        for (final String axisName : axisNames) {
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(2, 60, true));
            TableViewerColumn tvcAxisNew = new TableViewerColumn(viewer, 131072);
            tvcAxisNew.setLabelProvider((CellLabelProvider)new AxisColumnLabelProvider(axisName, (m, x) -> this.toString((Axis)x, (Move)m, false)){

                @Override
                public Image getImage(Object element) {
                    Image image = super.getImage(element);
                    if (image != null || !(element instanceof Move)) {
                        return image;
                    }
                    Move m = (Move)element;
                    Axis x = MachineQueries.getAxis((Peripheral)m.getPeripheral(), (String)axisName);
                    if (x == null) {
                        return image;
                    }
                    try {
                        int difference;
                        BigDecimal sourcePos = ResourceThroughputEditorPart.this.getValue(x, m, true, BigDecimal.ZERO);
                        BigDecimal targetPos = ResourceThroughputEditorPart.this.getValue(x, m, false, BigDecimal.ZERO);
                        int n = difference = targetPos != null ? targetPos.compareTo(sourcePos) : sourcePos.intValue();
                        if (difference > 0) {
                            image = ResourceThroughputEditorPlugin.getPlugin().getImageRegistry().get(ResourceThroughputEditorPlugin.IMAGE_UP);
                        } else if (difference < 0) {
                            image = ResourceThroughputEditorPlugin.getPlugin().getImageRegistry().get(ResourceThroughputEditorPlugin.IMAGE_DOWN);
                        }
                    }
                    catch (SpecificationException e) {
                        LOGGER.debug("Could not determine position", (Throwable)e);
                    }
                    return image;
                }
            });
            tvcAxisNew.setEditingSupport((EditingSupport)new AxisTargetLocationEditingSupport((ColumnViewer)viewer, axisName, this.getResourceThroughputEditingDomain()));
            TableColumn tcAxisNew = tvcAxisNew.getColumn();
            tcAxisNew.setText("New " + axisName);
            tcAxisNew.setImage(ResourceThroughputEditorPlugin.getPlugin().getImageRegistry().get(ResourceThroughputEditorPlugin.IMAGE_EDIT));
        }
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(2, 60, true));
        TableViewerColumn tvcProfile = new TableViewerColumn(viewer, 16384);
        tvcProfile.setLabelProvider(new ColumnLabelProvider<Move>(Move.class, m -> m.getProfile().getName()));
        tvcProfile.setEditingSupport((EditingSupport)new MotionProfileEditingSupport((ColumnViewer)viewer, this.getResourceThroughputEditingDomain()));
        TableColumn tcProfile = tvcProfile.getColumn();
        tcProfile.setText("Profile");
        tcProfile.setImage(ResourceThroughputEditorPlugin.getPlugin().getImageRegistry().get(ResourceThroughputEditorPlugin.IMAGE_EDIT));
        for (String setPointName : setPointNames) {
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(2, 60, true));
            TableViewerColumn tvcAxisTime = new TableViewerColumn(viewer, 131072);
            tvcAxisTime.setLabelProvider((CellLabelProvider)new SetPointColumnLabelProvider(setPointName, (m, s) -> this.formatTime((BigDecimal)this.getResourceThroughputEditingDomain().getTimingCalculator().calculateMotionTime(m).get(s))));
            TableColumn tcAxisTime = tvcAxisTime.getColumn();
            tcAxisTime.setText(setPointName + " time [ms]");
        }
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(3, 60, true));
        TableViewerColumn tvcTime = new TableViewerColumn(viewer, 131072);
        tvcTime.setLabelProvider((CellLabelProvider)new ColumnLabelProvider<PeripheralAction>(PeripheralAction.class, a -> this.formatTime(this.getResourceThroughputEditingDomain().getTimingCalculator().calculateDuration((Node)a))){

            @Override
            public Image getImage(Object element) {
                return criticalPath.contains(element) ? ResourceThroughputEditorPlugin.getPlugin().getImageRegistry().get(ResourceThroughputEditorPlugin.IMAGE_CRITICAL) : super.getImage(element);
            }
        });
        tvcTime.setEditingSupport((EditingSupport)new SimpleActionExecutionTimeEditingSupport((ColumnViewer)viewer, this.getResourceThroughputEditingDomain()));
        TableColumn tcTime = tvcTime.getColumn();
        tcTime.setText("Time [ms]");
        tcTime.setImage(ResourceThroughputEditorPlugin.getPlugin().getImageRegistry().get(ResourceThroughputEditorPlugin.IMAGE_EDIT));
    }

    protected String formatTime(BigDecimal timeInSeconds) {
        return String.format("%,.3f", timeInSeconds.movePointRight(3));
    }

    String toString(Axis axis, Move m, boolean atStartOfMove) throws SpecificationException {
        BigDecimal value = this.getValue(axis, m, atStartOfMove, null);
        return value == null ? "" : String.valueOf(value);
    }

    BigDecimal getValue(Axis axis, Move m, boolean atStartOfMove, BigDecimal defaultValue) throws SpecificationException {
        MoveHelper helper = new MoveHelper(m, axis, this.getResourceThroughputEditingDomain().getSettings());
        return helper.getPosition(atStartOfMove, defaultValue);
    }

    protected static class AxisColumnLabelProvider
    extends ColumnLabelProvider<Move> {
        private final String axisName;

        private AxisColumnLabelProvider(String axisName, ExceptionalBiFunction<Move, Axis, String, ?> valueProvider) {
            super(Move.class, (T m) -> {
                Axis x = MachineQueries.getAxis((Peripheral)m.getPeripheral(), (String)axisName);
                return x == null ? null : (String)valueProvider.apply((Move)m, x);
            });
            this.axisName = axisName;
        }

        @Override
        public Color getBackground(Object element) {
            Color background = super.getBackground(element);
            if (background == null && MachineQueries.getAxis((Peripheral)((Move)element).getPeripheral(), (String)this.axisName) == null) {
                background = Display.getDefault().getSystemColor(22);
            }
            return background;
        }
    }

    protected static class ColumnLabelProvider<T>
    extends org.eclipse.jface.viewers.ColumnLabelProvider {
        private final Class<T> type;
        private final ExceptionalFunction<T, String, ?> valueProvider;

        public ColumnLabelProvider(Class<T> type, ExceptionalFunction<T, String, ?> valueProvider) {
            this.type = type;
            this.valueProvider = valueProvider;
        }

        public String getText(Object element) {
            try {
                return this.type.isInstance(element) ? this.valueProvider.apply(this.type.cast(element)) : null;
            }
            catch (Exception e) {
                String msg = e.getLocalizedMessage();
                return msg == null ? e.toString() : msg;
            }
        }

        public Image getImage(Object element) {
            if (this.type.isInstance(element)) {
                try {
                    this.valueProvider.apply(this.type.cast(element));
                }
                catch (Exception e) {
                    return ResourceThroughputEditorPlugin.getPlugin().getImageRegistry().get(ResourceThroughputEditorPlugin.IMAGE_ERROR);
                }
            }
            return null;
        }

        public Color getBackground(Object element) {
            return this.type.isInstance(element) ? null : Display.getDefault().getSystemColor(22);
        }
    }

    @FunctionalInterface
    protected static interface CriticalPath {
        public boolean contains(Object var1);
    }

    protected static class OutlineColumnLabelProvider
    extends ColumnLabelProvider<ResourceThroughputOutlineItem> {
        public OutlineColumnLabelProvider(ExceptionalFunction<ResourceThroughputOutlineItem, String, ?> valueProvider) {
            super(ResourceThroughputOutlineItem.class, valueProvider);
        }

        @Override
        public Color getBackground(Object element) {
            Color background = super.getBackground(element);
            if (background == null && element instanceof ResourceThroughputOutlineItem && ((ResourceThroughputOutlineItem)element).getResource() == null) {
                background = Display.getDefault().getSystemColor(29);
            }
            return background;
        }
    }

    protected static class SetPointColumnLabelProvider
    extends ColumnLabelProvider<Move> {
        private final String setPointName;

        private SetPointColumnLabelProvider(String setPointName, ExceptionalBiFunction<Move, SetPoint, String, ?> valueProvider) {
            super(Move.class, (T m) -> {
                SetPoint s = MachineQueries.getSetPoint((Peripheral)m.getPeripheral(), (String)setPointName);
                return s == null ? null : (String)valueProvider.apply((Move)m, s);
            });
            this.setPointName = setPointName;
        }

        @Override
        public Color getBackground(Object element) {
            Color background = super.getBackground(element);
            if (background == null && MachineQueries.getSetPoint((Peripheral)((Move)element).getPeripheral(), (String)this.setPointName) == null) {
                background = Display.getDefault().getSystemColor(22);
            }
            return background;
        }
    }
}

