/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.api.algorithm;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.lsat.common.ludus.api.MaxPlusException;
import org.eclipse.lsat.common.ludus.api.MaximumThroughputResult;
import org.eclipse.lsat.common.ludus.api.algorithm.MaxPlusAlgorithm;
import org.eclipse.lsat.common.ludus.backend.algebra.Matrix;
import org.eclipse.lsat.common.ludus.backend.algebra.Value;
import org.eclipse.lsat.common.ludus.backend.algorithms.Dijkstra;
import org.eclipse.lsat.common.ludus.backend.algorithms.Howard;
import org.eclipse.lsat.common.ludus.backend.datastructures.tuple.Tuple;
import org.eclipse.lsat.common.ludus.backend.fsm.FSM;
import org.eclipse.lsat.common.ludus.backend.fsm.impl.Edge;
import org.eclipse.lsat.common.ludus.backend.fsm.impl.Location;
import org.eclipse.lsat.common.ludus.backend.statespace.ComputeStateSpace;
import org.eclipse.lsat.common.ludus.backend.statespace.Configuration;
import org.eclipse.lsat.common.ludus.backend.statespace.MaxPlusStateSpace;
import org.eclipse.lsat.common.ludus.backend.statespace.Transition;
import org.eclipse.lsat.common.mpt.api.NotAllResourcesLinkedException;
import org.eclipse.lsat.common.mpt.api.UnconnectedResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaximumThroughputAlgorithm
extends MaxPlusAlgorithm {
    private static final Logger LOGGER = LoggerFactory.getLogger(MaximumThroughputAlgorithm.class);

    public static MaximumThroughputResult run(FSM<Location, Edge> fsm, Map<String, Matrix> matrixMap) throws MaxPlusException, NotAllResourcesLinkedException, UnconnectedResourceException {
        MaximumThroughputAlgorithm.checkCyclic(fsm);
        MaximumThroughputAlgorithm.checkNoDeadlocks(fsm);
        MaximumThroughputAlgorithm.checkAllMatricesSameSize(matrixMap.values());
        MaximumThroughputAlgorithm.checkEventMapping(fsm, matrixMap);
        Integer resourceCount = matrixMap.values().iterator().next().getRows();
        long startTime = System.currentTimeMillis();
        MaxPlusStateSpace stateSpaceOriginal = ComputeStateSpace.computeMaxPlusStateSpace(fsm, resourceCount, matrixMap);
        long endTime = System.currentTimeMillis();
        MaxPlusStateSpace stateSpace = ComputeStateSpace.swapWeights(stateSpaceOriginal);
        LOGGER.info("Max-plus state space constructed: " + stateSpace.getVertices().size() + " states and " + stateSpace.getEdges().size() + " edges. Generation took " + (endTime - startTime) + " ms.");
        startTime = System.currentTimeMillis();
        List<MaxPlusStateSpace> mpsSCCs = ComputeStateSpace.getSCCs(stateSpace);
        endTime = System.currentTimeMillis();
        LOGGER.info("Found " + mpsSCCs.size() + " strongly connected component(s) in " + (endTime - startTime) + " ms.");
        startTime = System.currentTimeMillis();
        int i = 1;
        Tuple<Value, List<Object>> howardResult = Tuple.of(Value.POSITIVE_INFINITY, new LinkedList());
        for (MaxPlusStateSpace mpsSCC : mpsSCCs) {
            Tuple<Value, List<Transition>> sccResult = Howard.runHoward(mpsSCC);
            LOGGER.info("Running Howard on component " + i);
            if (sccResult.getRight() == null) {
                throw new MaxPlusException("Throughput for component " + i + " cannot be determined due to floating-point precision issues.");
            }
            if (sccResult.getLeft().smallerThan(howardResult.getLeft())) {
                howardResult = sccResult;
            }
            ++i;
        }
        endTime = System.currentTimeMillis();
        Double throughput = new Value(1.0).divide(howardResult.getLeft()).toDouble();
        LOGGER.info("Maximum throughput computed using Howards's MCR algorithm in " + (endTime - startTime) + " ms.");
        List cycleConfigurations = ((List)howardResult.getRight()).stream().map(t -> t.getSource()).collect(Collectors.toList());
        Tuple<Value, List<Transition>> dijkstraResult = Dijkstra.runDijkstra(stateSpace, stateSpace.getInitialConfiguration(), cycleConfigurations);
        if (!howardResult.getLeft().equals(Value.NEGATIVE_INFINITY)) {
            List<String> listOfEventNamesTransientState;
            List<String> listOfEventNamesSteadyState;
            if (!dijkstraResult.getRight().isEmpty()) {
                Configuration startingConfigurationOnCycle = dijkstraResult.getRight().get(dijkstraResult.getRight().size() - 1).getTarget();
                int cycleIndex = -1;
                int index = 0;
                while (index < howardResult.getRight().size()) {
                    if (((Transition)howardResult.getRight().get(index)).getSource().equals(startingConfigurationOnCycle)) {
                        cycleIndex = index;
                        break;
                    }
                    ++index;
                }
                ArrayList<Object> cyclePermutation = new ArrayList<Object>();
                cyclePermutation.addAll(howardResult.getRight().subList(cycleIndex, howardResult.getRight().size()));
                cyclePermutation.addAll(howardResult.getRight().subList(0, cycleIndex));
                listOfEventNamesSteadyState = cyclePermutation.stream().map(Transition::getEvent).collect(Collectors.toList());
                listOfEventNamesTransientState = dijkstraResult.getRight().stream().map(Transition::getEvent).collect(Collectors.toList());
            } else {
                listOfEventNamesSteadyState = howardResult.getRight().stream().map(Transition::getEvent).collect(Collectors.toList());
                listOfEventNamesTransientState = new ArrayList<String>();
            }
            return new MaximumThroughputResult(throughput, listOfEventNamesSteadyState, listOfEventNamesTransientState);
        }
        return new MaximumThroughputResult(throughput);
    }
}

