/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.conformance.ui;

import activity.Activity;
import activity.ActivitySet;
import jakarta.inject.Named;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.lsat.common.emf.common.util.URIHelper;
import org.eclipse.lsat.common.emf.ecore.resource.Persistor;
import org.eclipse.lsat.common.emf.ecore.resource.PersistorFactory;
import org.eclipse.lsat.common.emf.ui.model.ModelWorkbenchContentProvider;
import org.eclipse.lsat.common.emf.ui.model.ModelWorkbenchLabelProvider;
import org.eclipse.lsat.conformance.FilterTPTracePointsInput;
import org.eclipse.lsat.conformance.FilterTPTracePointsJava;
import org.eclipse.lsat.trace.TraceModel;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class FilterTPTraceHandler {
    @Execute
    public void execute(@Optional @Named(value="org.eclipse.ui.selection") IStructuredSelection selection, Shell shell, IWorkspace workspace) {
        if (selection == null || selection.isEmpty()) {
            return;
        }
        if (!PlatformUI.getWorkbench().saveAllEditors(true)) {
            return;
        }
        List<Activity> activities = this.selectActivities();
        if (activities == null || activities.isEmpty()) {
            return;
        }
        FilterTPTraceJob job = new FilterTPTraceJob(selection.toList(), activities);
        job.setUser(true);
        job.schedule();
    }

    private List<Activity> selectActivities() {
        ModelWorkbenchLabelProvider modelWorkbenchLabelProvider = new ModelWorkbenchLabelProvider(new AdapterFactory[0]);
        ModelWorkbenchContentProvider modelWorkbenchContentProvider = new ModelWorkbenchContentProvider(new AdapterFactory[]{modelWorkbenchLabelProvider.getAdapterFactory()});
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (ILabelProvider)modelWorkbenchLabelProvider, (ITreeContentProvider)modelWorkbenchContentProvider);
        dialog.setTitle("Select activities");
        dialog.setMessage("Select activities to filter from trace");
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IFile) {
                    return Objects.equals("activity", ((IFile)element).getFileExtension());
                }
                return element instanceof IContainer || element instanceof ActivitySet || element instanceof Activity;
            }
        });
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length <= 0) {
                    return new Status(4, "org.eclipse.lsat.conformance.ui", 0, "Please select one or more activities!", null);
                }
                Object[] objectArray = selection;
                int n = selection.length;
                int n2 = 0;
                while (n2 < n) {
                    Object selected = objectArray[n2];
                    if (!(selected instanceof Activity)) {
                        return new Status(4, "org.eclipse.lsat.conformance.ui", 0, "Only activity selection is allowed!", null);
                    }
                    ++n2;
                }
                return new Status(0, "org.eclipse.lsat.conformance.ui", 0, "OK", null);
            }
        });
        dialog.open();
        return dialog.getResult() == null ? null : (List)List.class.cast(Arrays.asList(dialog.getResult()));
    }

    private static class FilterTPTraceJob
    extends Job {
        private final List<?> traces;
        private final List<Activity> activities;

        public FilterTPTraceJob(List<?> traces, List<Activity> activities) {
            super("FilterTPTraceJob");
            this.traces = traces;
            this.activities = activities;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                monitor.beginTask("Filtering trace files", this.traces.size());
                for (Object traceIFile : this.traces) {
                    PersistorFactory factory = new PersistorFactory();
                    URI modelURI = URIHelper.asURI((IResource)((IFile)traceIFile));
                    monitor.subTask("Filtering " + String.valueOf(modelURI));
                    Persistor tracePersistor = factory.getPersistor(TraceModel.class);
                    TraceModel tpTraceModel = (TraceModel)tracePersistor.loadOne(modelURI);
                    FilterTPTracePointsJava filterTPTracePoints = new FilterTPTracePointsJava();
                    List tpTraceModels = filterTPTracePoints.transformModel(new FilterTPTracePointsInput(this.activities, tpTraceModel));
                    tracePersistor.save(modelURI, new Collection[]{tpTraceModels});
                    monitor.worked(1);
                    if (!monitor.isCanceled()) continue;
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            catch (Exception e) {
                Status status = new Status(4, "org.eclipse.lsat.conformance.ui", e.getMessage(), (Throwable)e);
                return status;
            }
            finally {
                monitor.done();
            }
        }
    }
}

