/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.setting.teditor.scoping;

import com.google.common.collect.Iterables;
import common.Import;
import expressions.Declaration;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import machine.Axis;
import machine.IResource;
import machine.Peripheral;
import machine.PeripheralType;
import machine.Resource;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.scoping.impl.AbstractDeclarativeScopeProvider;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import setting.MoveAdjustments;
import setting.PhysicalSettings;
import setting.Settings;
import setting.impl.MotionSettingsMapEntryImpl;

public class SettingScopeProvider
extends AbstractDeclarativeScopeProvider {
    public IScope scope_DeclarationRef_declaration(EObject context, EReference ref) {
        if (context instanceof Declaration) {
            Settings settings = (Settings)EcoreUtil2.getContainerOfType((EObject)context, Settings.class);
            Set<Declaration> importedDeclarations = this.findImportedDeclarations(settings, CollectionLiterals.newLinkedHashSet());
            Functions.Function1 _function = it -> !Objects.equals(it, context);
            Iterable priorDeclarations = IterableExtensions.takeWhile((Iterable)settings.getDeclarations(), (Functions.Function1)_function);
            Iterable _plus = Iterables.concat((Iterable)priorDeclarations, importedDeclarations);
            return Scopes.scopeFor((Iterable)_plus);
        }
        return null;
    }

    public Set<Declaration> findImportedDeclarations(Settings settings, Set<Declaration> declarations) {
        EList _imports = settings.getImports();
        for (Import import_ : _imports) {
            Consumer<Settings> _function = impSettings -> {
                boolean _addAll = declarations.addAll((Collection<Declaration>)impSettings.getDeclarations());
                if (_addAll) {
                    this.findImportedDeclarations((Settings)impSettings, declarations);
                }
            };
            Iterables.filter((Iterable)import_.load(), Settings.class).forEach(_function);
        }
        return declarations;
    }

    public IScope scope_Peripheral(PhysicalSettings entry, EReference ref) {
        boolean _tripleEquals;
        IResource _resource = null;
        if (entry != null) {
            _resource = entry.getResource();
        }
        Resource _resource_1 = null;
        if (_resource != null) {
            _resource_1 = _resource.getResource();
        }
        boolean bl = _tripleEquals = _resource_1 == null;
        if (_tripleEquals) {
            return IScope.NULLSCOPE;
        }
        return Scopes.scopeFor((Iterable)entry.getResource().getResource().getPeripherals());
    }

    public IScope scope_ActionType(PhysicalSettings entry, EReference ref) {
        boolean _tripleEquals;
        Peripheral _peripheral = null;
        if (entry != null) {
            _peripheral = entry.getPeripheral();
        }
        PeripheralType _type = null;
        if (_peripheral != null) {
            _type = _peripheral.getType();
        }
        boolean bl = _tripleEquals = _type == null;
        if (_tripleEquals) {
            return IScope.NULLSCOPE;
        }
        return Scopes.scopeFor((Iterable)entry.getPeripheral().getType().getActions());
    }

    public IScope scope_Axis(PhysicalSettings entry, EReference ref) {
        boolean _tripleEquals;
        Peripheral _peripheral = null;
        if (entry != null) {
            _peripheral = entry.getPeripheral();
        }
        PeripheralType _type = null;
        if (_peripheral != null) {
            _type = _peripheral.getType();
        }
        boolean bl = _tripleEquals = _type == null;
        if (_tripleEquals) {
            return IScope.NULLSCOPE;
        }
        return Scopes.scopeFor((Iterable)entry.getPeripheral().getType().getAxes());
    }

    public IScope scope_Profile(PhysicalSettings entry, EReference ref) {
        boolean _tripleEquals;
        Peripheral _peripheral = null;
        if (entry != null) {
            _peripheral = entry.getPeripheral();
        }
        boolean bl = _tripleEquals = _peripheral == null;
        if (_tripleEquals) {
            return IScope.NULLSCOPE;
        }
        return Scopes.scopeFor((Iterable)entry.getPeripheral().getProfiles());
    }

    public IScope scope_Position(MotionSettingsMapEntryImpl entry, EReference ref) {
        Axis _key = null;
        if (entry != null) {
            _key = entry.getKey();
        }
        Axis axis = _key;
        PhysicalSettings _settings = null;
        if (entry != null) {
            _settings = entry.getSettings();
        }
        Peripheral _peripheral = null;
        if (_settings != null) {
            _peripheral = _settings.getPeripheral();
        }
        Peripheral peripheral = _peripheral;
        if (axis == null || peripheral == null) {
            return IScope.NULLSCOPE;
        }
        LinkedHashSet candidates = CollectionLiterals.newLinkedHashSet();
        EList axisPositions = (EList)peripheral.getAxisPositions().get((Object)axis);
        if (axisPositions != null) {
            Iterables.addAll((Collection)candidates, (Iterable)axisPositions);
        }
        Functions.Function1 _function = it -> it.getPosition(axis);
        Iterable _filterNull = IterableExtensions.filterNull((Iterable)ListExtensions.map((List)peripheral.getPositions(), (Functions.Function1)_function));
        Iterables.addAll((Collection)candidates, (Iterable)_filterNull);
        return Scopes.scopeFor((Iterable)candidates);
    }

    public IScope scope_Distance(MotionSettingsMapEntryImpl entry, EReference ref) {
        Peripheral peripheral;
        PhysicalSettings _settings = null;
        if (entry != null) {
            _settings = entry.getSettings();
        }
        Peripheral _peripheral = null;
        if (_settings != null) {
            _peripheral = _settings.getPeripheral();
        }
        if ((peripheral = _peripheral) == null) {
            return IScope.NULLSCOPE;
        }
        return Scopes.scopeFor((Iterable)peripheral.getDistances());
    }

    public IScope scope_Declaration(MoveAdjustments entry, EReference ref) {
        return Scopes.scopeFor(List.of(entry.getTimeDeclaration()), (IScope)this.delegateGetScope((EObject)entry, ref));
    }
}

