/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.callhierarchy;

import org.eclipse.jface.viewers.StyledString;
import org.eclipse.lsp4e.callhierarchy.CallHierarchyLabelProvider;
import org.eclipse.lsp4e.callhierarchy.CallHierarchyViewTreeNode;
import org.eclipse.lsp4e.test.utils.AbstractTest;
import org.eclipse.lsp4j.CallHierarchyItem;
import org.eclipse.swt.custom.StyleRange;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class CallHierarchyLabelProviderTest
extends AbstractTest {
    private static CallHierarchyLabelProvider labelProvider = null;

    @BeforeClass
    public static void setUp() {
        labelProvider = new CallHierarchyLabelProvider();
    }

    @Test
    public void testSimpleText() {
        String name = "Some arbitrary name";
        StyledString label = labelProvider.getStyledText((Object)name);
        Assert.assertEquals((Object)name, (Object)label.getString());
        StyledString expectedStyledText = new StyledString();
        expectedStyledText.append(name);
        this.assertEqualStyles(expectedStyledText, label);
    }

    @Test
    public void testCallHierarchyItemLabelWithSimpleName() {
        String name = "calledMethod()";
        CallHierarchyItem callHierarchyItem = new CallHierarchyItem();
        callHierarchyItem.setName(name);
        CallHierarchyViewTreeNode node = new CallHierarchyViewTreeNode(callHierarchyItem);
        StyledString label = labelProvider.getStyledText((Object)node);
        Assert.assertEquals((Object)name, (Object)label.getString());
        StyledString expectedStyledText = new StyledString();
        expectedStyledText.append(name);
        this.assertEqualStyles(expectedStyledText, label);
    }

    @Test
    public void testCallHierarchyItemLabelWithoutDetail() {
        String name = "doSomething(ClassName<T> param1, double param2) : String";
        CallHierarchyItem callHierarchyItem = new CallHierarchyItem();
        callHierarchyItem.setName(name);
        CallHierarchyViewTreeNode node = new CallHierarchyViewTreeNode(callHierarchyItem);
        StyledString label = labelProvider.getStyledText((Object)node);
        Assert.assertEquals((Object)name, (Object)label.getString());
        StyledString expectedStyledText = new StyledString();
        expectedStyledText.append("doSomething(ClassName<T> param1, double param2) ");
        expectedStyledText.append(": String", StyledString.DECORATIONS_STYLER);
        this.assertEqualStyles(expectedStyledText, label);
    }

    @Test
    public void testCompleteCallHierarchyItemLabel() {
        String name = "doSomething(int a, String b) : void";
        String detail = "org.eclipse.lsp4e.SomeClass";
        CallHierarchyItem callHierarchyItem = new CallHierarchyItem();
        callHierarchyItem.setName(name);
        callHierarchyItem.setDetail(detail);
        CallHierarchyViewTreeNode node = new CallHierarchyViewTreeNode(callHierarchyItem);
        StyledString label = labelProvider.getStyledText((Object)node);
        Assert.assertEquals((Object)"doSomething(int a, String b) : void - org.eclipse.lsp4e.SomeClass", (Object)label.getString());
        StyledString expectedStyledText = new StyledString();
        expectedStyledText.append("doSomething(int a, String b) ");
        expectedStyledText.append(": void", StyledString.DECORATIONS_STYLER);
        expectedStyledText.append(" - org.eclipse.lsp4e.SomeClass", StyledString.QUALIFIER_STYLER);
        this.assertEqualStyles(expectedStyledText, label);
    }

    private void assertEqualStyles(StyledString expectedStyledText, StyledString actualStyledText) {
        Assert.assertEquals((long)expectedStyledText.getStyleRanges().length, (long)actualStyledText.getStyleRanges().length);
        int i = 0;
        while (i < expectedStyledText.getStyleRanges().length) {
            StyleRange expected = expectedStyledText.getStyleRanges()[i];
            StyleRange actual = actualStyledText.getStyleRanges()[i];
            Assert.assertEquals((Object)expected, (Object)actual);
            ++i;
        }
    }
}

