/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.completion;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.lsp4e.operations.completion.LSCompletionProposal;
import org.eclipse.lsp4e.test.completion.AbstractCompletionTest;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.ui.PartInitException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class VariableReplacementTest
extends AbstractCompletionTest {
    @Test
    public void testDuplicateVariable() throws PartInitException, CoreException {
        CompletionItem completionItem = this.createCompletionItem("${1:foo} and ${1:foo}", CompletionItemKind.Class, new Range(new Position(0, 0), new Position(0, 1)));
        completionItem.setInsertTextFormat(InsertTextFormat.Snippet);
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(true, List.of(completionItem)));
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, ""));
        int invokeOffset = 0;
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, invokeOffset);
        Assertions.assertEquals((int)1, (int)proposals.length);
        ((LSCompletionProposal)proposals[0]).apply(viewer.getDocument());
        Assertions.assertEquals((Object)"foo and foo", (Object)viewer.getDocument().get());
    }

    @Test
    public void testVariableReplacement() throws PartInitException, CoreException {
        CompletionItem completionItem = this.createCompletionItem("${1:$TM_FILENAME_BASE} ${2:$TM_FILENAME} ${3:$TM_FILEPATH} ${4:$TM_DIRECTORY} ${5:$TM_LINE_INDEX} ${6:$TM_LINE_NUMBER} ${7:$TM_CURRENT_LINE} ${8:$TM_SELECTED_TEXT}", CompletionItemKind.Class, new Range(new Position(0, 0), new Position(0, 1)));
        completionItem.setInsertTextFormat(InsertTextFormat.Snippet);
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(true, List.of(completionItem)));
        String content = "line1\nline2\nline3";
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "line1\nline2\nline3");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        int invokeOffset = 0;
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, invokeOffset);
        Assertions.assertEquals((int)1, (int)proposals.length);
        viewer.setSelectedRange(2, 3);
        ((LSCompletionProposal)proposals[0]).apply(viewer, '\u0000', 0, 0);
        String fileNameBase = testFile.getFullPath().removeFileExtension().lastSegment();
        String filePath = testFile.getRawLocation().toOSString();
        String fileDir = this.project.getLocation().toOSString();
        Assertions.assertEquals((Object)String.format("%s %s %s %s %d %d %s %s%s", fileNameBase, testFile.getName(), filePath, fileDir, 0, 1, "line1", "ne1", "line1\nline2\nline3".substring(1)), (Object)viewer.getDocument().get());
    }

    @Test
    public void testVariableNameWithoutBraces() throws PartInitException, CoreException {
        CompletionItem completionItem = this.createCompletionItem("$TM_FILENAME_BASE", CompletionItemKind.Class, new Range(new Position(0, 0), new Position(0, 1)));
        completionItem.setInsertTextFormat(InsertTextFormat.Snippet);
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(true, List.of(completionItem)));
        String content = "line1\nline2\nline3";
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "line1\nline2\nline3");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        int invokeOffset = 0;
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, invokeOffset);
        Assertions.assertEquals((int)1, (int)proposals.length);
        ((LSCompletionProposal)proposals[0]).apply(viewer.getDocument());
        String fileNameBase = testFile.getFullPath().removeFileExtension().lastSegment();
        Assertions.assertEquals((Object)(fileNameBase + "ine1\nline2\nline3"), (Object)viewer.getDocument().get());
    }

    @Test
    public void testVariableNameWithBraces() throws PartInitException, CoreException {
        CompletionItem completionItem = this.createCompletionItem("${TM_FILENAME_BASE}", CompletionItemKind.Class, new Range(new Position(0, 0), new Position(0, 1)));
        completionItem.setInsertTextFormat(InsertTextFormat.Snippet);
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(true, List.of(completionItem)));
        String content = "line1\nline2\nline3";
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "line1\nline2\nline3");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        int invokeOffset = 0;
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, invokeOffset);
        Assertions.assertEquals((int)1, (int)proposals.length);
        ((LSCompletionProposal)proposals[0]).apply(viewer.getDocument());
        String fileNameBase = testFile.getFullPath().removeFileExtension().lastSegment();
        Assertions.assertEquals((Object)(fileNameBase + "ine1\nline2\nline3"), (Object)viewer.getDocument().get());
    }
}

