/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.properties;

import java.text.MessageFormat;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.uml.domain.services.IEditableChecker;
import org.eclipse.papyrus.uml.domain.services.properties.ILogger;
import org.eclipse.papyrus.uml.domain.services.properties.MultiplicityParser;
import org.eclipse.papyrus.uml.domain.services.properties.PropertiesCrudServices;
import org.eclipse.uml2.uml.LiteralUnlimitedNatural;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

public class PropertiesMultiplicityServices {
    private static final String LOWER_VALUE_FEATURE_NAME = UMLPackage.eINSTANCE.getMultiplicityElement_LowerValue().getName();
    private static final String UPPER_VALUE_FEATURE_NAME = UMLPackage.eINSTANCE.getMultiplicityElement_UpperValue().getName();
    private static final String LITERAL_UNLIMITED_NATURAL_ECLASSIFIER_NAME = UMLPackage.eINSTANCE.getLiteralUnlimitedNatural().getName();
    private static final String LITERAL_INTEGER_ECLASSIFIER_NAME = UMLPackage.eINSTANCE.getLiteralInteger().getName();
    private static final String VALUE = "value";
    private final PropertiesCrudServices propertiesSetterServices;
    private ILogger logger;

    public PropertiesMultiplicityServices(ILogger logger, IEditableChecker checker) {
        this.logger = logger;
        this.propertiesSetterServices = new PropertiesCrudServices(logger, checker);
    }

    public String getMultiplicity(EObject target) {
        String multiplicityStringValue = "";
        if (target instanceof MultiplicityElement) {
            MultiplicityElement multiplicityElement = (MultiplicityElement)target;
            int lower = multiplicityElement.lowerBound();
            int upper = multiplicityElement.upperBound();
            multiplicityStringValue = MultiplicityParser.getMultiplicity(lower, upper);
        }
        return multiplicityStringValue;
    }

    public boolean setMultiplicity(MultiplicityElement target, String valueToSet) {
        boolean isSet = false;
        if (this.checkMultiplicityValue(valueToSet)) {
            this.propertiesSetterServices.delete(target.getLowerValue(), (EObject)target, LOWER_VALUE_FEATURE_NAME);
            this.propertiesSetterServices.delete(target.getUpperValue(), (EObject)target, UPPER_VALUE_FEATURE_NAME);
            int[] bounds = MultiplicityParser.getBounds(valueToSet);
            EObject lowerValue = this.propertiesSetterServices.create((EObject)target, LITERAL_INTEGER_ECLASSIFIER_NAME, LOWER_VALUE_FEATURE_NAME);
            EObject upperValue = this.propertiesSetterServices.create((EObject)target, LITERAL_UNLIMITED_NATURAL_ECLASSIFIER_NAME, UPPER_VALUE_FEATURE_NAME);
            boolean lowerSet = this.propertiesSetterServices.set(lowerValue, VALUE, bounds[0]);
            boolean upperSet = this.propertiesSetterServices.set(upperValue, VALUE, bounds[1]);
            isSet = lowerSet && upperSet;
        } else {
            this.logger.log(MessageFormat.format("''{0}'' is not a valid multiplicity value", valueToSet), ILogger.ILogLevel.ERROR);
            ValueSpecification upperValue = target.getUpperValue();
            if (upperValue != null) {
                EStructuralFeature structuralFeature = upperValue.eClass().getEStructuralFeature(VALUE);
                if (structuralFeature != null) {
                    int oldUpper = target.upperBound();
                    upperValue.eSet(structuralFeature, (Object)0);
                    upperValue.eSet(structuralFeature, (Object)oldUpper);
                }
            } else {
                EClass lUNClass = UMLPackage.eINSTANCE.getLiteralUnlimitedNatural();
                LiteralUnlimitedNatural literalUnlimitedNatural = (LiteralUnlimitedNatural)UMLFactory.eINSTANCE.create(lUNClass);
                target.setUpperValue((ValueSpecification)literalUnlimitedNatural);
                target.setUpperValue(null);
            }
        }
        return isSet;
    }

    private boolean checkMultiplicityValue(String newValue) {
        boolean result = newValue instanceof String ? MultiplicityParser.isValidMultiplicity(newValue) : false;
        return result;
    }
}

