/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.dev.tools.dialog;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.papyrus.model2doc.dev.tools.messages.Messages;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.DocumentTemplatePrototype;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewDocumentPrototypeDialog
extends Dialog {
    private Text fileName;
    private Text documentPrototypeDescription;
    private Text documentPrototypeType;
    private Text documentPrototypeIconPath;
    private Text documentTemplateDescription;
    private Text documentTemplateKindId;
    private DocumentTemplatePrototype editedPrototype;
    private String definedFileName = "newDocumentPrototypeFile";

    public NewDocumentPrototypeDialog(Shell parent, DocumentTemplatePrototype editedPrototype) {
        super(parent);
        Assert.isNotNull((Object)editedPrototype);
        Assert.isNotNull((Object)editedPrototype.getDocumentTemplate());
        this.editedPrototype = editedPrototype;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        Label message = new Label(container, 0);
        message.setText(Messages.NewDocumentPrototypeDialog_TheseFileAreMandatory);
        this.createFileGroup(container);
        this.createDocumentPrototypeGroup(container);
        this.createDocumentTemplateGroup(container);
        return container;
    }

    private void createFileGroup(Composite parent) {
        Group fileGrp = new Group(parent, 0);
        fileGrp.setText(Messages.NewDocumentPrototypeDialog_File);
        GridData data = new GridData(4, 1, true, true);
        fileGrp.setLayoutData((Object)data);
        fileGrp.setLayout((Layout)new GridLayout(2, false));
        Label fileNameLabel = new Label((Composite)fileGrp, 0);
        fileNameLabel.setText(Messages.NewDocumentPrototypeDialog_FileName);
        this.fileName = new Text((Composite)fileGrp, 2048);
        this.fileName.setText(this.definedFileName);
        data = new GridData(4, 1, true, true);
        this.fileName.setLayoutData((Object)data);
    }

    private void createDocumentPrototypeGroup(Composite parent) {
        Group grp = new Group(parent, 0);
        grp.setText("DocumentPrototype");
        GridData data = new GridData(4, 1, true, true);
        grp.setLayoutData((Object)data);
        grp.setLayout((Layout)new GridLayout(2, false));
        Label typeLabel = new Label((Composite)grp, 0);
        typeLabel.setText(Messages.NewDocumentPrototypeDialog_Type);
        typeLabel.setToolTipText(Messages.NewDocumentPrototypeDialog_TypeExampleMessage);
        this.documentPrototypeType = new Text((Composite)grp, 2048);
        data = new GridData(4, 1, true, true);
        this.documentPrototypeType.setLayoutData((Object)data);
        Label iconLabel = new Label((Composite)grp, 0);
        iconLabel.setText(Messages.NewDocumentPrototypeDialog_IconPath);
        this.documentPrototypeIconPath = new Text((Composite)grp, 2048);
        data = new GridData(4, 1, true, true);
        this.documentPrototypeIconPath.setLayoutData((Object)data);
        if (this.editedPrototype.getIconPath() != null) {
            this.documentPrototypeIconPath.setText(this.editedPrototype.getIconPath());
        }
        Label descriptionLabel = new Label((Composite)grp, 0);
        descriptionLabel.setText(Messages.NewDocumentPrototypeDialog_DocumentPrototypeDescription);
        this.documentPrototypeDescription = new Text((Composite)grp, 2048);
        data = new GridData(4, 1, true, true);
        this.documentPrototypeDescription.setLayoutData((Object)data);
    }

    private void createDocumentTemplateGroup(Composite parent) {
        Group grp = new Group(parent, 0);
        grp.setText("DocumentTemplate");
        GridData data = new GridData(4, 1, true, true);
        grp.setLayoutData((Object)data);
        grp.setLayout((Layout)new GridLayout(2, false));
        Label typeLabel = new Label((Composite)grp, 0);
        typeLabel.setText("Kind Id*");
        typeLabel.setToolTipText(Messages.NewDocumentPrototypeDialog_KindIdExample);
        this.documentTemplateKindId = new Text((Composite)grp, 2048);
        data = new GridData(4, 1, true, true);
        this.documentTemplateKindId.setLayoutData((Object)data);
        Label descriptionLabel = new Label((Composite)grp, 0);
        descriptionLabel.setText(Messages.NewDocumentPrototypeDialog_DocumentTemplateDescription);
        this.documentTemplateDescription = new Text((Composite)grp, 2048);
        data = new GridData(4, 1, true, true);
        this.documentTemplateDescription.setLayoutData((Object)data);
        if (this.editedPrototype.getDocumentTemplate().getDescription() != null) {
            this.documentTemplateDescription.setText(this.editedPrototype.getDocumentTemplate().getDescription());
        }
    }

    public String getFileName() {
        return this.definedFileName;
    }

    protected void okPressed() {
        if (this.fileName.getText() != null && !this.fileName.getText().isEmpty()) {
            this.definedFileName = this.fileName.getText();
        }
        this.editedPrototype.setDescription(this.documentPrototypeDescription.getText());
        this.editedPrototype.setIconPath(this.documentPrototypeIconPath.getText());
        this.editedPrototype.setType(this.documentPrototypeType.getText());
        this.editedPrototype.getDocumentTemplate().setDescription(this.documentTemplateDescription.getText());
        this.editedPrototype.getDocumentTemplate().setKindId(this.documentTemplateKindId.getText());
        super.okPressed();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.NewDocumentPrototypeDialog_DialogName);
    }

    protected Point getInitialSize() {
        return new Point(600, 400);
    }
}

