/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.emf.template2structure.helpers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.DocumentTemplate;
import org.eclipse.papyrus.model2doc.emf.template2structure.Activator;

public class DocumentStructureVersionHelper {
    private static final String PROPERTIES_FILE_EXTENSION = "versions";
    private static final String VERSION_FILE_NAME = "LastGeneratedDocumentVersion";
    private static final String MODEL2DOC_PREFERENCE_FOLDER_NAME = "model2doc";
    private final DocumentTemplate docTemplate;

    public DocumentStructureVersionHelper(DocumentTemplate docTemplate) {
        this.docTemplate = docTemplate;
    }

    public String getDocumentVersion() {
        return "";
    }

    protected final String getPreviousGeneratedVersion() {
        String xmiID = DocumentStructureVersionHelper.getXMI_ID((EObject)this.docTemplate);
        if (xmiID == null) {
            return "";
        }
        File f = this.getVersionFile();
        String lastVersion = "";
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileInputStream input = new FileInputStream(f);){
                Properties prop = new Properties();
                prop.load(input);
                lastVersion = prop.getProperty(xmiID);
                ((InputStream)input).close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException io) {
            Activator.log.error((Throwable)io);
        }
        return lastVersion;
    }

    public final void saveLastGeneratedDocumentVersion(String version) {
        String xmiID = DocumentStructureVersionHelper.getXMI_ID((EObject)this.docTemplate);
        if (xmiID == null) {
            return;
        }
        File f = this.getVersionFile();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileOutputStream output = new FileOutputStream(f);){
                Properties prop = new Properties();
                prop.setProperty(xmiID, version);
                prop.store(output, null);
                ((OutputStream)output).close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException io) {
            Activator.log.error((Throwable)io);
        }
    }

    private static String getXMI_ID(EObject eobject) {
        if (eobject.eResource() instanceof XMIResource) {
            return ((XMIResource)eobject.eResource()).getID(eobject);
        }
        return null;
    }

    private File getVersionFile() {
        File f;
        IPath preferencePath = Activator.getDefault().getStateLocation();
        preferencePath.append(MODEL2DOC_PREFERENCE_FOLDER_NAME);
        File folder = preferencePath.toFile();
        if (!folder.exists()) {
            folder.mkdirs();
        }
        if (!(f = (preferencePath = preferencePath.append(VERSION_FILE_NAME).addFileExtension(PROPERTIES_FILE_EXTENSION)).toFile()).exists()) {
            try {
                f.createNewFile();
            }
            catch (IOException e) {
                Activator.log.error((Throwable)e);
            }
        }
        return f;
    }
}

