/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.uml.documentstructuretemplate;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum StereotypeFilterBehavior implements Enumerator
{
    STEREOTYPE_TYPE_OF(0, "STEREOTYPE_TYPE_OF", "STEREOTYPE_TYPE_OF"),
    STEREOTYPE_KIND_OF(1, "STEREOTYPE_KIND_OF", "STEREOTYPE_KIND_OF");

    public static final int STEREOTYPE_TYPE_OF_VALUE = 0;
    public static final int STEREOTYPE_KIND_OF_VALUE = 1;
    private static final StereotypeFilterBehavior[] VALUES_ARRAY;
    public static final List<StereotypeFilterBehavior> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new StereotypeFilterBehavior[]{STEREOTYPE_TYPE_OF, STEREOTYPE_KIND_OF};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static StereotypeFilterBehavior get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            StereotypeFilterBehavior result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static StereotypeFilterBehavior getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            StereotypeFilterBehavior result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static StereotypeFilterBehavior get(int value) {
        switch (value) {
            case 0: {
                return STEREOTYPE_TYPE_OF;
            }
            case 1: {
                return STEREOTYPE_KIND_OF;
            }
        }
        return null;
    }

    private StereotypeFilterBehavior(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

