/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.docx.internal.util;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.poi.util.Units;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.eclipse.papyrus.model2doc.docx.Activator;

public class ImageUtils {
    private static final int PAGE_WIDTH = 450;
    private static final int PAGE_HEIGHT = 700;

    public static final int[] getImageSize(String imagePath, XWPFDocument document) {
        int[] result = new int[2];
        File f = new File(imagePath);
        try {
            BufferedImage image = ImageIO.read(f);
            int imageWidth = image.getWidth();
            int imageHeight = image.getHeight();
            if (imageWidth <= 450 && imageWidth <= 700) {
                result[0] = imageWidth;
                result[1] = imageHeight;
            } else if (imageWidth >= 450) {
                result[0] = 450;
                result[1] = 450 * imageHeight / imageWidth;
                if (result[1] > 700) {
                    imageWidth = result[0];
                    imageHeight = result[1];
                    result[0] = 700 * imageWidth / imageHeight;
                    result[1] = 700;
                }
            } else if (imageHeight >= 700) {
                result[0] = 700 * imageWidth / imageHeight;
                result[1] = 700;
                if (result[0] > 450) {
                    imageWidth = result[0];
                    imageHeight = result[1];
                    result[0] = 700 * imageWidth / imageHeight;
                    result[1] = 700;
                }
            }
            result[0] = Units.toEMU((double)result[0]);
            result[1] = Units.toEMU((double)result[1]);
        }
        catch (IOException e) {
            Activator.log.error((Throwable)e);
        }
        return result;
    }
}

