/*****************************************************************************
 * Copyright (c) 2019, 2025 CEA LIST and others.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *  Vincent Lorenzo (CEA LIST) vincent.lorenzo@cea.fr - Initial API and implementation
 *  Vincent Lorenzo (CEA LIST) vincent.lorenzo@cea.fr - Issue GL-9
 *****************************************************************************/

package org.eclipse.papyrus.model2doc.emf.template2structure.mapping;

import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.model2doc.core.logger.IModel2DocLogger;

/**
 * Interface for MappingService
 */
public interface IMappingService {

	/**
	 * @param documentTemplateElement
	 *            a documentTemplateElement for which we want make a mapping
	 * @param semanticModelElement
	 *            an element of the user model
	 * @param expectedReturnedClass
	 *            the return type of the mapping method
	 * @param logger
	 *            the logger used to log the messages during the process
	 * @param <T>
	 *            the return type of the list
	 * @return
	 *         a collection of EObject created by this mapping
	 */
	public <T> List<T> map(final EObject documentTemplateElement, final EObject semanticModelElement, final Class<T> expectedReturnedClass, final IModel2DocLogger logger);
}
