/**
 * Copyright (c) 2023 CEA LIST.
 *
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License 2.0
 *  which accompanies this distribution, and is available at
 *  https://www.eclipse.org/legal/epl-2.0/
 *
 *  SPDX-License-Identifier: EPL-2.0
 *
 *  Contributors:
 *  Vincent Lorenzo (CEA LIST) vincent.lorenzo@cea.fr - Initial API and implementation
 */
package org.eclipse.papyrus.model2doc.markup.uml.documentstructuretemplate.util;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.util.Switch;

import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.IBodyPartTemplate;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.IBodySectionPartTemplate;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.ILeafBodyPartTemplate;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.ITemplatePartView;

import org.eclipse.papyrus.model2doc.markup.emf.documentstructuretemplate.IMarkupToFileBodyPartTemplate;

import org.eclipse.papyrus.model2doc.markup.uml.documentstructuretemplate.*;

import org.eclipse.papyrus.model2doc.uml.documentstructuretemplate.IUMLBodyPartTemplateTitle;
import org.eclipse.papyrus.model2doc.uml.documentstructuretemplate.StereotypePropertyAttribute;
import org.eclipse.papyrus.model2doc.uml.documentstructuretemplate.StereotypePropertyTemplate;
import org.eclipse.papyrus.model2doc.uml.documentstructuretemplate.StereotypeTemplate;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 *
 * @see org.eclipse.papyrus.model2doc.markup.uml.documentstructuretemplate.MarkupUMLDocumentStructureTemplatePackage
 * @generated
 */
public class MarkupUMLDocumentStructureTemplateSwitch<T> extends Switch<T> {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected static MarkupUMLDocumentStructureTemplatePackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	public MarkupUMLDocumentStructureTemplateSwitch() {
		if (modelPackage == null) {
			modelPackage = MarkupUMLDocumentStructureTemplatePackage.eINSTANCE;
		}
	}

	/**
	 * Checks whether this is a switch for the given package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @param ePackage
	 *            the package in question.
	 * @return whether this is a switch for the given package.
	 * @generated
	 */
	@Override
	protected boolean isSwitchFor(EPackage ePackage) {
		return ePackage == modelPackage;
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	@Override
	protected T doSwitch(int classifierID, EObject theEObject) {
		switch (classifierID) {
		case MarkupUMLDocumentStructureTemplatePackage.STEREOTYPE_PROPERTY_ATTRIBUTE_IN_MARKUP_TO_FILE: {
			StereotypePropertyAttributeInMarkupToFile stereotypePropertyAttributeInMarkupToFile = (StereotypePropertyAttributeInMarkupToFile) theEObject;
			T result = caseStereotypePropertyAttributeInMarkupToFile(stereotypePropertyAttributeInMarkupToFile);
			if (result == null) {
				result = caseStereotypePropertyTemplate(stereotypePropertyAttributeInMarkupToFile);
			}
			if (result == null) {
				result = caseITemplatePartView(stereotypePropertyAttributeInMarkupToFile);
			}
			if (result == null) {
				result = caseStereotypePropertyAttribute(stereotypePropertyAttributeInMarkupToFile);
			}
			if (result == null) {
				result = caseILeafBodyPartTemplate(stereotypePropertyAttributeInMarkupToFile);
			}
			if (result == null) {
				result = caseIMarkupUMLBodyPartTemplateTitle(stereotypePropertyAttributeInMarkupToFile);
			}
			if (result == null) {
				result = caseStereotypeTemplate(stereotypePropertyAttributeInMarkupToFile);
			}
			if (result == null) {
				result = caseIBodyPartTemplate(stereotypePropertyAttributeInMarkupToFile);
			}
			if (result == null) {
				result = caseIMarkupToFileBodyPartTemplate(stereotypePropertyAttributeInMarkupToFile);
			}
			if (result == null) {
				result = caseIUMLBodyPartTemplateTitle(stereotypePropertyAttributeInMarkupToFile);
			}
			if (result == null) {
				result = caseIBodySectionPartTemplate(stereotypePropertyAttributeInMarkupToFile);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case MarkupUMLDocumentStructureTemplatePackage.IMARKUP_UML_BODY_PART_TEMPLATE_TITLE: {
			IMarkupUMLBodyPartTemplateTitle iMarkupUMLBodyPartTemplateTitle = (IMarkupUMLBodyPartTemplateTitle) theEObject;
			T result = caseIMarkupUMLBodyPartTemplateTitle(iMarkupUMLBodyPartTemplateTitle);
			if (result == null) {
				result = caseIMarkupToFileBodyPartTemplate(iMarkupUMLBodyPartTemplateTitle);
			}
			if (result == null) {
				result = caseIUMLBodyPartTemplateTitle(iMarkupUMLBodyPartTemplateTitle);
			}
			if (result == null) {
				result = caseIBodySectionPartTemplate(iMarkupUMLBodyPartTemplateTitle);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case MarkupUMLDocumentStructureTemplatePackage.COMMENT_IN_MARKUP_TO_FILE: {
			CommentInMarkupToFile commentInMarkupToFile = (CommentInMarkupToFile) theEObject;
			T result = caseCommentInMarkupToFile(commentInMarkupToFile);
			if (result == null) {
				result = caseITemplatePartView(commentInMarkupToFile);
			}
			if (result == null) {
				result = caseILeafBodyPartTemplate(commentInMarkupToFile);
			}
			if (result == null) {
				result = caseIMarkupUMLBodyPartTemplateTitle(commentInMarkupToFile);
			}
			if (result == null) {
				result = caseIBodyPartTemplate(commentInMarkupToFile);
			}
			if (result == null) {
				result = caseIMarkupToFileBodyPartTemplate(commentInMarkupToFile);
			}
			if (result == null) {
				result = caseIUMLBodyPartTemplateTitle(commentInMarkupToFile);
			}
			if (result == null) {
				result = caseIBodySectionPartTemplate(commentInMarkupToFile);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		default:
			return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Stereotype Property Attribute In Markup To File</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 *
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Stereotype Property Attribute In Markup To File</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseStereotypePropertyAttributeInMarkupToFile(StereotypePropertyAttributeInMarkupToFile object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>IMarkup UML Body Part Template Title</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 *
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>IMarkup UML Body Part Template Title</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIMarkupUMLBodyPartTemplateTitle(IMarkupUMLBodyPartTemplateTitle object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Comment In Markup To File</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 *
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Comment In Markup To File</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCommentInMarkupToFile(CommentInMarkupToFile object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Stereotype Template</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 *
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Stereotype Template</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseStereotypeTemplate(StereotypeTemplate object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Stereotype Property Template</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 *
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Stereotype Property Template</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseStereotypePropertyTemplate(StereotypePropertyTemplate object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>ITemplate Part View</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 *
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>ITemplate Part View</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseITemplatePartView(ITemplatePartView object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Stereotype Property Attribute</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 *
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Stereotype Property Attribute</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseStereotypePropertyAttribute(StereotypePropertyAttribute object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>IBody Section Part Template</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 *
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>IBody Section Part Template</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIBodySectionPartTemplate(IBodySectionPartTemplate object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>IBody Part Template</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 *
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>IBody Part Template</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIBodyPartTemplate(IBodyPartTemplate object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>ILeaf Body Part Template</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 *
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>ILeaf Body Part Template</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseILeafBodyPartTemplate(ILeafBodyPartTemplate object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>IUML Body Part Template Title</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 *
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>IUML Body Part Template Title</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIUMLBodyPartTemplateTitle(IUMLBodyPartTemplateTitle object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>IMarkup To File Body Part Template</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 *
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>IMarkup To File Body Part Template</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIMarkupToFileBodyPartTemplate(IMarkupToFileBodyPartTemplate object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 *
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	@Override
	public T defaultCase(EObject object) {
		return null;
	}

} // MarkupUMLDocumentStructureTemplateSwitch
