/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.internal.ClientComms;
import org.eclipse.paho.client.mqttv3.internal.ClientState;
import org.eclipse.paho.client.mqttv3.internal.CommsTokenStore;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttAck;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttDisconnect;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttOutputStream;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttWireMessage;
import org.eclipse.paho.client.mqttv3.logging.Logger;
import org.eclipse.paho.client.mqttv3.logging.LoggerFactory;

public class CommsSender
implements Runnable {
    private static final String CLASS_NAME = CommsSender.class.getName();
    private static final Logger log = LoggerFactory.getLogger("org.eclipse.paho.client.mqttv3.internal.nls.logcat", CLASS_NAME);
    private boolean running = false;
    private Object lifecycle = new Object();
    private ClientState clientState = null;
    private MqttOutputStream out;
    private ClientComms clientComms = null;
    private CommsTokenStore tokenStore = null;
    private Thread sendThread = null;
    private String threadName;
    private final Semaphore runningSemaphore = new Semaphore(1);
    private Future senderFuture;

    public CommsSender(ClientComms clientComms, ClientState clientState, CommsTokenStore tokenStore, OutputStream out) {
        this.out = new MqttOutputStream(clientState, out);
        this.clientComms = clientComms;
        this.clientState = clientState;
        this.tokenStore = tokenStore;
        log.setResourceName(clientComms.getClient().getClientId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(String threadName, ExecutorService executorService) {
        this.threadName = threadName;
        Object object = this.lifecycle;
        synchronized (object) {
            if (!this.running) {
                this.running = true;
                this.senderFuture = executorService.submit(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lifecycle;
        synchronized (object) {
            block12: {
                if (this.senderFuture != null) {
                    this.senderFuture.cancel(true);
                }
                log.fine(CLASS_NAME, "stop", "800");
                if (this.running) {
                    this.running = false;
                    if (!Thread.currentThread().equals(this.sendThread)) {
                        try {
                            try {
                                while (this.running) {
                                    this.clientState.notifyQueueLock();
                                    this.runningSemaphore.tryAcquire(100L, TimeUnit.MILLISECONDS);
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                this.runningSemaphore.release();
                                break block12;
                            }
                        }
                        catch (Throwable throwable) {
                            this.runningSemaphore.release();
                            throw throwable;
                        }
                        this.runningSemaphore.release();
                    }
                }
            }
            this.sendThread = null;
            log.fine(CLASS_NAME, "stop", "801");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        this.sendThread = Thread.currentThread();
        this.sendThread.setName(this.threadName);
        message = null;
        try {
            this.runningSemaphore.acquire();
            if (true) ** GOTO lbl44
        }
        catch (InterruptedException v0) {
            this.running = false;
            return;
        }
        {
            do {
                try {
                    message = this.clientState.get();
                    if (message != null) {
                        CommsSender.log.fine(CommsSender.CLASS_NAME, "run", "802", new Object[]{message.getKey(), message});
                        if (message instanceof MqttAck) {
                            this.out.write(message);
                            this.out.flush();
                            continue;
                        }
                        token = this.tokenStore.getToken(message);
                        if (token == null) continue;
                        var3_5 = token;
                        synchronized (var3_5) {
                            block14: {
                                this.out.write(message);
                                try {
                                    this.out.flush();
                                }
                                catch (IOException ex) {
                                    if (message instanceof MqttDisconnect) break block14;
                                    throw ex;
                                }
                            }
                            this.clientState.notifySent(message);
                            continue;
                        }
                    }
                    CommsSender.log.fine(CommsSender.CLASS_NAME, "run", "803");
                    this.running = false;
                }
                catch (MqttException me) {
                    this.handleRunException(message, me);
                }
                catch (Exception ex) {
                    this.handleRunException(message, ex);
                }
lbl44:
                // 7 sources

            } while (this.running && this.out != null);
        }
        this.running = false;
        this.runningSemaphore.release();
        CommsSender.log.fine(CommsSender.CLASS_NAME, "run", "805");
    }

    private void handleRunException(MqttWireMessage message, Exception ex) {
        log.fine(CLASS_NAME, "handleRunException", "804", null, ex);
        MqttException mex = !(ex instanceof MqttException) ? new MqttException(32109, (Throwable)ex) : (MqttException)ex;
        this.running = false;
        this.clientComms.shutdownConnection(null, mex);
    }
}

