/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal.websocket;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.nio.ByteBuffer;
import javax.net.SocketFactory;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.internal.TCPNetworkModule;
import org.eclipse.paho.client.mqttv3.internal.websocket.ExtendedByteArrayOutputStream;
import org.eclipse.paho.client.mqttv3.internal.websocket.WebSocketFrame;
import org.eclipse.paho.client.mqttv3.internal.websocket.WebSocketHandshake;
import org.eclipse.paho.client.mqttv3.internal.websocket.WebSocketReceiver;
import org.eclipse.paho.client.mqttv3.logging.Logger;
import org.eclipse.paho.client.mqttv3.logging.LoggerFactory;

public class WebSocketNetworkModule
extends TCPNetworkModule {
    private static final String CLASS_NAME = WebSocketNetworkModule.class.getName();
    private static final Logger log = LoggerFactory.getLogger("org.eclipse.paho.client.mqttv3.internal.nls.logcat", CLASS_NAME);
    private String uri;
    private String host;
    private int port;
    private PipedInputStream pipedInputStream;
    private WebSocketReceiver webSocketReceiver;
    ByteBuffer recievedPayload;
    private ByteArrayOutputStream outputStream = new ExtendedByteArrayOutputStream(this);

    public WebSocketNetworkModule(SocketFactory factory, String uri, String host, int port, String resourceContext) {
        super(factory, host, port, resourceContext);
        this.uri = uri;
        this.host = host;
        this.port = port;
        this.pipedInputStream = new PipedInputStream();
        log.setResourceName(resourceContext);
    }

    @Override
    public void start() throws IOException, MqttException {
        super.start();
        WebSocketHandshake handshake = new WebSocketHandshake(this.getSocketInputStream(), this.getSocketOutputStream(), this.uri, this.host, this.port);
        handshake.execute();
        this.webSocketReceiver = new WebSocketReceiver(this.getSocketInputStream(), this.pipedInputStream);
        this.webSocketReceiver.start("webSocketReceiver");
    }

    OutputStream getSocketOutputStream() throws IOException {
        return super.getOutputStream();
    }

    InputStream getSocketInputStream() throws IOException {
        return super.getInputStream();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.pipedInputStream;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.outputStream;
    }

    @Override
    public void stop() throws IOException {
        WebSocketFrame frame = new WebSocketFrame(8, true, "1000".getBytes());
        byte[] rawFrame = frame.encodeFrame();
        this.getSocketOutputStream().write(rawFrame);
        this.getSocketOutputStream().flush();
        if (this.webSocketReceiver != null) {
            this.webSocketReceiver.stop();
        }
        super.stop();
    }

    @Override
    public String getServerURI() {
        return "ws://" + this.host + ":" + this.port;
    }
}

