/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fuml.activities;

import java.util.List;
import org.eclipse.papyrus.moka.fuml.activities.ActivityNodeActivationGroup;
import org.eclipse.papyrus.moka.fuml.activities.IActivityExecution;
import org.eclipse.papyrus.moka.fuml.activities.IActivityNodeActivationGroup;
import org.eclipse.papyrus.moka.fuml.activities.IActivityParameterNodeActivation;
import org.eclipse.papyrus.moka.fuml.activities.IToken;
import org.eclipse.papyrus.moka.fuml.activities.ObjectToken;
import org.eclipse.papyrus.moka.fuml.commonbehavior.Execution;
import org.eclipse.papyrus.moka.fuml.commonbehavior.ParameterValue;
import org.eclipse.papyrus.moka.fuml.debug.Debug;
import org.eclipse.papyrus.moka.fuml.simpleclassifiers.IValue;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityParameterNode;

public class ActivityExecution
extends Execution
implements IActivityExecution {
    public IActivityNodeActivationGroup activationGroup;

    @Override
    public void execute() {
        Activity activity = (Activity)this.getTypes().get(0);
        Debug.println("[execute] Activity " + activity.getName() + "...");
        Debug.println("[event] Execute activity=" + activity.getName());
        this.activationGroup = new ActivityNodeActivationGroup();
        this.activationGroup.setActivityExecution_((IActivityExecution)this);
        this.activationGroup.activate((List)activity.getNodes(), (List)activity.getEdges());
        List outputActivations = this.activationGroup.getOutputParameterNodeActivations();
        int i = 0;
        while (i < outputActivations.size()) {
            IActivityParameterNodeActivation outputActivation = (IActivityParameterNodeActivation)outputActivations.get(i);
            ParameterValue parameterValue = new ParameterValue();
            parameterValue.parameter = ((ActivityParameterNode)outputActivation.getNode()).getParameter();
            List tokens = outputActivation.getTokens();
            int j = 0;
            while (j < tokens.size()) {
                IToken token = (IToken)tokens.get(j);
                IValue value = ((ObjectToken)token).value;
                if (value != null) {
                    parameterValue.values.add(value);
                    Debug.println("[event] Output activity=" + activity.getName() + " parameter=" + parameterValue.parameter.getName() + " value=" + value);
                }
                ++j;
            }
            this.setParameterValue(parameterValue);
            ++i;
        }
        Debug.println("[execute] Activity " + activity.getName() + " completed.");
    }

    @Override
    public IValue copy() {
        return super.copy();
    }

    @Override
    public IValue new_() {
        return new ActivityExecution();
    }

    @Override
    public void terminate() {
        if (this.activationGroup != null) {
            this.activationGroup.terminateAll();
        }
    }

    public void setGroup(IActivityNodeActivationGroup group) {
        this.activationGroup = group;
    }

    public IActivityNodeActivationGroup getGroup() {
        return this.activationGroup;
    }
}

