/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.pscs.classification;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.moka.fuml.classification.InstanceValueEvaluation;
import org.eclipse.papyrus.moka.fuml.debug.Debug;
import org.eclipse.papyrus.moka.fuml.simpleclassifiers.DataValue;
import org.eclipse.papyrus.moka.fuml.simpleclassifiers.EnumerationValue;
import org.eclipse.papyrus.moka.fuml.simpleclassifiers.IValue;
import org.eclipse.papyrus.moka.fuml.structuredclassifiers.IExtensionalValue;
import org.eclipse.papyrus.moka.fuml.structuredclassifiers.Reference;
import org.eclipse.papyrus.moka.pscs.structuredclassifiers.CS_Object;
import org.eclipse.papyrus.moka.pscs.structuredclassifiers.CS_Reference;
import org.eclipse.papyrus.moka.pscs.structuredclassifiers.ICS_Object;
import org.eclipse.papyrus.moka.pscs.structuredclassifiers.ICS_Reference;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.ValueSpecification;

public class CS_InstanceValueEvaluation
extends InstanceValueEvaluation {
    public IValue evaluate() {
        EnumerationValue value;
        InstanceSpecification instance = ((InstanceValue)this.specification).getInstance();
        EList types = instance.getClassifiers();
        Classifier myType = (Classifier)types.get(0);
        Debug.println((String)("[evaluate] type = " + myType.getName()));
        if (instance instanceof EnumerationLiteral) {
            EnumerationValue enumerationValue = new EnumerationValue();
            enumerationValue.type = (Enumeration)myType;
            enumerationValue.literal = (EnumerationLiteral)instance;
            value = enumerationValue;
        } else {
            Object structuredValue = null;
            if (myType instanceof DataType) {
                DataValue dataValue = new DataValue();
                dataValue.type = (DataType)myType;
                structuredValue = dataValue;
            } else {
                CS_Reference reference;
                CS_Object object = null;
                if (myType instanceof Behavior) {
                    object = this.locus.getFactory().createExecution((Behavior)myType, null);
                } else {
                    object = new CS_Object();
                    int i = 0;
                    while (i < types.size()) {
                        Classifier type = (Classifier)types.get(i);
                        object.addType((Class)type);
                        ++i;
                    }
                }
                this.locus.add((IExtensionalValue)object);
                if (object instanceof ICS_Object) {
                    reference = new CS_Reference();
                    ((ICS_Reference)reference).setCompositeReferent((ICS_Object)object);
                } else {
                    reference = new Reference();
                }
                reference.referent = object;
                structuredValue = reference;
            }
            structuredValue.createFeatureValues();
            EList instanceSlots = instance.getSlots();
            int i = 0;
            while (i < instanceSlots.size()) {
                Slot slot = (Slot)instanceSlots.get(i);
                ArrayList<IValue> values = new ArrayList<IValue>();
                EList slotValues = slot.getValues();
                int j = 0;
                while (j < slotValues.size()) {
                    ValueSpecification slotValue = (ValueSpecification)slotValues.get(j);
                    values.add(this.locus.getExecutor().evaluate(slotValue));
                    ++j;
                }
                structuredValue.setFeatureValue(slot.getDefiningFeature(), values, Integer.valueOf(0));
                ++i;
            }
            value = structuredValue;
        }
        return value;
    }
}

