/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.security.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.cdo.security.Directory;
import org.eclipse.emf.cdo.security.Group;
import org.eclipse.emf.cdo.security.Realm;
import org.eclipse.emf.cdo.security.Role;
import org.eclipse.emf.cdo.security.SecurityFactory;
import org.eclipse.emf.cdo.security.User;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.cdo.security.internal.ui.CDOUserDialog;
import org.eclipse.papyrus.infra.ui.util.SelectionHelper;
import org.eclipse.swt.widgets.Display;

public class CreateUserHandler
extends AbstractHandler {
    private static final String HOME_FOLDER_ROLE_NAME = "Home Folder /home";
    protected final boolean editUserAfterRegistration;

    public CreateUserHandler() {
        this(true);
    }

    public CreateUserHandler(boolean editUserAfterCreation) {
        this.editUserAfterRegistration = editUserAfterCreation;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        User user = SecurityFactory.eINSTANCE.createUser();
        this.registerUser(user);
        return null;
    }

    protected void registerUser(User user) {
        Realm realm = CreateUserHandler.getRealm();
        this.attachUserToUserGroup(realm, user);
        this.initUser(realm, user);
        if (this.editUserAfterRegistration) {
            CDOUserDialog d = new CDOUserDialog(Display.getDefault().getActiveShell(), user);
            d.open();
        }
    }

    protected void attachUserToUserGroup(Realm realm, User user) {
        Directory userDirectory = realm.getDefaultUserDirectory();
        userDirectory.getItems().add((Object)user);
    }

    protected final void initUser(Realm realm, User user) {
        Directory roleDirectory = realm.getDefaultRoleDirectory();
        Role homeFolder = roleDirectory.getRole(HOME_FOLDER_ROLE_NAME);
        Role allObjectsReader = roleDirectory.getRole("All Objects Reader");
        Role resourceTreeReaderRole = roleDirectory.getRole("Resource Tree Reader");
        Group userGroup = realm.getGroup("Users");
        userGroup.getUsers().add((Object)user);
        user.getRoles().add((Object)homeFolder);
        user.getRoles().add((Object)allObjectsReader);
        user.getRoles().add((Object)resourceTreeReaderRole);
    }

    protected static final Realm getRealm() {
        IStructuredSelection service = SelectionHelper.getCurrentStructuredSelection();
        Object first = service.getFirstElement();
        if (first instanceof Realm) {
            return ((Realm)first).getRealm();
        }
        if (first instanceof Directory) {
            return ((Directory)first).getRealm();
        }
        if (first instanceof User) {
            return ((User)first).getRealm();
        }
        return null;
    }

    public void setEnabled(Object evaluationContext) {
        this.setBaseEnabled(CreateUserHandler.allowCreation());
    }

    public static boolean allowCreation() {
        Realm realm = CreateUserHandler.getRealm();
        if (realm == null) {
            return false;
        }
        if (realm.getDefaultGroupDirectory() == null) {
            return false;
        }
        Directory roleDirectory = realm.getDefaultRoleDirectory();
        if (roleDirectory == null) {
            return false;
        }
        if (roleDirectory.getRole(HOME_FOLDER_ROLE_NAME) == null) {
            return false;
        }
        if (roleDirectory.getRole("All Objects Reader") == null) {
            return false;
        }
        return roleDirectory.getRole("Resource Tree Reader") != null;
    }
}

