/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.hyperlink;

import java.util.List;
import org.eclipse.emf.cdo.eresource.CDOFileResource;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.eresource.util.EresourceSwitch;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.explorer.ui.checkouts.CDOCheckoutContentProvider;
import org.eclipse.emf.cdo.explorer.ui.checkouts.actions.OpenWithActionProvider;
import org.eclipse.emf.cdo.ui.CDOEditorUtil;
import org.eclipse.emf.cdo.util.CDOURIUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.cdo.internal.ui.hyperlink.CDOResourceHyperlinkEditorShell;
import org.eclipse.papyrus.cdo.internal.ui.hyperlink.Messages;
import org.eclipse.papyrus.cdo.internal.ui.views.DIResourceQuery;
import org.eclipse.papyrus.infra.hyperlink.Activator;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkObject;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class CDOResourceHyperlink
extends HyperLinkObject {
    public URI getHyperlink() {
        return (URI)super.getObject();
    }

    public void setHyperlink(URI uri) {
        super.setObject((Object)uri);
    }

    public void openLink() {
        try {
            URI uri = this.getHyperlink();
            CDOCheckout checkout = CDOExplorerUtil.getCheckout((Object)uri);
            if (checkout == null) {
                MessageDialog.openError((Shell)UIUtil.getActiveWorkbenchWindow().getShell(), (String)Messages.CDOResourceHyperlink_openError, (String)Messages.CDOResourceHyperlink_notConnected);
            } else if (!checkout.isOpen()) {
                checkout.open();
                if (!checkout.isOpen()) {
                    MessageDialog.openError((Shell)UIUtil.getActiveWorkbenchWindow().getShell(), (String)Messages.CDOResourceHyperlink_openError, (String)Messages.CDOResourceHyperlink_notConnected);
                }
            }
            if (checkout != null && checkout.isOpen()) {
                String path;
                CDOView master = checkout.getView();
                if (!master.hasResource(path = CDOURIUtil.extractResourcePath((URI)uri))) {
                    MessageDialog.openError((Shell)UIUtil.getActiveWorkbenchWindow().getShell(), (String)Messages.CDOResourceHyperlink_openError, (String)NLS.bind((String)Messages.CDOResourceHyperlink_noSuchResource, (Object)path));
                } else {
                    CDOResourceNode node = master.getResourceNode(path);
                    this.openResource(node);
                }
            }
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
    }

    protected void openResource(CDOResourceNode node) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        final IWorkbenchPage page = window.getActivePage();
        new EresourceSwitch<Void>(){

            public <IO> Void caseCDOFileResource(CDOFileResource<IO> object) {
                CDOEditorUtil.openEditor((IWorkbenchPage)page, object);
                return null;
            }

            public Void caseCDOResource(CDOResource object) {
                if (object.isRoot()) {
                    CDOCheckout checkout = CDOExplorerUtil.getCheckout((Object)object.getURI());
                    CDOCheckoutContentProvider contentProvider = CDOCheckoutContentProvider.getInstance((String)"org.eclipse.ui.navigator.ProjectExplorer");
                    if (contentProvider != null) {
                        contentProvider.selectObjects(new Object[]{checkout});
                    }
                } else {
                    CDOResource diResource = DIResourceQuery.getAffiliateResource((CDOResource)object);
                    if (diResource == null) {
                        OpenWithActionProvider.openEditor((IWorkbenchPage)page, null, (EObject)object, null);
                    } else {
                        OpenWithActionProvider.openEditor((IWorkbenchPage)page, null, (EObject)diResource, (String)"org.eclipse.papyrus.cdo.ui.editors.PapyrusCDOEditorOpener");
                    }
                }
                return null;
            }
        }.doSwitch((EObject)node);
    }

    public void executeEditMousePressed(Shell parentShell, List<HyperLinkObject> list, EObject aModel) {
        CDOResourceHyperlinkEditorShell editor = new CDOResourceHyperlinkEditorShell(parentShell);
        editor.setHyperlink(this);
        if (editor.open() == 0) {
            int index = list.indexOf((Object)this);
            list.set(index, editor.getHyperlink());
        }
    }

    public boolean needsOpenCommand() {
        return false;
    }
}

