/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.dialogs;

import com.google.common.base.Strings;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.util.CDOURIUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewInvalidationEvent;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.ui.views.IElementFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.cdo.internal.core.CDOUtils;
import org.eclipse.papyrus.cdo.internal.ui.l10n.Messages;
import org.eclipse.papyrus.cdo.internal.ui.util.UIUtil;
import org.eclipse.papyrus.cdo.internal.ui.views.CheckoutItemProvider;
import org.eclipse.papyrus.cdo.internal.ui.widgets.ActionButton;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.actions.CreateFolderAction;

public class CheckoutBrowseDialog
extends TitleAreaDialog {
    private final String windowTitle;
    private final String title;
    private final String message;
    private final int style;
    private final CDOCheckout checkout;
    private boolean allowOverwrite = false;
    private EClass nodeTypeFilter = EresourcePackage.Literals.CDO_RESOURCE_NODE;
    private TreeViewer tree;
    private Text nameText;
    private URI initialURI;
    private CDOResourceNode selection;
    private String name;
    private IListener viewerRefresh;

    public CheckoutBrowseDialog(Shell parentShell, String title, String message, CDOView view, int style) {
        this(parentShell, Messages.CheckoutBrowseDialog_windowTitle, title, message, view, style);
    }

    public CheckoutBrowseDialog(Shell parentShell, String windowTitle, String title, String message, CDOView view, int style) {
        super(parentShell);
        this.windowTitle = windowTitle;
        this.title = title;
        this.message = message;
        this.style = this.checkStyle(style);
        this.checkout = view == null ? null : CDOExplorerUtil.getCheckout((Object)view);
        this.setHelpAvailable(false);
    }

    int checkStyle(int style) {
        this.setShellStyle(this.getShellStyle() | style & 0xFFFFCFFF);
        return style & 0x3000;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.windowTitle);
        newShell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CheckoutBrowseDialog.this.shellDisposed();
            }
        });
    }

    private void shellDisposed() {
        if (this.viewerRefresh != null) {
            CDOCheckout[] cDOCheckoutArray = CDOExplorerUtil.getCheckoutManager().getCheckouts();
            int n = cDOCheckoutArray.length;
            int n2 = 0;
            while (n2 < n) {
                CDOCheckout next = cDOCheckoutArray[n2];
                if (next.isOpen()) {
                    next.getView().removeListener(this.viewerRefresh);
                }
                ++n2;
            }
        }
    }

    public boolean isAllowOverwrite() {
        return this.allowOverwrite;
    }

    public void setAllowOverwrite(boolean allowOverwrite) {
        this.allowOverwrite = allowOverwrite;
    }

    public EClass getNodeTypeFilter() {
        return this.nodeTypeFilter;
    }

    public void setNodeTypeFilter(EClass nodeTypeFilter) {
        boolean defaulted = nodeTypeFilter == null || !EresourcePackage.Literals.CDO_RESOURCE_NODE.isSuperTypeOf(nodeTypeFilter);
        this.nodeTypeFilter = defaulted ? EresourcePackage.Literals.CDO_RESOURCE_NODE : nodeTypeFilter;
    }

    public URI getInitialURI() {
        return this.initialURI;
    }

    public void setInitialURI(URI initialURI) {
        this.initialURI = initialURI;
    }

    public URI getSelectedURI() {
        return this.getReturnCode() != 0 ? null : this.basicGetSelectedURI();
    }

    private URI basicGetSelectedURI() {
        URI result = null;
        if (this.selection != null) {
            String resourceName;
            result = this.selection.getURI();
            if (this.name != null && (resourceName = Strings.emptyToNull((String)this.name)) != null) {
                if (!(this.selection instanceof CDOResourceFolder)) {
                    result = result.trimSegments(1);
                }
                result = result.appendSegment(resourceName);
            }
        }
        return result;
    }

    boolean isOpenStyle() {
        return (this.style & 0x1000) != 0;
    }

    boolean isSaveStyle() {
        return (this.style & 0x2000) != 0;
    }

    CDOCheckout getCheckout() {
        return this.checkout;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(this.title);
        this.setMessage(this.message);
        Composite main = (Composite)super.createDialogArea(parent);
        Composite result = new Composite(main, 0);
        result.setLayout((Layout)new GridLayout(this.isSaveStyle() ? 3 : 1, false));
        result.setLayoutData((Object)new GridData(1808));
        this.tree = new TreeViewer(result, 2820);
        this.tree.getControl().setLayoutData((Object)new GridData(4, 4, true, true, this.isSaveStyle() ? 2 : 1, 1));
        CheckoutItemProvider itemProvider = this.getCheckout() == null ? new CheckoutItemProvider(null, this.showConnectedRepositories()) : new CheckoutItemProvider(null, this.getCheckout());
        this.tree.setContentProvider((IContentProvider)itemProvider);
        this.tree.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)itemProvider, PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
        this.tree.setSorter((ViewerSorter)itemProvider);
        this.tree.setInput((Object)CDOExplorerUtil.getCheckoutManager());
        CDOCheckout[] cDOCheckoutArray = CDOExplorerUtil.getCheckoutManager().getCheckouts();
        int n = cDOCheckoutArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOCheckout next = cDOCheckoutArray[n2];
            if (next.isOpen()) {
                next.getView().addListener(this.getViewerRefresh());
            }
            ++n2;
        }
        if (this.isSaveStyle()) {
            Composite actionButtons = new Composite(result, 0);
            actionButtons.setLayoutData((Object)new GridData(131072, 128, false, false));
            actionButtons.setLayout((Layout)new RowLayout(512));
            ActionButton newFolderButton = new ActionButton(Messages.CheckoutBrowseDialog_newFolderAction, (BaseSelectionListenerAction)new CreateFolderAction((IShellProvider)this), 8);
            newFolderButton.attach((StructuredViewer)this.tree);
            newFolderButton.createControl(actionButtons);
            Label label = new Label(result, 0);
            label.setText(Messages.CheckoutBrowseDialog_nameLabel);
            GridData gd = new GridData(32);
            gd.verticalIndent = this.convertVerticalDLUsToPixels(8);
            label.setLayoutData((Object)gd);
            this.nameText = new Text(result, 2048);
            gd = new GridData(4, 128, true, false, 2, 1);
            gd.verticalIndent = this.convertVerticalDLUsToPixels(8);
            this.nameText.setLayoutData((Object)gd);
        }
        if (this.getInitialURI() != null) {
            this.initializeSelection();
        } else if (this.getCheckout() != null) {
            this.selection = this.getCheckout().getView().getRootResource();
        }
        this.tree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                CheckoutBrowseDialog.this.selection = sel.isEmpty() ? (CheckoutBrowseDialog.this.getCheckout() != null ? CheckoutBrowseDialog.this.getCheckout().getView().getRootResource() : null) : (CDOResourceNode)CDOUtils.adapt((Object)sel.getFirstElement(), CDOResourceNode.class);
                CheckoutBrowseDialog.this.validateSelection();
            }
        });
        if (this.nameText != null) {
            this.nameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    CheckoutBrowseDialog.this.name = Strings.emptyToNull((String)CheckoutBrowseDialog.this.nameText.getText().trim());
                    CheckoutBrowseDialog.this.validateSelection();
                }
            });
        }
        return result;
    }

    private IElementFilter showConnectedRepositories() {
        return new IElementFilter(){

            public boolean filter(Object element) {
                boolean result = false;
                if (element instanceof CDOCheckout) {
                    result = ((CDOCheckout)element).isOpen();
                }
                return result;
            }
        };
    }

    private void initializeSelection() {
        String path;
        URI uri = this.getInitialURI();
        CDOView view = this.getCheckout().getView();
        if (view.hasResource(path = CDOURIUtil.extractResourcePath((URI)uri))) {
            this.selection = view.getResourceNode(path);
            this.tree.setSelection((ISelection)new StructuredSelection((Object)this.selection));
            this.tree.expandToLevel((Object)this.selection, 1);
            if (this.nameText != null) {
                this.name = this.selection.getName();
                this.nameText.setText(this.name);
            }
        } else if (uri.segmentCount() > 0) {
            URI parent = uri.trimSegments(1);
            path = CDOURIUtil.extractResourcePath((URI)parent);
            if (view.hasResource(path)) {
                this.selection = view.getResourceNode(path);
                CDOCheckout treeSelection = this.selection.isRoot() ? this.getCheckout() : this.selection;
                this.tree.setSelection((ISelection)new StructuredSelection((Object)treeSelection), true);
                this.tree.expandToLevel((Object)treeSelection, 1);
                if (this.nameText != null) {
                    this.name = uri.lastSegment();
                    this.nameText.setText(this.name);
                }
            }
        } else {
            this.selection = view.getRootResource();
            CDOCheckout treeSelection = this.getCheckout();
            this.tree.setSelection((ISelection)new StructuredSelection((Object)treeSelection), true);
            this.tree.expandToLevel((Object)treeSelection, 1);
        }
    }

    private void validateSelection() {
        String error = null;
        String warning = null;
        String info = null;
        boolean disable = false;
        if (this.name != null && !URI.validSegment((String)this.name)) {
            error = Messages.CheckoutBrowseDialog_invalidURISeg;
        }
        if (error == null) {
            if (this.selection == null) {
                disable = true;
            } else {
                String path = CDOURIUtil.extractResourcePath((URI)this.basicGetSelectedURI());
                CDOView view = this.selection.cdoView();
                if (this.isOpenStyle() && !view.hasResource(path)) {
                    error = Messages.CheckoutBrowseDialog_noSuchResource;
                } else if (this.isOpenStyle()) {
                    CDOResourceNode node = view.getResourceNode(path);
                    if (!this.getNodeTypeFilter().isInstance((Object)node)) {
                        disable = true;
                        info = NLS.bind((String)Messages.CheckoutBrowseDialog_wrongSelection, (Object)this.getNodeType(this.getNodeTypeFilter()));
                    }
                } else if (this.isSaveStyle() && view.hasResource(path)) {
                    if (this.isAllowOverwrite()) {
                        warning = Messages.CheckoutBrowseDialog_existsWarning;
                    } else {
                        error = Messages.CheckoutBrowseDialog_existsError;
                    }
                }
            }
        }
        this.getButton(0).setEnabled(!disable && error == null);
        if (error != null) {
            this.setMessage(error, 3);
        } else if (warning != null) {
            this.setMessage(warning, 2);
        } else if (info != null) {
            this.setMessage(info, 1);
        } else {
            this.setMessage(this.message);
        }
    }

    private String getNodeType(EClass nodeClass) {
        String result = Messages.CheckoutBrowseDialog_anyNode;
        if (nodeClass.getEPackage() == EresourcePackage.eINSTANCE) {
            switch (nodeClass.getClassifierID()) {
                case 2: {
                    result = Messages.CheckoutBrowseDialog_modelKind;
                    break;
                }
                case 1: {
                    result = Messages.CheckoutBrowseDialog_folderKind;
                    break;
                }
                case 10: {
                    result = Messages.CheckoutBrowseDialog_textKind;
                    break;
                }
                case 9: {
                    result = Messages.CheckoutBrowseDialog_binKind;
                    break;
                }
                case 8: {
                    result = Messages.CheckoutBrowseDialog_fileKind;
                    break;
                }
                case 7: {
                    result = Messages.CheckoutBrowseDialog_leafKind;
                }
            }
        }
        return result;
    }

    private IListener getViewerRefresh() {
        if (this.viewerRefresh == null) {
            this.viewerRefresh = new IListener(){

                public void notifyEvent(IEvent event) {
                    if (event instanceof CDOViewInvalidationEvent && CheckoutBrowseDialog.this.getContents() != null && !CheckoutBrowseDialog.this.getContents().isDisposed() && UIUtil.ensureUIThread(this, event)) {
                        CheckoutBrowseDialog.this.tree.refresh();
                    }
                }
            };
        }
        return this.viewerRefresh;
    }
}

