/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.dnd;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;

public final class CDOResourceURITransferData {
    private static final String NS_URI = "http://www.eclipse.org/papyrus/1.0.0/cdo/private/dnd";
    private static final EClass ECLASS = (EClass)EPackage.Registry.INSTANCE.getEPackage("http://www.eclipse.org/papyrus/1.0.0/cdo/private/dnd").getEClassifier(CDOResourceURITransferData.class.getSimpleName());
    private static final EAttribute URIS = (EAttribute)ECLASS.getEStructuralFeature("resourceURIs");
    private final List<URI> uris;

    public CDOResourceURITransferData(Iterable<? extends CDOResourceNode> resourceNodes) {
        this((List<URI>)ImmutableList.copyOf((Iterable)Iterables.transform(resourceNodes, (Function)new Function<CDOResourceNode, URI>(){

            public URI apply(CDOResourceNode input) {
                return input.getURI();
            }
        })));
    }

    private CDOResourceURITransferData(List<URI> uris) {
        this.uris = uris;
    }

    public List<URI> getURIs() {
        return this.uris;
    }

    public byte[] serialize() {
        ByteArrayDataOutput data = ByteStreams.newDataOutput();
        data.writeInt(this.uris.size());
        for (URI next : this.uris) {
            data.writeUTF(next.toString());
        }
        return data.toByteArray();
    }

    public static CDOResourceURITransferData deserialize(byte[] serial) {
        ImmutableList.Builder uris = ImmutableList.builder();
        ByteArrayDataInput data = ByteStreams.newDataInput((byte[])serial);
        int count = data.readInt();
        int i = 0;
        while (i < count) {
            uris.add((Object)URI.createURI((String)data.readUTF()));
            ++i;
        }
        return new CDOResourceURITransferData((List<URI>)uris.build());
    }

    public static boolean isCDOResourceURITransferData(EObject object) {
        return ECLASS.isInstance((Object)object);
    }

    public static CDOResourceURITransferData fromEObject(EObject object) {
        List uris = CDOResourceURITransferData.isCDOResourceURITransferData(object) ? (List)object.eGet((EStructuralFeature)URIS) : Collections.emptyList();
        return new CDOResourceURITransferData(uris);
    }

    public EObject asEObject() {
        EObject result = EcoreUtil.create((EClass)ECLASS);
        result.eSet((EStructuralFeature)URIS, this.getURIs());
        return result;
    }
}

